/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.record.writer.internal.annotations.ValidationUtils;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import java.util.Map;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class BeanAnnotationMethodTagData
extends MethodTagData {
    private boolean beenValidatedOnce_ = false;

    public BeanAnnotationMethodTagData(String name, Map data, MethodDeclaration md) {
        super(name, data, md);
    }

    public BeanAnnotationMethodTagData(TagData td) {
        super(td);
    }

    public boolean beenValidatedOnce() {
        return this.beenValidatedOnce_;
    }

    protected void setValidated() {
        this.beenValidatedOnce_ = true;
    }

    public boolean isValid() {
        boolean isValid = true;
        this.beenValidatedOnce_ = true;
        String tagName = this.getName();
        if (tagName.equals("type-descriptor.depending-on-control")) {
            isValid = this.validateDependingOnControl();
        } else if (tagName.equals("type-descriptor.initial-value")) {
            isValid = this.validateInitialValue();
        } else if (tagName.equals("type-descriptor.restriction")) {
            isValid = this.validateRestriction();
        }
        return isValid;
    }

    private boolean validateDependingOnControl() {
        boolean isValid = true;
        String maxOccurances = this.get("maxOccurances");
        if (maxOccurances != null) {
            isValid = isValid && ValidationUtils.validatePositiveInteger(maxOccurances, "maxOccurances", (TagData)this);
        }
        return isValid;
    }

    private boolean validateInitialValue() {
        boolean isValid = true;
        String kind = this.get("kind");
        if (kind != null) {
            isValid = isValid && this.validEnum(kind, "kind", ValidationUtils.getKindChoice());
        }
        return isValid;
    }

    private boolean validateRestriction() {
        String maxLength;
        String upperBound;
        boolean isValid = true;
        boolean isLowerBoundValid = false;
        boolean isUpperBoundValid = false;
        MethodTagData.FieldInf fieldInfo = this.getFieldInfo();
        String returnType = fieldInfo.fieldType;
        String lowerBound = this.get("lowerBound");
        if (lowerBound != null) {
            isLowerBoundValid = ValidationUtils.validateNumberForType(lowerBound, returnType, "lowerBound", (TagData)this);
            boolean bl = isValid = isValid && isLowerBoundValid;
        }
        if ((upperBound = this.get("upperBound")) != null) {
            isUpperBoundValid = ValidationUtils.validateNumberForType(upperBound, returnType, "upperBound", (TagData)this);
            boolean bl = isValid = isValid && isUpperBoundValid;
        }
        if (isLowerBoundValid && isUpperBoundValid) {
            boolean bl = isValid = isValid && ValidationUtils.validateLowerLessThanUpperNumberForType(lowerBound, upperBound, returnType, "lowerBound", "upperBound", (TagData)this);
        }
        if ((maxLength = this.get("maxLength")) != null) {
            isValid = isValid && ValidationUtils.validatePositiveInteger(maxLength, "maxLength", (TagData)this);
        }
        return isValid;
    }
}

