/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.base.auth;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.pdtools.common.component.core.base.Messages;
import com.ibm.pdtools.common.component.core.base.PDTCCcoreBase;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionChangeListener;
import com.ibm.pdtools.common.component.jhost.comms.ITheCredential;
import com.ibm.pdtools.common.component.jhost.comms.TheCredential;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class AuthenticationFrameworkUtilitiesImp {
    private static ITheCredential PDToolsRSE = null;

    public static void setPDToolsRSE(ITheCredential pDToolsRSE) {
        PDToolsRSE = pDToolsRSE;
    }

    public static ITheCredential getPDToolsRSE() {
        return PDToolsRSE;
    }

    public static Collection<HostDetails> getSystemInformation(String connCategory, String keyEncoding, String keyHostType) {
        HashMap<String, HostDetails> uniqueHosts = new HashMap<String, HostDetails>();
        ConnectionsPlugin plugin = ConnectionsPlugin.getDefault();
        Objects.requireNonNull(plugin, "Can not get Instance of ConnectionsPlugin");
        IConnectionService aService = plugin.getConnectionService();
        IConnectionManager aManager = aService.getConnectionManager();
        Map configs = aManager.getConnectionProfilesByDescriptor();
        if (configs == null) {
            return uniqueHosts.values();
        }
        Set connKeys = configs.keySet();
        if (connKeys == null) {
            return uniqueHosts.values();
        }
        for (IConnectionDescriptor aDesc : connKeys) {
            Collection configList;
            if (!aDesc.getCategory().getId().equalsIgnoreCase(connCategory) || (configList = (Collection)configs.get(aDesc)) == null) continue;
            for (ConnectionProfile aConfig : configList) {
                HostDetails aHostDetails = AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConfig, keyEncoding, keyHostType);
                uniqueHosts.put(aHostDetails.getHostID(), aHostDetails);
            }
        }
        return uniqueHosts.values();
    }

    public static Collection<HostDetails> getSystemInformation(String connCategory, String keyEncoding, String keyHostType, String keyBidiFormat) {
        HashMap<String, HostDetails> uniqueHosts = new HashMap<String, HostDetails>();
        ConnectionsPlugin plugin = ConnectionsPlugin.getDefault();
        Objects.requireNonNull(plugin, "Can not get Instance of ConnectionsPlugin");
        IConnectionService aService = plugin.getConnectionService();
        IConnectionManager aManager = aService.getConnectionManager();
        Map configs = aManager.getConnectionProfilesByDescriptor();
        if (configs == null) {
            return uniqueHosts.values();
        }
        Set connKeys = configs.keySet();
        if (connKeys == null) {
            return uniqueHosts.values();
        }
        for (IConnectionDescriptor aDesc : connKeys) {
            Collection configList;
            if (!aDesc.getCategory().getId().equalsIgnoreCase(connCategory) || (configList = (Collection)configs.get(aDesc)) == null) continue;
            for (ConnectionProfile aConfig : configList) {
                HostDetails aHostDetails = AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConfig, keyEncoding, keyHostType, keyBidiFormat);
                uniqueHosts.put(aHostDetails.getHostID(), aHostDetails);
            }
        }
        return uniqueHosts.values();
    }

    public static HostDetails getSystemInformation(String connCategory, String connID, String rdzDesc, String hostName, int portNumber, String userName, String password, String keyEncoding, String keyHostType) {
        IConnectionService aService = ConnectionsPlugin.getDefault().getConnectionService();
        IConnectionManager aManager = aService.getConnectionManager();
        Map configs = aManager.getConnectionProfilesByDescriptor();
        if (configs == null) {
            return null;
        }
        Set connKeys = configs.keySet();
        if (connKeys == null) {
            return null;
        }
        for (IConnectionDescriptor aDesc : connKeys) {
            Object configList;
            if (!aDesc.getCategory().getId().equalsIgnoreCase(connCategory) || (configList = (Collection)configs.get(aDesc)) == null) continue;
            Iterator iterator = configList.iterator();
            while (iterator.hasNext()) {
                AuthDetails anAuthDetails;
                ConnectionProfile aConfig = (ConnectionProfile)iterator.next();
                HostDetails aHostDetails = AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConfig, keyEncoding, keyHostType);
                if (!aHostDetails.getHostname().equalsIgnoreCase(hostName) || aHostDetails.getPortNumber() != portNumber || (anAuthDetails = AuthenticationFrameworkUtilitiesImp.getUserNameAndPassword(new TheHost(aHostDetails.getHostname(), connID), connCategory, false)) == null || !userName.equalsIgnoreCase(anAuthDetails.getUsername()) || !password.equals(anAuthDetails.getPassword())) continue;
                return aHostDetails;
            }
        }
        String newCredentialDescription = MessageFormat.format(Messages.AuthenticationFrameworkUtilities_PDT_CRED_X, SimpleDateFormat.getInstance().format(new Date()));
        for (IConnectionDescriptor aDesc : connKeys) {
            Collection configList;
            if (!aDesc.getCategory().getId().equalsIgnoreCase(connCategory) || (configList = (Collection)configs.get(aDesc)) == null) continue;
            for (ConnectionProfile aConfig : configList) {
                HostDetails aHostDetails = AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConfig, keyEncoding, keyHostType);
                if (!aHostDetails.getHostname().equalsIgnoreCase(hostName) || aHostDetails.getPortNumber() != portNumber) continue;
                AuthDetails anAuthDetails = AuthenticationFrameworkUtilitiesImp.getUserNameAndPassword(new TheHost(aHostDetails.getHostname(), connID), connCategory, false);
                if (anAuthDetails == null) {
                    CredentialsConfiguration credInfo = AuthenticationFrameworkUtilitiesImp.getCredentials(userName, password);
                    if (credInfo == null) {
                        credInfo = AuthenticationFrameworkUtilitiesImp.createNewCredential(userName, password, newCredentialDescription, true);
                    }
                    ConnectionsPlugin.getDefault().getCredentialsManager().update(credInfo);
                    ConnectionsPlugin.getDefault().getCredentialsManager().update(credInfo, true);
                    aConfig.getConnectionConfiguration().setCredentialsID(credInfo.getID());
                    ConnectionsPlugin.getDefault().getConnectionCredentialsManager().associate(aConfig.getId(), credInfo.getID());
                    return AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConfig, keyEncoding, keyHostType);
                }
                if (!userName.equalsIgnoreCase(anAuthDetails.getUsername()) || anAuthDetails.getPassword() != null && !anAuthDetails.getPassword().isEmpty()) continue;
                CredentialsConfiguration credInfo = AuthenticationFrameworkUtilitiesImp.getCredentials(userName, password);
                if (credInfo == null) {
                    credInfo = AuthenticationFrameworkUtilitiesImp.createNewCredential(userName, password, newCredentialDescription, true);
                }
                ConnectionsPlugin.getDefault().getCredentialsManager().update(credInfo);
                ConnectionsPlugin.getDefault().getCredentialsManager().update(credInfo, true);
                aConfig.getConnectionConfiguration().setCredentialsID(credInfo.getID());
                ConnectionsPlugin.getDefault().getConnectionCredentialsManager().associate(aConfig.getId(), credInfo.getID());
                return AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConfig, keyEncoding, keyHostType);
            }
        }
        IWritableConnectionProvider localConnectionProvider = ConnectionsPlugin.getDefault().getConnectionProviderRegistry().getLocalConnectionProvider();
        ConnectionParameters parms = localConnectionProvider.createConnectionParameters(rdzDesc, connID, new ConnectionParameters.AttributeValue[]{ConnectionParameters.av((String)"host", (String)hostName), ConnectionParameters.av((String)"port", (String)("" + portNumber))});
        ConnectionProfile aConnConfig = ConnectionsPlugin.getDefault().getConnectionManager().getConnectionProfile(parms.getId());
        CredentialsConfiguration credInfo = AuthenticationFrameworkUtilitiesImp.getCredentials(userName, password);
        if (credInfo == null) {
            credInfo = AuthenticationFrameworkUtilitiesImp.createNewCredential(userName, password, newCredentialDescription, true);
        }
        ConnectionsPlugin.getDefault().getCredentialsManager().update(credInfo);
        ConnectionsPlugin.getDefault().getCredentialsManager().update(credInfo, true);
        aConnConfig.getConnectionConfiguration().setCredentialsID(credInfo.getID());
        ConnectionsPlugin.getDefault().getConnectionCredentialsManager().associate(aConnConfig.getId(), credInfo.getID());
        return AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConnConfig, keyEncoding, keyHostType);
    }

    private static CredentialsConfiguration getCredentials(String userName, String password) {
        Collection list = ConnectionsPlugin.getDefault().getCredentialsManager().getAllCredentials();
        for (CredentialsConfiguration credInfo : list) {
            if (!userName.equals(credInfo.getUserID()) || !password.equals(credInfo.getPassword())) continue;
            return credInfo;
        }
        return null;
    }

    private static CredentialsConfiguration createNewCredential(String userName, String password, String description, boolean savePassword) {
        CredentialsConfiguration aNewCred = CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)(description != null ? description : userName), (String)userName, (String)password, (boolean)savePassword);
        ConnectionsPlugin.getDefault().getCredentialsManager().update(aNewCred);
        return aNewCred;
    }

    public static boolean clearPassword(String connCategory, String hostID) {
        ConnectionProfile aConnConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(hostID, connCategory);
        if (aConnConfig == null) {
            return false;
        }
        CredentialsConfiguration credentials = aConnConfig.getCredentials();
        if (credentials != null) {
            ConnectionsPlugin.getDefault().getCredentialsManager().invalidate(credentials.getID());
        }
        return true;
    }

    public static boolean clearPassword(String connCategory, String connID, String hostID) {
        return false;
    }

    public static boolean setPassword(String newPassword, String connCategory, String connID, String hostID) {
        ConnectionProfile aConnConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(hostID, connCategory);
        if (aConnConfig == null) {
            return false;
        }
        aConnConfig.getCredentials().setPassword(newPassword != null ? newPassword : "");
        ConnectionsPlugin.getDefault().getCredentialsManager().update(aConnConfig.getCredentials(), true);
        return true;
    }

    public static boolean invokeChangePasswordDialog(String connCategory, String connID, String hostID) {
        ConnectionProfile aConnConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(hostID, connCategory);
        if (aConnConfig == null) {
            return false;
        }
        CredentialsConfiguration aCredConfig = aConnConfig.getCredentials();
        if (aCredConfig == null) {
            return false;
        }
        final AtomicBoolean executed = new AtomicBoolean(false);
        ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().displayChangePasswordDialog(aCredConfig.getID(), new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.AuthenticationFrameworkUtilities_0, 1);
                monitor.worked(1);
                monitor.done();
                executed.set(true);
            }
        });
        return executed.get();
    }

    public static HostDetails getHostDetails(String hostID, String connCategory, String keyEncoding, String keyHostType, String keyBidiFormat) {
        ConnectionsPlugin plugin = ConnectionsPlugin.getDefault();
        Objects.requireNonNull(plugin, "Can not get Instance of ConnectionsPlugin");
        IConnectionService aService = plugin.getConnectionService();
        IConnectionManager aManager = aService.getConnectionManager();
        Map configs = aManager.getConnectionProfilesByDescriptor();
        if (configs == null) {
            return null;
        }
        Set connKeys = configs.keySet();
        if (connKeys == null) {
            return null;
        }
        for (IConnectionDescriptor aDesc : connKeys) {
            Collection configList = (Collection)configs.get(aDesc);
            if (configList == null) continue;
            for (ConnectionProfile aConfig : configList) {
                if (!aConfig.getId().equals(hostID)) continue;
                return AuthenticationFrameworkUtilitiesImp.prepareHostDetails(aConfig, keyEncoding, keyHostType, keyBidiFormat);
            }
        }
        return null;
    }

    public static void openDialogForNewConnection(final String connID) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().createConnectionConfiguration(new String[]{connID});
                }
                catch (NullPointerException e) {
                    PDLoggerJhost.get(this.getClass()).error((Object)"NullPointerException caught while opening Connection dialog.", (Throwable)e);
                }
            }
        });
    }

    public static void openDialogForModifyConnection(final String hostID, final String connCategory, final String connID) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionProfile aConnConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(hostID, connCategory);
                if (aConnConfig == null) {
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().createConnectionConfiguration(new String[]{connID});
                } else {
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().editConnectionParameters(aConnConfig.getId());
                }
            }
        });
    }

    public static boolean deleteConnection(String hostID, String connCategory) {
        ConnectionProfile connConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(hostID, connCategory);
        if (connConfig != null && connConfig.getConnectionProvider() instanceof IWritableConnectionProvider) {
            ((IWritableConnectionProvider)connConfig.getConnectionProvider()).removeConfiguration(connConfig.getId());
            return true;
        }
        return false;
    }

    public static boolean canDelete(String hostID, String connCategory) {
        ConnectionProfile connConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(hostID, connCategory);
        if (connConfig == null) {
            return false;
        }
        return connConfig.getConnectionProvider() instanceof IWritableConnectionProvider;
    }

    public static AuthDetails getUserNameAndPasswordDialogIfRequired(TheHost theHost, String connCategory, Method PDCommonConnectionProvider_setExplicitConnectIssued, PDLoggerJhost logger) {
        ConnectionProfile aConnConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(theHost.getConnectionName(), connCategory);
        if (aConnConfig == null) {
            try {
                PDCommonConnectionProvider_setExplicitConnectIssued.invoke(null, null);
                if (PDToolsRSE != null) {
                    TheCredential theCredential = PDToolsRSE.getCredential(theHost);
                    if (theCredential != null) {
                        return new AuthDetails("PDToolsRSE", theCredential.getUserId(), theCredential.getPass());
                    }
                    throw new Exception();
                }
                throw new Exception();
            }
            catch (Exception e) {
                TheCredential theCredential;
                ConnectionsPlugin.getDefault().getConnectionService().connect(theHost.getConnectionName());
                if (PDToolsRSE != null && (theCredential = PDToolsRSE.getCredential(theHost)) != null) {
                    return new AuthDetails("PDToolsRSE", theCredential.getUserId(), theCredential.getPass());
                }
                return AuthenticationFrameworkUtilitiesImp.getUserNameAndPasswordDialogIfRequiredSlave(theHost, connCategory);
            }
        }
        CredentialsConfiguration cc = aConnConfig.getCredentials();
        try {
            PDCommonConnectionProvider_setExplicitConnectIssued.invoke(null, null);
            try {
                if (PDToolsRSE != null) {
                    ConnectionParameters cp = aConnConfig.getConnectionParameters();
                    TheCredential theCredential = PDToolsRSE.getCredential(new TheHost(cp.getAttribute("host"), cp.getName()));
                    if (theCredential != null) {
                        if (cc != null && cc.isSavePassword()) {
                            cc.setUserID(theCredential.getUserId());
                            cc.setPassword(theCredential.getPass());
                        }
                        if (theCredential.getPass() != null) {
                            return new AuthDetails("PDToolsRSE", theCredential.getUserId(), theCredential.getPass());
                        }
                    }
                    throw new Exception();
                }
                throw new Exception();
            }
            catch (Exception e) {
                ConnectionParameters cp;
                TheCredential theCredential;
                ConnectionsPlugin.getDefault().getConnectionService().connect(aConnConfig.getId());
                if (PDToolsRSE != null && (theCredential = PDToolsRSE.getCredential(new TheHost((cp = aConnConfig.getConnectionParameters()).getAttribute("host"), cp.getName()))) != null) {
                    if (cc == null || !cc.isSavePassword()) {
                        return AuthenticationFrameworkUtilitiesImp.getUserNameAndPasswordDialogIfRequiredSlave(theHost, connCategory);
                    }
                    cc.setUserID(theCredential.getUserId());
                    cc.setPassword(theCredential.getPass());
                    return new AuthDetails("PDToolsRSE", theCredential.getUserId(), theCredential.getPass());
                }
                return AuthenticationFrameworkUtilitiesImp.getUserNameAndPasswordDialogIfRequiredSlave(theHost, connCategory);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception was thrown while retrieving user name and password; conn config=" + String.valueOf(aConnConfig) + " Host=" + (aConnConfig == null ? null : aConnConfig.getConnectionConfiguration().getHost()) + " Port=" + String.valueOf(aConnConfig == null ? null : Integer.valueOf(aConnConfig.getConnectionConfiguration().getPort()))), (Throwable)e);
            return null;
        }
    }

    private static AuthDetails getUserNameAndPasswordDialogIfRequiredSlave(TheHost theHost, String connCategory) {
        ConnectionProfile aConnConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(theHost.getConnectionName(), connCategory);
        if (aConnConfig == null) {
            return null;
        }
        CredentialsConfiguration aCredConfig = aConnConfig.getCredentials();
        if (aCredConfig != null && aCredConfig.getUserID() != null && aCredConfig.getUserID().trim().length() > 0 && aCredConfig.getPassword() != null && aCredConfig.getPassword().length() > 0) {
            return new AuthDetails(aCredConfig.getName(), aCredConfig.getUserID(), aCredConfig.getPassword());
        }
        if (aCredConfig == null || aCredConfig.getUserID() == null || aCredConfig.getUserID().trim().isEmpty()) {
            return null;
        }
        if (aCredConfig.getPassword() == null || aCredConfig.getPassword().isEmpty()) {
            AuthenticationFrameworkUtilitiesImp.clearPassword(connCategory, theHost.getConnectionName());
            return null;
        }
        return null;
    }

    public static AuthDetails getUserNameAndPassword(TheHost theHost, String connCategory, boolean connectedOnly) {
        ConnectionParameters cp;
        TheCredential theCredential;
        if (theHost == null) {
            return null;
        }
        ConnectionProfile aConnConfig = AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(theHost.getConnectionName(), connCategory);
        if (aConnConfig == null) {
            return null;
        }
        if (aConnConfig.getConnectionConfiguration() == null) {
            return null;
        }
        ConnectionConfiguration config = aConnConfig.getConnectionConfiguration();
        if (config.getUserID() != null && config.getUserID().trim().length() > 0 && config.getPassword() != null && config.getPassword().trim().length() > 0) {
            return new AuthDetails(config.getName(), config.getUserID(), config.getPassword());
        }
        if (PDToolsRSE != null && (theCredential = PDToolsRSE.getCredential(new TheHost((cp = aConnConfig.getConnectionParameters()).getAttribute("host"), cp.getName()))) != null && theCredential.getUserId() != null && theCredential.getUserId().trim().length() > 0 && theCredential.getPass() != null && theCredential.getPass().trim().length() > 0) {
            return new AuthDetails(theCredential.getUserId(), theCredential.getUserId(), theCredential.getPass());
        }
        return null;
    }

    private static ConnectionProfile retrieveConnConfig(String hostID, String connCategory) {
        ConnectionsPlugin plugin = ConnectionsPlugin.getDefault();
        Objects.requireNonNull(plugin, "Can not get Instance of ConnectionsPlugin");
        IConnectionService aService = plugin.getConnectionService();
        IConnectionManager aManager = aService.getConnectionManager();
        Map configs = aManager.getConnectionProfilesByDescriptor();
        if (configs == null) {
            return null;
        }
        Set connKeys = configs.keySet();
        if (connKeys == null) {
            return null;
        }
        for (IConnectionDescriptor aDesc : connKeys) {
            Collection list = (Collection)configs.get(aDesc);
            if (list == null) continue;
            for (ConnectionProfile aConfig : list) {
                if (!aConfig.getId().equals(hostID)) continue;
                return aConfig;
            }
        }
        return null;
    }

    public static boolean connectionExists(String hostID, String connCategory) {
        return AuthenticationFrameworkUtilitiesImp.retrieveConnConfig(hostID, connCategory) != null;
    }

    public static void addPDConnectionChangeListener(final IPDToolsConnectionChangeListener listener, final String connCategory, final String keyEncoding, final String keyHostType, final String keyBidiFormat) {
        IConnectionService aService = ConnectionsPlugin.getDefault().getConnectionService();
        IConnectionManager aManager = aService.getConnectionManager();
        aManager.addListener(new ConnectionManagerListener(){

            public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
                try {
                    if (!event.getConnectionProfile().getConnectionDescriptor().getCategory().getId().equalsIgnoreCase(connCategory)) {
                        return;
                    }
                    if (event instanceof ConnectionManagerListener.ConnectionProfileAddedEvent) {
                        ConnectionManagerListener.ConnectionProfileAddedEvent addedEvent = (ConnectionManagerListener.ConnectionProfileAddedEvent)event;
                        listener.newConnection(AuthenticationFrameworkUtilitiesImp.prepareHostDetails(addedEvent.getConnectionProfile(), keyEncoding, keyHostType, keyBidiFormat));
                    } else if (event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                        ConnectionManagerListener.ConnectionProfileRemovedEvent removedEvent = (ConnectionManagerListener.ConnectionProfileRemovedEvent)event;
                        listener.deletedConnection(removedEvent.getConnectionProfile().getId());
                    } else if (event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent) {
                        ConnectionManagerListener.ConnectionProfileUpdatedEvent updatedEvent = (ConnectionManagerListener.ConnectionProfileUpdatedEvent)event;
                        listener.updatedConnection(AuthenticationFrameworkUtilitiesImp.prepareHostDetails(updatedEvent.getOldConnectionProfile(), keyEncoding, keyHostType, keyBidiFormat), AuthenticationFrameworkUtilitiesImp.prepareHostDetails(updatedEvent.getConnectionProfile(), keyEncoding, keyHostType, keyBidiFormat));
                    } else {
                        PDLoggerJhost.get(AuthenticationFrameworkUtilitiesImp.class).error((Object)("Unknown ConnectionManagerEvent: " + event.getClass().getName()));
                    }
                }
                catch (Exception e) {
                    PDLoggerJhost.get(((Object)((Object)this)).getClass()).error((Throwable)e);
                    PDTCCcoreBase.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.pdtools.common.component.core.base", "A connection listener threw an exception!", (Throwable)e));
                    throw e;
                }
            }
        });
    }

    private static HostDetails prepareHostDetails(ConnectionProfile aConfig, String keyEncoding, String keyHostType) {
        String description = aConfig.getName();
        if (description == null) {
            description = "";
        }
        String encoding = aConfig.getAttribute(keyEncoding);
        HostType hostType = HostType.getDefaultHostType();
        String hostTypeStr = aConfig.getAttribute(keyHostType);
        if (hostTypeStr != null && HostType.validHostType((String)hostTypeStr)) {
            hostType = HostType.parseHostType((String)hostTypeStr);
        }
        if (encoding == null) {
            encoding = hostType.getDefaultEncoding();
        }
        HostDetails aHostDetails = new HostDetails(aConfig.getId(), aConfig.getConnectionConfiguration().getHost(), aConfig.getConnectionConfiguration().getPort(), description, encoding, hostType);
        return aHostDetails;
    }

    private static HostDetails prepareHostDetails(ConnectionProfile aConfig, String keyEncoding, String keyHostType, String keyBidiFormat) {
        String bidiFormat;
        String description = aConfig.getName();
        if (description == null) {
            description = "";
        }
        String encoding = aConfig.getAttribute(keyEncoding);
        HostType hostType = HostType.getDefaultHostType();
        String hostTypeStr = aConfig.getAttribute(keyHostType);
        if (hostTypeStr != null && HostType.validHostType((String)hostTypeStr)) {
            hostType = HostType.parseHostType((String)hostTypeStr);
        }
        if (encoding == null) {
            encoding = hostType.getDefaultEncoding();
        }
        if ((bidiFormat = aConfig.getAttribute(keyBidiFormat)) == null) {
            bidiFormat = "";
        }
        HostDetails aHostDetails = new HostDetails(aConfig.getId(), aConfig.getConnectionConfiguration().getHost(), aConfig.getConnectionConfiguration().getPort(), description, encoding, hostType, bidiFormat);
        return aHostDetails;
    }
}

