/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.rse.ui.subsystem.node;

import com.ibm.pdtools.common.component.core.model.ILeaf;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.ISystemsLabelDecorator;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventRemoteDispatcher;
import com.ibm.pdtools.common.component.rse.ui.integration.action.util.PDSubSystemTreeUtil;
import com.ibm.pdtools.common.component.rse.ui.subsystem.node.IPDSubSystemTree;
import com.ibm.pdtools.common.component.rse.ui.subsystem.node.PDSubSystem;
import com.ibm.pdtools.common.component.rse.ui.subsystem.node.PDSubSystemTreeListener;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsErrorFinder;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.ISystemTreeNodeProvider;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class PDSubSystemTree
extends AbstractResource
implements IPDSubSystemTree,
Comparable<PDSubSystemTree>,
IZRL,
ISystemTreeNodeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright IBM Corp. 2015. All rights reserved.";
    private final SystemsTreeNode rseTreeNode;
    private boolean cacheCleared = false;
    protected boolean isExpandable = true;
    private IPDHost system = null;
    private final Properties resourceProperties = new Properties();

    public PDSubSystemTree(PDSubSystem pdSubSystem, SystemsTreeNode rseTreeNode) {
        super((ISubSystem)pdSubSystem);
        this.rseTreeNode = rseTreeNode;
    }

    private IPDPlatformObject getPDPlatformObject() {
        return this.rseTreeNode instanceof IPDPlatformObject ? (IPDPlatformObject)this.rseTreeNode : (IPDPlatformObject)this.rseTreeNode.getDataObject();
    }

    @Override
    public boolean hasChildren() {
        if (this.rseTreeNode instanceof ILeaf) {
            this.isExpandable = false;
        } else {
            Object theObj = this.rseTreeNode.getDataObject();
            if (theObj instanceof ISystemsLabelDecorator && ((ISystemsLabelDecorator)theObj).checkDecorateImageStatic()) {
                this.isExpandable = false;
            }
            if (this.rseTreeNode.checkDecorateImageStatic()) {
                this.isExpandable = false;
            }
            if (this.rseTreeNode.isNotEnabled()) {
                this.isExpandable = false;
            }
        }
        return this.isExpandable;
    }

    @Override
    public Object[] getChildren() {
        if (!this.cacheCleared && !(this.rseTreeNode instanceof ILeaf) && this.rseTreeNode instanceof SystemsTreeNode) {
            this.cacheCleared = true;
            this.rseTreeNode.justUnloadThis();
        }
        if (this.rseTreeNode.getDataObject() instanceof IEntityEventRemoteDispatcher) {
            ((IEntityEventRemoteDispatcher)this.rseTreeNode.getDataObject()).setLoadFinishedListener(new PDSubSystemTreeListener(this));
        }
        return this.getSubSystem().createSubSystemTreeNodes(this.rseTreeNode.getChildren());
    }

    public ImageDescriptor getImageDescriptor() {
        return SystemsLabelProvider.getImageDescriptor((Object)this.rseTreeNode);
    }

    public String getAbsName() {
        Object name = this.getName();
        if (this.rseTreeNode.getParent() != null && this.rseTreeNode.getParent().getDataObject() != null) {
            name = (String)name + this.rseTreeNode.getParent().getDataObject().hashCode();
        }
        return name;
    }

    public SystemsTreeNode getRseTreeNode() {
        return this.rseTreeNode;
    }

    @Override
    public int compareTo(PDSubSystemTree o) {
        return this.getName().compareTo(o.getName());
    }

    public String copyName() {
        return this.getFormattedName();
    }

    public IPDHost getSystem() {
        SystemsTreeNode systemsTreeNode;
        if (this.system != null) {
            return this.system;
        }
        Object dataObject = this.rseTreeNode.getDataObject();
        if (dataObject instanceof IHostProvider) {
            this.system = ((IHostProvider)dataObject).getSystem();
        }
        if (this.rseTreeNode instanceof SystemsDataNode && (systemsTreeNode = ((SystemsDataNode)this.rseTreeNode).getParent()) != null) {
            Object aDataObj;
            Object aNode;
            List theList;
            dataObject = systemsTreeNode.getDataObject();
            if (dataObject instanceof IHostProvider) {
                this.system = ((IHostProvider)dataObject).getSystem();
            } else if (dataObject instanceof List && (theList = (List)dataObject).size() > 0 && (aNode = theList.get(0)) instanceof SystemsDataNode && (aDataObj = ((SystemsDataNode)aNode).getDataObject()) instanceof IHostProvider) {
                this.system = ((IHostProvider)aDataObj).getSystem();
            }
        }
        return this.system;
    }

    public String getFormattedName() {
        Object dataObject = this.rseTreeNode.getDataObject();
        if (dataObject instanceof IZRL) {
            return ((IZRL)dataObject).getFormattedName();
        }
        return new String("");
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public IZRL clone() {
        PDSubSystemTree copy = new PDSubSystemTree(this.getSubSystem(), this.rseTreeNode);
        copy.cacheCleared = this.cacheCleared;
        copy.isExpandable = this.isExpandable;
        for (Map.Entry<Object, Object> entry : this.resourceProperties.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    public boolean isRemoveable() {
        if (this.rseTreeNode instanceof SystemsDataNode) {
            return ((SystemsDataNode)this.rseTreeNode).isRemoveable();
        }
        return false;
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }

    public String getHostName() {
        return this.getSubSystem().getHostName();
    }

    public PDSubSystem getSubSystem() {
        return (PDSubSystem)super.getSubSystem();
    }

    public String getName() {
        return this.getPDPlatformObject().getPDLabel();
    }

    public String toString() {
        return "PDSubSystemTree [rseTreeNode=" + String.valueOf(this.rseTreeNode) + ", cacheCleared=" + this.cacheCleared + ", isExpandable=" + this.isExpandable + "]";
    }

    public boolean hasError() {
        Object dataObject = this.rseTreeNode.getDataObject();
        if (dataObject instanceof ISystemsLabelDecorator && ((ISystemsLabelDecorator)dataObject).checkDecorateImageStatic()) {
            return true;
        }
        return SystemsErrorFinder.INSTANCE.hasError((Object)this.rseTreeNode);
    }

    public SystemsTreeNode getFirstNonGrouperNode() {
        return PDSubSystemTreeUtil.getFirstNonGrouperNode(this.rseTreeNode);
    }

    public void setSystem(IPDHost system) {
        this.system = system;
    }
}

