/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.rse.ui.subsystem.node;

import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.comms.IDelegatingHost;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IHostSystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.rse.core.host.RseDelegatingHost;
import com.ibm.pdtools.common.component.rse.ui.service.comms.PDToolsRSE;
import com.ibm.pdtools.common.component.rse.ui.subsystem.factory.PDSubSystemAdapter;
import com.ibm.pdtools.common.component.rse.ui.subsystem.node.IPDSubSystem;
import com.ibm.pdtools.common.component.rse.ui.subsystem.node.PDSubSystemTree;
import com.ibm.pdtools.common.component.ui.prefs.PDCommonPreferenceFeaturesPage;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.ISystemTreeNodeProvider;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;

public class PDSubSystem
extends SubSystem
implements IPDSubSystem,
IZRL,
ISystemTreeNodeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright HCL Technologies Ltd. 2021. (C) Copyright IBM Corp. 2015, 2020. All rights reserved.";
    PDSubSystemAdapter pdSubSystemAdapter = null;
    private IHostSystem aHostExtend;
    protected boolean isNewFilterActionClicked = false;
    private final Properties resourceProperties = new Properties();

    public PDSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
        this.setHost(host);
    }

    public boolean hasChildren() {
        return true;
    }

    public void setPDContext(Class<?> pdHost, IHostSystem aHostExtend) {
        this.aHostExtend = Objects.requireNonNull(aHostExtend, "Please provide non-null aHostExtend.");
    }

    public PDContext getPDContext() {
        return new PDContext(this.getHostAliasName(), this.getHostName(), new RseDelegatingHost(this.getHost()).getPDPort(null), null, null, new IPDHostProvider(){

            public IPDHost create(String hostID, String hostName, int port) {
                PDHost host = PDHost.create((String)hostID, (String)hostName, (int)port);
                host.setAHostExtend(PDSubSystem.this.aHostExtend);
                host.setDelegatingHost((IDelegatingHost)new RseDelegatingHost(PDSubSystem.this.getHost()));
                return host;
            }
        });
    }

    public Object[] getChildren() {
        return new Object[0];
    }

    public Object[] createSubSystemTreeNodes(List<?> childrenList) {
        Object[] obj = new Object[childrenList.size()];
        int i = 0;
        for (Object child : childrenList) {
            PDSubSystemTree rseSubsytemNode = new PDSubSystemTree(this, (SystemsTreeNode)child);
            ((SystemsTreeNode)child).setInRS(true);
            obj[i] = rseSubsytemNode;
            ++i;
        }
        Arrays.sort(obj);
        return obj;
    }

    public boolean isHidden() {
        String preferenceId = this.getPreferenceId();
        return preferenceId != null ? !PDCommonPreferenceFeaturesPage.getFeatureMode((String)this.getPreferenceId()) : false;
    }

    public String getPreferenceId() {
        return null;
    }

    @Override
    public PDSubSystemAdapter getPdSubSystemAdapter() {
        if (this.pdSubSystemAdapter == null) {
            this.pdSubSystemAdapter = new PDSubSystemAdapter();
        }
        return this.pdSubSystemAdapter;
    }

    public void refreshNode() {
        PDToolsRSE.refreshNode(this);
    }

    public void showFilter() {
    }

    public void addFilter() {
        this.addFilter(this, this.getPDContext().getPDHost(), false);
    }

    public void addFilter(Object node, IPDHost pdHost) {
        this.refreshNode();
    }

    public void addFilter(Object node, IPDHost pdHost, boolean modify) {
        this.refreshNode();
    }

    public IPDHost getSystem() {
        return this.getPDContext().getPDHost();
    }

    public String copyName() {
        String name = this.getName();
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public String getFormattedName() {
        return "";
    }

    public PDSubSystem clone() {
        return new PDSubSystem(this);
    }

    public PDSubSystem(PDSubSystem pdss) {
        super(pdss.getHost(), pdss.getConnectorService());
        this.setConfigurationId(pdss.getConfigurationId());
        this.setConnectionError(pdss._connectionError);
        this.setFilterPoolReferenceManager(pdss.getFilterPoolReferenceManager());
        this.setHidden(pdss._hidden);
        this.setInteractionProvider(pdss.getInteractionProvider());
        this.setName(pdss.getName());
        this.setPDContext(pdss.getPDContext().getPDHost().getClass(), pdss.aHostExtend);
        this.setSubSystemConfiguration(pdss.getSubSystemConfiguration());
        for (Map.Entry<Object, Object> entry : pdss.resourceProperties.entrySet()) {
            this.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public SystemsTreeNode getFirstNonGrouperNode() {
        return new SystemsDataNode<PDSubSystem>(this, null){};
    }

    public void setNewFilterActionClicked(boolean isNewFilterActionClicked) {
        this.isNewFilterActionClicked = isNewFilterActionClicked;
    }
}

