/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.rse.ui.service;

import com.ibm.etools.zseries.util.IzOSSystem;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.TheCredential;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.rse.ui.service.PDConnectorService;
import com.ibm.pdtools.common.component.rse.ui.service.comms.PDToolsRSE;
import com.ibm.pdtools.common.component.rse.ui.subsystem.node.IPDSubSystem;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.AbstractConnectorServiceManager;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class PDConnectorServiceManager
extends AbstractConnectorServiceManager {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright IBM Corp. 2015. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PDConnectorServiceManager.class);
    private static PDConnectorServiceManager _instance;

    private PDConnectorServiceManager() {
    }

    public static PDConnectorServiceManager getInstance() {
        return _instance != null ? _instance : (_instance = new PDConnectorServiceManager());
    }

    public static boolean isInstantiated() {
        return _instance != null;
    }

    public IConnectorService createConnectorService(IHost host) {
        IConnectorService[] pcs;
        IConnectorService[] iConnectorServiceArray = pcs = host.getConnectorServices();
        int n = pcs.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService iConnectorService = iConnectorServiceArray[n2];
            if (iConnectorService instanceof PDConnectorService) {
                return iConnectorService;
            }
            ++n2;
        }
        return new PDConnectorService(host);
    }

    public TheCredential getCredentials(TheHost theHost) {
        IzOSSystem rsHost = (IzOSSystem)PDToolsRSE.getTheHostIhost(theHost);
        if (rsHost != null) {
            return this.checkCredentials(rsHost.getUserInformation());
        }
        return null;
    }

    private TheCredential checkCredentials(SystemSignonInformation theSignonInfo) {
        if (theSignonInfo != null) {
            TheCredential theCredential = new TheCredential(theSignonInfo.getUserId(), theSignonInfo.getPassword());
            return theCredential.getUserId() != null ? theCredential : null;
        }
        logger.trace((Object)"checkCredentials: theSignonInfo is null. Returning null.");
        return null;
    }

    public Class<IPDSubSystem> getSubSystemCommonInterface(ISubSystem subSystem) {
        return IPDSubSystem.class;
    }

    public boolean sharesSystem(ISubSystem otherSubSystem) {
        return otherSubSystem instanceof IPDSubSystem;
    }
}

