/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.rse.ui.service;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;

public class PDConnectorService
extends StandardConnectorService {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright HCL Technologies Ltd. 2022. (C) Copyright IBM Corp. 2015, 2020. All rights reserved.";
    private boolean connected = false;
    private String previousUser = "";

    public PDConnectorService(IHost host) {
        super("RSE ADFz Connector Service", "PDTools Loose Integration with RSE", host, 9876);
        this.initProperties();
    }

    private void initProperties() {
        IPropertySet prop;
        IPropertySet[] props;
        this.previousUser = this.getHost().getDefaultUserId();
        IPropertySet[] iPropertySetArray = props = this.getPropertySets();
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            prop = iPropertySetArray[n2];
            if (prop.getName().equals("PD Tools Properties") || prop.getName().equals("MFA Property")) {
                return;
            }
            ++n2;
        }
        prop = this.createPropertySet("PD Tools Properties", "ADFz RS View Properties");
        this.addPropertySet(prop);
        prop.addProperty("PD_SERVER_PORT", "0");
        IPropertySet mfaProp = this.createPropertySet("MFA Property", "MFA Properties");
        this.addPropertySet(mfaProp);
        mfaProp.addProperty("MFA Enabled", "0");
    }

    public SystemSignonInformation getSignonInfo() {
        return this.getSignonInformation();
    }

    public String get_UserId() {
        return this.getSignonInformation().getUserId();
    }

    public String get_Password() {
        return this.getSignonInformation().getPassword();
    }

    public boolean isConnected() {
        if (!this.previousUser.equals(this.getHost().getDefaultUserId())) {
            this.previousUser = this.getHost().getDefaultUserId();
            this.setUserId(this.previousUser);
            this.getPropertySet("MFA Property").getProperty("MFA Enabled").setValue("0");
        }
        return this.connected;
    }

    protected void postConnect() {
        this.connected = true;
        super.postConnect();
    }

    protected void internalConnect(IProgressMonitor arg0) {
        this.connected = true;
    }

    protected void internalDisconnect(IProgressMonitor arg0) {
        this.connected = false;
    }
}

