/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.rse.core.host;

import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.IDelegatingHost;
import java.util.List;
import java.util.Objects;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;

public class RseDelegatingHost
implements IDelegatingHost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright HCL Technologies Ltd. 2017, 2022. (C) Copyright IBM Corp. 2015, 2017. All rights reserved.";
    public static final String PDTOOLS_PROPERTY_SET = "PD Tools Properties";
    public static final String PORT_VALUE_ENVVAR_NAME = "PD_SERVER_PORT";
    public static final String RSE_PDTOOLS_CONNECTOR_SERVICE = "RSE ADFz Connector Service";
    public static final String MFA_PROPERTY = "MFA Property";
    public static final String MFA_ENABLED = "MFA Enabled";
    private IHost rseHost = null;

    public RseDelegatingHost(IHost rseHost) {
        this.rseHost = Objects.requireNonNull(rseHost, "Please provide a non-null rdzHost.");
    }

    public int getPDPort(AuthDetails authDetails) {
        IConnectorService[] connectorServices;
        IConnectorService[] iConnectorServiceArray = connectorServices = this.rseHost.getConnectorServices();
        int n = connectorServices.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService connectorService = iConnectorServiceArray[n2];
            if (connectorService.getName().equals(RSE_PDTOOLS_CONNECTOR_SERVICE)) {
                String portStr;
                int port;
                IPropertySet pdRseProp = connectorService.getPropertySet(PDTOOLS_PROPERTY_SET);
                if (pdRseProp == null || (port = RseDelegatingHost.str2Int((portStr = pdRseProp.getPropertyValue(PORT_VALUE_ENVVAR_NAME)).trim())) == 0) break;
                return port;
            }
            ++n2;
        }
        return RseDelegatingHost.getFMPort(this.rseHost);
    }

    private static int getFMPort(IHost rdzHost) {
        Objects.requireNonNull(rdzHost, "Please provide a non-null rdzHost.");
        String portVariable = null;
        ShellServiceSubSystem shellSubSystem = null;
        IRemoteCmdSubSystem[] systems = RemoteCommandHelpers.getCmdSubSystems((IHost)rdzHost);
        int i = 0;
        while (i < systems.length) {
            if (systems[i] instanceof ShellServiceSubSystem) {
                shellSubSystem = (ShellServiceSubSystem)systems[i];
                break;
            }
            ++i;
        }
        if (shellSubSystem == null) {
            return 0;
        }
        try {
            List variables = shellSubSystem.getHostEnvironmentVariables();
            int i2 = 0;
            while (i2 < variables.size()) {
                String variable = (String)variables.get(i2);
                if (variable.startsWith(PORT_VALUE_ENVVAR_NAME)) {
                    portVariable = variable;
                    break;
                }
                ++i2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (portVariable == null) {
            return 0;
        }
        return RseDelegatingHost.str2Int(portVariable.substring(portVariable.indexOf("=") + 1).trim());
    }

    private static int str2Int(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

