/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.weaving;

import com.ibm.pdtools.common.component.weaving.BidiUIClassVisitor;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

public class BidiUIWeavingHook
implements WeavingHook {
    private static final String BUNDLE_CC_BIDI = "com.ibm.pdtools.common.component.bidi";
    private static final String BUNDLE_FM_UI = "com.ibm.etools.fm.ui";
    private static final String FQN_BIDI_UI = "com.ibm.pdtools.common.component.bidi.ui.BidiUI";
    private static final Version MAX_VERSION = Version.valueOf((String)"15.1.2");
    private ServiceRegistration<WeavingHook> service;

    public void weave(WovenClass wovenClass) {
        Bundle bundle;
        if (FQN_BIDI_UI.equals(wovenClass.getClassName()) && BUNDLE_CC_BIDI.equals((bundle = wovenClass.getBundleWiring().getBundle()).getSymbolicName())) {
            try {
                ClassReader classReader = new ClassReader(wovenClass.getBytes());
                ClassWriter classWriter = new ClassWriter(classReader, 2);
                BidiUIClassVisitor classVisitor = new BidiUIClassVisitor(classWriter);
                classReader.accept((ClassVisitor)classVisitor, 4);
                byte[] wovenBytes = classWriter.toByteArray();
                wovenClass.setBytes(wovenBytes);
            }
            catch (Exception e) {
                ILog log = Platform.getLog(BidiUIWeavingHook.class);
                log.error("Error while performing bytecode weaving", (Throwable)e);
            }
        }
    }

    private void activate(BundleContext context) {
        boolean shouldWave = this.checkFmBundleVersion(context.getBundles());
        if (shouldWave) {
            this.service = context.registerService(WeavingHook.class, (Object)this, null);
        }
    }

    private void deactivate() {
        if (this.service != null) {
            this.service.unregister();
            this.service = null;
        }
    }

    private boolean checkFmBundleVersion(Bundle[] bundles) {
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (BUNDLE_FM_UI.equals(bundle.getSymbolicName())) {
                return MAX_VERSION.compareTo(bundle.getVersion()) > 0;
            }
            ++n2;
        }
        return false;
    }
}

