/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class XMLUtils {
    public static String replaceIllegalXMLCharacters(String s) {
        return s.replaceAll("[^\\x09\\x0A\\x0D\\x20-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFFF]", ".");
    }

    public static String prettyPrint(String xml) {
        return XMLUtils.prettyPrint(xml, 1, true);
    }

    public static String prettyPrint(String xml, int indent, boolean omitXMLDeclaration) {
        if (indent < 0) {
            indent = 0;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            if (omitXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("indent", "yes");
            StringWriter w = new StringWriter();
            transformer.transform(new SAXSource(new InputSource(new StringReader(XMLUtils.replaceIllegalXMLCharacters(xml)))), new StreamResult(w));
            String formatted = w.toString().trim();
            if (formatted.isEmpty()) {
                return xml;
            }
            return formatted;
        }
        catch (Exception e) {
            PDLoggerJhost.get(XMLUtils.class).trace((Object)("Could not pretty print: " + String.valueOf(e) + "returning unformatted string."));
            return xml;
        }
    }
}

