/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.DataConversionUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TranslateForDisplayString {
    private static final char INVALID_CHARACTER = '\ufffd';
    private static final char SUBSTITUTE_CHARACTER = '\u001a';
    private static Map<String, Charset> charsetCache = new HashMap<String, Charset>();
    private static Map<Charset, CharsetEncoder> encoderCache = new HashMap<Charset, CharsetEncoder>();
    private static final PDLoggerJhost logger = PDLoggerJhost.get(TranslateForDisplayString.class);

    private static <K, V> String formatMapForTrace(Map<K, V> m) throws NullPointerException {
        Objects.requireNonNull(m, "Must provide a non-null map to format.");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<K, V> e : m.entrySet()) {
            sb.append(MessageFormat.format("{0}={1}\n", e.getKey(), e.getValue()));
        }
        return sb.toString();
    }

    private static Charset getCharset(String charsetName) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(charsetName, "Must specify a non-null charset name.");
        if (charsetName.isEmpty()) {
            throw new IllegalArgumentException("Must specify a non-empty charset name.");
        }
        Charset cs = charsetCache.get(charsetName);
        if (cs != null) {
            return cs;
        }
        if (Charset.isSupported(charsetName)) {
            Charset csInstance = Charset.forName(charsetName);
            charsetCache.put(charsetName, csInstance);
            return csInstance;
        }
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("The supported Charsets are: {0}", TranslateForDisplayString.formatMapForTrace(Charset.availableCharsets())));
        }
        throw new IllegalArgumentException(MessageFormat.format("Requested charset: {0} is not supported by the current JVM. ", charsetName));
    }

    private static CharsetEncoder getEncoder(Charset cs, CodingErrorAction onMalformed, CodingErrorAction onUnMappable) throws NullPointerException {
        Objects.requireNonNull(cs, "Must specify a non-null charset.");
        Objects.requireNonNull(onMalformed, "Must specify an action for malformed input.");
        Objects.requireNonNull(onUnMappable, "Must specify an action for unmappable input.");
        if (cs.canEncode()) {
            CharsetEncoder enc = encoderCache.get(cs);
            if (enc != null) {
                return enc;
            }
            CharsetEncoder encInstance = cs.newEncoder().onMalformedInput(onMalformed).onUnmappableCharacter(onUnMappable);
            encoderCache.put(cs, encInstance);
            return encInstance;
        }
        logger.error((Object)MessageFormat.format("The charset: ''{0}'' does not support encoding.", cs));
        return null;
    }

    private static CharsetEncoder getEncoder(String charsetName) throws NullPointerException {
        Objects.requireNonNull(charsetName, "Must specify a non-null charset name.");
        Charset cs = TranslateForDisplayString.getCharset(charsetName);
        if (cs != null) {
            return TranslateForDisplayString.getEncoder(cs, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
        }
        return null;
    }

    private static CharBuffer wrap(char c) {
        return CharBuffer.wrap(Character.toString(c));
    }

    private static byte[] getBytes(CharsetEncoder enc, char c) {
        Objects.requireNonNull(enc, "Must specify a non-null encoder.");
        if (enc.canEncode(c)) {
            try {
                return enc.encode(TranslateForDisplayString.wrap(c)).array();
            }
            catch (CharacterCodingException e) {
                logger.error(e);
            }
        }
        logger.error((Object)MessageFormat.format("character ''{0}'' can not be encoded using {1} encoder.", Character.valueOf(c), enc.charset()));
        return null;
    }

    private static String translate(String s, String sourceCharsetName, String targetCharsetName) throws NullPointerException, IllegalArgumentException, CommunicationException {
        boolean numBytesPerCharSBCS = true;
        CharsetEncoder srcEncoder = TranslateForDisplayString.getEncoder(sourceCharsetName);
        if (srcEncoder != null) {
            if (StandardCharsets.UTF_8.equals(srcEncoder.charset())) {
                throw new IllegalArgumentException("this method does not support UTF-8 (src)");
            }
            if ((int)srcEncoder.maxBytesPerChar() > 1) {
                throw new IllegalArgumentException(MessageFormat.format("The specified source character set ''{0}'' is not a SBCS so can not be translated.", sourceCharsetName));
            }
            Charset targetCharset = TranslateForDisplayString.getCharset(targetCharsetName);
            if (targetCharset != null) {
                if (StandardCharsets.UTF_8.equals(targetCharset)) {
                    throw new IllegalArgumentException("this method does not support UTF-8 (target)");
                }
                byte[] bytes = TranslateForDisplayString.getBytes(s, srcEncoder);
                if (bytes != null) {
                    String translated = new String(bytes, targetCharset);
                    if (PDLoggerJhost.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format("Getting bytes for ''{0}'' using {1} target is {2} Result=''{3}''", s, srcEncoder.charset(), targetCharset, translated));
                    }
                    return translated;
                }
            }
        }
        return null;
    }

    private static byte[] getBytes(String aStr, CharsetEncoder charsetEncoder) throws CommunicationException {
        Objects.requireNonNull(aStr, "Must specify a non-null String.");
        Objects.requireNonNull(charsetEncoder, "Must specify a non-null encoder.");
        ByteBuffer buffer = TranslateForDisplayString.allocateBufferForString(aStr, charsetEncoder);
        boolean conversionError = false;
        char[] cArray = aStr.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            byte[] bytes = TranslateForDisplayString.getBytes(charsetEncoder, c);
            if (bytes == null) {
                conversionError = true;
                buffer.put(TranslateForDisplayString.getSubstituteCharacter(charsetEncoder.charset()));
            } else {
                buffer.put(bytes);
            }
            ++n2;
        }
        if (conversionError) {
            throw new CommunicationException(new String(buffer.array(), charsetEncoder.charset()).replace('\u001a', '\ufffd'));
        }
        return buffer.array();
    }

    private static ByteBuffer allocateBufferForString(String s, CharsetEncoder enc) {
        Objects.requireNonNull(s, "Must specify a non-null String.");
        Objects.requireNonNull(enc, "Must specify a non-null encoder.");
        return ByteBuffer.allocate((int)(enc.maxBytesPerChar() * (float)s.length()));
    }

    private static byte[] getSubstituteCharacter(Charset cs) {
        return Character.toString('\u001a').getBytes(Objects.requireNonNull(cs, "Must specify non-null charset."));
    }

    public static String convertToDisplayString(String inString, String displayCharset) throws NullPointerException, IllegalArgumentException, CommunicationException {
        Objects.requireNonNull(inString, "Must provide a non-null string to convert.");
        Objects.requireNonNull(displayCharset, "Must provide a non-null string to convert.");
        return TranslateForDisplayString.translate(inString, HostType.ZOS.getCommunicationEncoding(), displayCharset);
    }

    public static String convertFromDisplayStringToHost(String displayedString, String displayCharset) throws NullPointerException, IllegalArgumentException, CommunicationException {
        Objects.requireNonNull(displayedString, "Must provide a non-null string to convert.");
        Objects.requireNonNull(displayCharset, "Must provide a non-null display charset name.");
        return TranslateForDisplayString.translate(displayedString, displayCharset, HostType.ZOS.getCommunicationEncoding());
    }

    public static String getHexValue(String aStr, String encoding) throws CommunicationException {
        logger.trace((Object)MessageFormat.format("converting: ''{0}'' to hex using {1}", aStr, encoding));
        byte[] buffer = TranslateForDisplayString.getBytes(aStr, TranslateForDisplayString.getEncoder(encoding));
        String aStringHexValue = DataConversionUtils.getHexString(buffer);
        return "x'" + aStringHexValue + "'";
    }
}

