/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.core.Messages;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.DataConversionUtils;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLoggerJhost logger = PDLoggerJhost.get(StringUtils.class);
    public static final Pattern NEWLINE_CHARACTERS = Pattern.compile("(\\r\\n|\\r|\\n)", 8);
    private static final Pattern REGEXP_CHARACTERS = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
    private static final String HEX_PATTERN_BEFORE = "((x|X)'\\p{XDigit}+')|((x|X)\"\\p{XDigit}+\")";
    private static final String HEX_PATTERN_AFTER = "('\\p{XDigit}+'(x|X))|(\"\\p{XDigit}+\"(x|X))";
    private static final Pattern REGEXP_HEX_ESCAPE_VALIDATOR = Pattern.compile("((x|X)'\\p{XDigit}+')|((x|X)\"\\p{XDigit}+\")|('\\p{XDigit}+'(x|X))|(\"\\p{XDigit}+\"(x|X))");
    private static final String CASE_PATTERN_BEFORE = "((c|C)'.+')|((c|C)\".+\")";
    private static final String CASE_PATTERN_AFTER = "('.+'(c|C))|(\".+\"(c|C))";
    private static final Pattern REGEXP_CASE_ESCAPE_VALIDATOR = Pattern.compile("((c|C)'.+')|((c|C)\".+\")|('.+'(c|C))|(\".+\"(c|C))");
    private static final String PICTURE_PATTERN_BEFORE = "((p|P)'.+')|((p|P)\".+\")";
    private static final String PICTURE_PATTERN_AFTER = "('.+'(p|P))|(\".+\"(p|P))";
    private static final Pattern REGEXP_PICTURE_ESCAPE_VALIDATOR = Pattern.compile("((p|P)'.+')|((p|P)\".+\")|('.+'(p|P))|(\".+\"(p|P))");
    private static final Pattern REGEXP_HAS_MATCHED_QUOTES_VALIDATOR = Pattern.compile("('.*')|(\".*\")");

    public static String escapeRegex(String inStr) {
        Objects.requireNonNull(inStr, "Must provide a non-null regex String.");
        return REGEXP_CHARACTERS.matcher(inStr).replaceAll("\\\\$1");
    }

    public static int count(String countIn, String toCount) {
        return StringUtils.countRegexpMatches(countIn, StringUtils.escapeRegex(toCount));
    }

    public static int countRegexpMatches(String countIn, String regexpToCount) {
        Objects.requireNonNull(regexpToCount);
        Pattern pattern = Pattern.compile(regexpToCount);
        Matcher matcher = pattern.matcher(countIn);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean isHexEntry(String str) {
        Objects.requireNonNull(str);
        return REGEXP_HEX_ESCAPE_VALIDATOR.matcher(str).matches();
    }

    public static boolean isCaseSensitiveEntry(String str) {
        Objects.requireNonNull(str);
        return REGEXP_CASE_ESCAPE_VALIDATOR.matcher(str).matches();
    }

    private static boolean isPictureEntry(String str) {
        Objects.requireNonNull(str);
        return REGEXP_PICTURE_ESCAPE_VALIDATOR.matcher(str).matches();
    }

    private static boolean isEnclosedInQuotes(String str) {
        return REGEXP_HAS_MATCHED_QUOTES_VALIDATOR.matcher(str).matches();
    }

    public static String unescapeResourceForHost(String dsn) {
        if (dsn == null) {
            return "";
        }
        if (StringUtils.isCaseSensitiveEntry(dsn)) {
            dsn = StringUtils.getFormattedInputWithoutCaseEscaper(dsn);
        }
        return dsn;
    }

    public static String getFormattedInputWithHexEscaper(String str) {
        Object formattedStr = str;
        if (!StringUtils.isHexEntry((String)formattedStr)) {
            if (!StringUtils.isHexEntry((String)(formattedStr = "x'" + (String)formattedStr + "'"))) {
                return null;
            }
            return formattedStr;
        }
        return formattedStr;
    }

    public static String getFormattedInputWithoutHexEscaper(String str) {
        if (str == null) {
            return "";
        }
        if (StringUtils.isHexEntry(str)) {
            str = str.substring(2, str.length() - 1);
            return str;
        }
        return str;
    }

    public static String getFormattedInputWithCaseEscaper(String str) {
        Object formattedStr = str;
        if (StringUtils.isCaseSensitiveEntry((String)formattedStr)) {
            return formattedStr;
        }
        formattedStr = ((String)formattedStr).replace("'", "''");
        if (!StringUtils.isCaseSensitiveEntry((String)(formattedStr = "c'" + (String)formattedStr + "'"))) {
            return null;
        }
        return formattedStr;
    }

    public static String getFormattedInputWithoutCaseEscaper(String str) {
        if (str == null) {
            return "";
        }
        if (StringUtils.isCaseSensitiveEntry(str)) {
            str = str.replace("''", "'");
            str = str.substring(2, str.length() - 1);
            return str;
        }
        return str;
    }

    public static String getFormattedInputWithPictureEscaper(String str) {
        Object formattedStr = str;
        if (StringUtils.isPictureEntry((String)formattedStr)) {
            return formattedStr;
        }
        if (!StringUtils.isPictureEntry((String)(formattedStr = "p'" + (String)formattedStr + "'"))) {
            return null;
        }
        return formattedStr;
    }

    public static String getFormattedEntryString(String str) {
        String s = str;
        if (StringUtils.isHexEntry(s) || StringUtils.isCaseSensitiveEntry(s) || StringUtils.isPictureEntry(s)) {
            return s;
        }
        if (StringUtils.isEnclosedInQuotes(str)) {
            return s;
        }
        return "'" + s + "'";
    }

    public static String parseHexString(String hexString, String encoding) {
        block6: {
            if (hexString == null) {
                logger.error((Object)"Must provide a non-null hexString.");
                return null;
            }
            if (encoding == null) {
                logger.error((Object)"Must provide a non-null encoding.");
                return null;
            }
            if (hexString.length() % 2 == 0) break block6;
            logger.debug("Can't parse string as it has uneven number of characters:", hexString);
            return null;
        }
        try {
            byte[] b = new byte[hexString.length() / 2];
            int i = 0;
            int j = 0;
            while (i < hexString.length()) {
                int high = StringUtils.charToNibble(hexString.charAt(i));
                int low = StringUtils.charToNibble(hexString.charAt(i + 1));
                b[j] = (byte)(high << 4 | low);
                i += 2;
                ++j;
            }
            return new String(b, encoding);
        }
        catch (Exception e) {
            logger.error((Object)("hex string: " + hexString + " encoding: " + encoding + " " + e.getMessage()));
            return null;
        }
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.StringUtils_INVALID_HEX_CHAR, Character.valueOf(c)));
    }

    public static boolean isAsciiCharacters(String s) {
        Objects.requireNonNull(s);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return "";
        }
        if (repeat == 1 || str.isEmpty()) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str.length() * repeat);
        int i = 0;
        while (i < repeat) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    public static String translate(String str, IPDHost pdHost) {
        String codePage = null;
        String communicationCodePage = null;
        if (pdHost != null) {
            codePage = pdHost.getCodePage();
            communicationCodePage = pdHost.getHostType().getCommunicationEncoding();
            if (codePage != null && !communicationCodePage.equals(codePage)) {
                try {
                    return new String(str.getBytes(communicationCodePage), codePage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return str;
    }

    public static String getHexValue(String aStr, String encoding) {
        Objects.requireNonNull(aStr, "Must specify a non-null String.");
        try {
            byte[] hexBytes = aStr.getBytes(encoding);
            String aStringHexValue = DataConversionUtils.getHexString(hexBytes);
            return "x'" + aStringHexValue + "'";
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static String convertToHex(String nonHex, String encoding) {
        if (nonHex == null) {
            logger.error((Object)"Must provide a non-null nonHex String.");
            return null;
        }
        if (encoding == null) {
            logger.error((Object)("To convert " + nonHex + ", Must provide a non-null encoding String."));
            return null;
        }
        try {
            byte[] newHexValueBytes = nonHex.getBytes(encoding);
            return DataConversionUtils.getHexString(newHexValueBytes).toUpperCase();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't convert to hex string: " + nonHex + " with encoding " + encoding), e);
            return null;
        }
    }

    public static String makeFilterRegExp(String textFilter) {
        String filter;
        String string = filter = textFilter != null ? textFilter.trim().toUpperCase() : "";
        if (!filter.endsWith("*") && !filter.endsWith("?")) {
            filter = filter.concat("*");
        }
        filter = filter.replaceAll("\\*", ".*").replaceAll("\\?", ".?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
        return filter;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isHexCharacters(String str) {
        Objects.requireNonNull(str);
        Pattern p = Pattern.compile("^[0-9A-F]+$");
        return p.matcher(str).matches();
    }

    public static int hexStringToInt(String str) {
        Objects.requireNonNull(str);
        return Integer.decode("0x" + str);
    }
}

