/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.Message;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NonBlockingSocketIOUtilsJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLoggerJhost logger = PDLoggerJhost.get(NonBlockingSocketIOUtilsJhost.class);

    public static boolean writeMessage(NonBlockingSocketIOJhost nbsio, Message message, IHowIsGoing monitor) {
        if (nbsio == null) {
            logger.error((Object)"writeMessage() failed: Must specify a non-null NonBlockingSocket.");
            return false;
        }
        try {
            ByteBuffer buf = ByteBuffer.allocate(12 + message.getDataLength());
            buf.putInt(message.getLength());
            buf.putInt(message.getType());
            buf.putInt(message.getVersion());
            buf.put(message.getData(), 0, message.getDataLength());
            nbsio.writeBytes(buf.array(), 0, buf.position(), monitor);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"writeMessage() failed", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message readMessage(NonBlockingSocketIOJhost nbsio, IHowIsGoing monitor) {
        try {
            byte[] buffer;
            if (nbsio == null) {
                logger.error((Object)"ERROR: readMessage(): Must specify a non-null NonBlockingSocket.");
                return null;
            }
            int length = nbsio.readUnsignedInt(monitor);
            if (length == -1) {
                logger.error((Object)"ERROR: readMessage() failed to read length.");
                return null;
            }
            int type = nbsio.readUnsignedInt(monitor);
            if (type == -1) {
                logger.error((Object)"ERROR: readMessage() failed to read type.");
                return null;
            }
            int version = nbsio.readUnsignedInt(monitor);
            if (version == -1) {
                logger.error((Object)"ERROR: readMessage() failed to read version.");
                return null;
            }
            if (length > 0) {
                buffer = new byte[length - 12];
                try {
                    nbsio.readBytes(buffer, 0, buffer.length, monitor);
                }
                catch (IOException e) {
                    logger.error((Object)"ERROR: readMessage() failed to read reserved data.", e);
                    return null;
                }
            } else {
                buffer = new byte[]{};
            }
            Message msg = new Message();
            msg.setData(type, buffer, 0, buffer.length, version, false);
            return msg;
        }
        catch (Exception e) {
            logger.error((Object)"readMessage() failed", e);
            return null;
        }
    }
}

