/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.io.UnsupportedEncodingException;
import java.util.Objects;

public class DataConversionUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLoggerJhost logger = PDLoggerJhost.get(DataConversionUtils.class);
    public static final String NON_DISPLAY_CHARACTERS = "[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]";

    public static byte[] getEBCDICData(String value) {
        Objects.requireNonNull(value, "Must specify a non-null value.");
        byte[] bytes = new byte[value.length() / 2];
        int i = 0;
        int j = 0;
        while (i + 1 < value.length()) {
            byte secondByteNum;
            byte firstByteNum;
            String firstByteStr = value.substring(i, i + 1);
            try {
                firstByteNum = Byte.parseByte(firstByteStr, 16);
            }
            catch (NumberFormatException e) {
                firstByteNum = (byte)Integer.parseInt(firstByteStr, 16);
            }
            String secondByteStr = value.substring(i + 1, i + 2);
            try {
                secondByteNum = Byte.valueOf(secondByteStr, 16);
            }
            catch (NumberFormatException e) {
                secondByteNum = (byte)Integer.parseInt(secondByteStr, 16);
            }
            bytes[j] = (byte)((byte)(firstByteNum << 4) + (byte)secondByteNum);
            i += 2;
            ++j;
        }
        return bytes;
    }

    public static String getHexString(byte[] b) {
        Objects.requireNonNull(b);
        StringBuilder result = new StringBuilder(b.length * 2);
        int i = 0;
        while (i < b.length) {
            result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return result.toString().toUpperCase();
    }

    public static String getHexString(byte[] b, int start, int length) {
        StringBuilder result = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            result.append(Integer.toString((b[start + i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return result.toString().toUpperCase();
    }

    public static String getHexString(String aStr, String encoding) throws UnsupportedEncodingException {
        Objects.requireNonNull(aStr);
        return DataConversionUtils.getHexString(aStr.getBytes(encoding));
    }

    public static String hexToDisplayString(String hexString, String encoding) {
        try {
            byte[] byteValue = DataConversionUtils.getEBCDICData(hexString);
            return new String(byteValue, encoding).replaceAll(NON_DISPLAY_CHARACTERS, ".");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

