/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.ByteComparator;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;

public class ByteStringComparator
implements Comparator<String> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final ByteComparator BYTE_COMPARATOR = new ByteComparator();
    protected static final PDLoggerJhost logger = PDLoggerJhost.get(ByteStringComparator.class);
    private HostType hostType;

    public ByteStringComparator(HostType hostTye) {
        this.hostType = hostTye;
    }

    @Override
    public int compare(String o1, String o2) {
        String[] o2Strings;
        String[] o1Strings = o1.split("\\.");
        int len = o1Strings.length < (o2Strings = o2.split("\\.")).length ? o1Strings.length : o2Strings.length;
        int i = 0;
        while (i < len) {
            String s1 = o1Strings[i];
            String s2 = o2Strings[i];
            try {
                int compareResult = BYTE_COMPARATOR.compare(s1.getBytes(this.hostType.getCommunicationEncoding()), s2.getBytes(this.hostType.getCommunicationEncoding()));
                if (compareResult != 0) {
                    return compareResult;
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e);
                return 0;
            }
            ++i;
        }
        int lenDiff = o1Strings.length - o2Strings.length;
        if (lenDiff != 0) {
            return lenDiff;
        }
        return o1.length() - o2.length();
    }
}

