/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.util;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;

public class BidiCharsetUtils {
    private static final PDLoggerJhost logger = PDLoggerJhost.get(BidiCharsetUtils.class);
    public static final Charset IBM_420 = Charset.forName("ibm420");
    public static final Charset IBM_424 = Charset.forName("ibm424");

    private BidiCharsetUtils() {
    }

    public static boolean isBidiCharsetName(String charset) {
        Objects.requireNonNull(charset, "Must provide non-null Charset to check.");
        charset = charset.trim().toLowerCase();
        if (charset.isEmpty()) {
            throw new IllegalArgumentException("Must specify a charset name to check. ( Specified charset is empty.)");
        }
        try {
            Charset cs = Charset.forName(charset);
            if (IBM_420.equals(cs) || IBM_424.equals(cs)) {
                return true;
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public static Directionality getTextDirectionality(String text) {
        Objects.requireNonNull(text, "Must provide a non-null text string.");
        boolean containsLeftToRight = false;
        boolean containsRightToLeft = false;
        int codePointCount = text.codePointCount(0, text.length());
        int i = 0;
        while (i < codePointCount) {
            byte directionality = Character.getDirectionality(text.codePointAt(i));
            switch (directionality) {
                case 0: {
                    containsLeftToRight = true;
                    break;
                }
                case 1: {
                    containsRightToLeft = true;
                    break;
                }
            }
            ++i;
        }
        if (containsLeftToRight && containsRightToLeft) {
            return Directionality.Mixed;
        }
        if (containsLeftToRight) {
            return Directionality.Left2Right;
        }
        if (containsRightToLeft) {
            return Directionality.Right2Left;
        }
        return Directionality.None;
    }

    public static boolean doesTextContainBidiCharacters(String text) {
        Objects.requireNonNull(text, "Must provide a non-null text string.");
        Directionality textDirectionality = BidiCharsetUtils.getTextDirectionality(text);
        return textDirectionality.equals((Object)Directionality.Right2Left) || textDirectionality.equals((Object)Directionality.Mixed);
    }

    public static enum Directionality {
        Left2Right,
        Right2Left,
        Mixed,
        None;

    }
}

