/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.socket.io;

import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.ConnectionUtilitiesJhost;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IAuthDetailsProvider2;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.core.Messages;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.socket.io.IPDFunctionCode;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecXResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.PDFunctionResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.SimpleResponsePacket;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;

public abstract class CommonConnectionJhost
implements IPDFunctionCode,
IAuthDetailsProvider2,
AutoCloseable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final int HEADER_SIZE = 32;
    private static final String PD_PARAM_COMP = "COMP";
    private static final String PD_PARAM_SSID = "SSID";
    protected NonBlockingSocketIOJhost socketIO;
    private static final String UNUSED_CONNECTION = "UnusedConnection";
    protected static final PDLoggerJhost logger = PDLoggerJhost.get(CommonConnectionJhost.class);
    protected final IPDHost pdHost;
    protected final IPDConnectEndpoint endpoint;
    private String connectDetails = "UnusedConnection";
    private boolean locked;
    protected boolean headersDisabled = false;
    protected boolean xmlErrorsOn = false;

    @Deprecated
    public CommonConnectionJhost(IPDHost pdHost, IPDConnectEndpoint endpoint, AuthDetails authInfo, IHowIsGoing howIsGoing) throws CommunicationException, InterruptedException {
        this(pdHost, endpoint, false, authInfo, howIsGoing);
    }

    public CommonConnectionJhost(IPDHost pdHost, IPDConnectEndpoint endpoint, boolean expectReturnMsgAtInit, AuthDetails authInfo, IHowIsGoing howIsGoing) throws CommunicationException, InterruptedException {
        this.pdHost = Objects.requireNonNull(pdHost, "Please specify a non-null pdHost.");
        Objects.requireNonNull(pdHost.getHostType(), "Specified pdHost HostType has not been set.");
        this.endpoint = Objects.requireNonNull(endpoint, "Please specify a non-null endpoint.");
        Objects.requireNonNull(endpoint.getComponentName(), "Specified endpoint component name not specified.");
        this.socketIO = this.initConnectionTo(pdHost, endpoint, expectReturnMsgAtInit, authInfo, howIsGoing);
        this.connectDetails = pdHost.getConnectionName() + "->" + DateFormat.getTimeInstance().format(Calendar.getInstance().getTime());
    }

    private NonBlockingSocketIOJhost initConnectionTo(IPDHost pdHost, IPDConnectEndpoint endpoint, boolean expectReturnMsgAtInit, AuthDetails authInfo, IHowIsGoing howIsGoing) throws CommunicationException, InterruptedException {
        NonBlockingSocketIOJhost socketIO = null;
        HostDetails hostDetails = new HostDetails(pdHost);
        HashMap<Object, String> options = new HashMap<Object, String>();
        String compName = endpoint.getComponentName();
        if (compName != null && compName.length() > 4) {
            logger.error((Object)"Endpoint component name must be 1 to 4 characters.");
        }
        options.put(PD_PARAM_COMP, compName + "    ".substring(compName.length()));
        options.put(PD_PARAM_SSID, endpoint.getSubsystemID());
        socketIO = ConnectionUtilitiesJhost.newConnection(hostDetails, Objects.requireNonNull(endpoint.getConfigurationID(), "Must Provide a non-null configName."), options, authInfo, this, howIsGoing);
        try {
            if (expectReturnMsgAtInit) {
                int len = socketIO.readUnsignedInt(howIsGoing);
                if (len < 0) {
                    throw new CommunicationException(Messages.Connection_FAILED_TO_START_SESSION_CHECK_CONFIG);
                }
                byte[] msg = new byte[len];
                socketIO.readBytes(msg, msg.length, howIsGoing);
                this.checkVersionCompatibility(new String(msg, this.pdHost.getHostType().getCommunicationEncoding()), pdHost, endpoint);
            }
            pdHost.setIPVServerProperties(hostDetails.getServerProperties());
            return socketIO;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (CommunicationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public abstract void checkVersionCompatibility(String var1, IPDHost var2, IPDConnectEndpoint var3) throws CommunicationException;

    public IPDConnectEndpoint getEndpoint() {
        return this.endpoint;
    }

    public IPDHost getSystem() {
        return this.pdHost;
    }

    public synchronized void lock() {
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)(this.getClass().getCanonicalName() + "connection locked! (endpoint=" + String.valueOf(this.endpoint) + ")." + Arrays.toString(PDLoggerJhost.filteredTraceArray(Thread.currentThread().getStackTrace()))));
        }
        this.locked = true;
    }

    public synchronized void unlock() {
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)(this.getClass().getCanonicalName() + "connection unlocked! (endpoint=" + String.valueOf(this.endpoint) + ")." + Arrays.toString(PDLoggerJhost.filteredTraceArray(Thread.currentThread().getStackTrace()))));
        }
        this.locked = false;
    }

    public synchronized boolean isLocked() {
        return this.locked;
    }

    public String toString() {
        if (UNUSED_CONNECTION.equals(this.connectDetails)) {
            return this.connectDetails;
        }
        boolean isClosed = false;
        try {
            isClosed = this.isClosed(null);
        }
        catch (InterruptedException e) {
            isClosed = true;
        }
        return "isLocked? " + this.locked + " closed? " + isClosed + " connect details: " + this.connectDetails;
    }

    protected void writePacket(int functionCode, String input, String data, IHowIsGoing howIsGoing) throws IOException {
        Objects.requireNonNull(input, "Please specify a non-null input.");
        byte[] ebcdicInput = input.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        byte[] ebcdicData = null;
        if (data != null) {
            ebcdicData = data.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        }
        int packetLen = ebcdicInput.length + (ebcdicData == null ? 0 : ebcdicData.length) + 12;
        ByteBuffer buf = ByteBuffer.allocate(packetLen);
        buf.putInt(packetLen);
        buf.putInt(functionCode);
        buf.putInt(ebcdicInput.length);
        buf.put(ebcdicInput);
        if (ebcdicData != null) {
            buf.put(ebcdicData);
        }
        this.socketIO.writeBytes(buf.array(), 0, buf.position(), howIsGoing);
    }

    protected int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public synchronized void forceConnectionClose() {
        if (this.socketIO != null) {
            this.socketIO.closeConnection();
        }
    }

    public synchronized boolean requestConnectionClose() {
        if (this.isLocked()) {
            logger.trace((Object)("Ignoring close request for connection " + this.toString()));
            return false;
        }
        if (this.socketIO == null) {
            return true;
        }
        this.socketIO.closeConnection();
        return true;
    }

    public synchronized boolean isClosed(IHowIsGoing howIsGoing) throws InterruptedException {
        if (this.socketIO == null || this.socketIO.isClosed()) {
            return true;
        }
        if (this.isLocked()) {
            return false;
        }
        if (howIsGoing != null) {
            Result<StringBuffer> result = this.pingServer(new StringWriter(), howIsGoing);
            return result == null || result.getRC() > 4;
        }
        return false;
    }

    public Result<StringBuffer> pingServer(StringWriter output, IHowIsGoing howIsGoing) throws InterruptedException {
        logger.trace((Object)"Checking connection is alive - pinging server...");
        Result<StringBuffer> result = null;
        try {
            result = this.executeUtilityFunction("VER", null, output, howIsGoing);
        }
        catch (CommunicationException e) {
            result = new Result(e);
        }
        logger.trace((Object)("Checking connection is alive - finished, RC=" + result.getRC()));
        return result;
    }

    public Result<StringBuffer> executeUtilityFunction(String roadmapCommand, String data, StringWriter writer, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(roadmapCommand, "Please specify a non-null roadmapCommand");
        Objects.requireNonNull(writer, "Please specify a non-null writer");
        Result<StringBuffer> result = new Result<StringBuffer>(new StringBuffer());
        try {
            this.writePacket(20, roadmapCommand, data, howIsGoing);
            PDFunctionResponsePacket fmResp = new PDFunctionResponsePacket(this.socketIO, howIsGoing);
            byte[] fmBuffer = new byte[fmResp.getTotalBytes() - 32];
            this.socketIO.readBytes(fmBuffer, fmBuffer.length, howIsGoing);
            if (fmResp.isiRepXml()) {
                this.retrieveFMUtilityXMLOutput(fmBuffer, writer);
            } else {
                this.readUtilityFunctionMessages(fmBuffer, fmResp.getMsgCount(), writer);
            }
            if (fmResp.isiRepMoreData()) {
                SimpleResponsePacket respPacket = null;
                do {
                    if (fmResp.isiRepXml()) {
                        this.writePacket(32, "GETRECX", null, howIsGoing);
                        respPacket = new GetRecXResponsePacket(this.socketIO, howIsGoing);
                    } else {
                        this.writePacket(16, "GETREC", null, howIsGoing);
                        respPacket = new GetRecResponsePacket(this.socketIO, howIsGoing);
                    }
                    if (respPacket.getReturnCode() > 8) {
                        result.setRC(respPacket.getReturnCode());
                        return result;
                    }
                    byte[] dataBuffer = new byte[respPacket.getTotalBytes() - 32];
                    this.socketIO.readBytes(dataBuffer, dataBuffer.length, howIsGoing);
                    if (fmResp.isiRepXml()) {
                        this.retrieveFMUtilityXMLOutput(dataBuffer, writer);
                        continue;
                    }
                    this.readUtilityFunctionMessages(dataBuffer, respPacket.getMsgCount(), writer);
                } while (respPacket.isiRepMoreData());
            }
            result.setRC(fmResp.getReturnCode());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
        return result;
    }

    private boolean retrieveFMUtilityXMLOutput(byte[] data, StringWriter writer) throws IOException {
        block10: {
            Objects.requireNonNull(writer, "Please provide a non-null writer.");
            Throwable throwable = null;
            Object var4_5 = null;
            ByteArrayInputStream input = new ByteArrayInputStream(data);
            try {
                byte[] buffer = new byte[1000];
                int len = 0;
                while ((len = input.read(buffer)) != -1) {
                    String s = new String(buffer, 0, len, this.pdHost.getHostType().getCommunicationEncoding());
                    writer.write(s);
                }
                if (input == null) break block10;
            }
            catch (Throwable throwable2) {
                try {
                    if (input != null) {
                        input.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            input.close();
        }
        return true;
    }

    private boolean readUtilityFunctionMessages(byte[] bytes, int messageCount, StringWriter writer) throws IOException {
        block12: {
            Objects.requireNonNull(writer, "Please provide a non-null writer.");
            byte[] msgLenBuff = new byte[4];
            Throwable throwable = null;
            Object var6_7 = null;
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            try {
                int i = 0;
                while (i < messageCount) {
                    if (((InputStream)input).skip(4L) != 4L) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    if (((InputStream)input).read(msgLenBuff, 0, 4) == -1) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    int msgLen = this.byteArrayToInt(msgLenBuff, 0);
                    byte[] msgBuff = new byte[msgLen];
                    int actualread = ((InputStream)input).read(msgBuff, 0, msgLen);
                    String s = new String(msgBuff, 0, msgLen, this.pdHost.getHostType().getCommunicationEncoding());
                    writer.write(s + "\n");
                    ++i;
                }
                if (input == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            ((InputStream)input).close();
        }
        return true;
    }

    public Result<StringBuffer> setXMLErrorsWrapped(boolean xmlErrorsOn, IHowIsGoing howIsGoing) throws InterruptedException {
        Result<StringBuffer> result;
        try {
            result = this.setXMLErrorsRaw(xmlErrorsOn, false, howIsGoing);
        }
        catch (CommunicationException e) {
            result = new Result(e);
        }
        return result;
    }

    public Result<StringBuffer> setXMLErrorsRaw(boolean xmlErrorsOn, boolean xmlRegardless, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        if (!xmlRegardless && this.xmlErrorsOn == xmlErrorsOn) {
            return new Result<StringBuffer>();
        }
        StringWriter sw = new StringWriter();
        Result<StringBuffer> result = this.executeUtilityFunction("SETF XMLMSG=" + (xmlErrorsOn ? "ON" : "OFF"), null, sw, howIsGoing);
        String messages = sw.getBuffer().toString();
        if (!messages.isEmpty()) {
            result.add(messages);
        }
        if (!result.hasError()) {
            this.xmlErrorsOn = xmlErrorsOn;
        }
        return result;
    }

    public Result<StringBuffer> setHeaderPagesOff(IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        if (this.headersDisabled) {
            return new Result<StringBuffer>();
        }
        StringWriter sw = new StringWriter();
        Result<StringBuffer> result = this.executeUtilityFunction("SET HEADERPG=NO", null, sw, howIsGoing);
        String messages = sw.getBuffer().toString();
        if (!messages.isEmpty()) {
            result.add(messages);
        }
        if (!result.hasError()) {
            this.headersDisabled = true;
        }
        return result;
    }

    public int bytesAvailable(IHowIsGoing monitor) {
        int size = this.socketIO.bytesAvailable();
        if (size == 0) {
            return 0;
        }
        if (size == -1) {
            return size;
        }
        byte[] buffer = new byte[size];
        try {
            this.socketIO.readBytes(buffer, size, monitor);
            String s = new String(buffer, 0, size, this.pdHost.getHostType().getCommunicationEncoding());
            logger.error((Object)("Unexpected " + size + " bytes left in the socket reader. Value [" + s + "]"));
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected bytes left in the socket reader.", e);
        }
        this.socketIO.closeConnection();
        return size;
    }

    public NonBlockingSocketIOJhost getSocketIOJhost() {
        return this.socketIO;
    }

    @Override
    @Deprecated
    public AuthDetails getAuthInfo(TheHost theHost) throws InterruptedException {
        return this.getAuthInfo(theHost, null);
    }

    @Override
    @Deprecated
    public AuthDetails getAuthInfo(TheHost theHost, IHowIsGoing monitor) throws InterruptedException {
        return null;
    }

    @Override
    public void close() {
        this.unlock();
    }
}

