/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.registery;

import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEventDispatcher;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;

public class EventCollector<T>
implements IEventDispatcher<T> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Collection<IEventDispatcher<T>> eventSources = new HashSet<IEventDispatcher<T>>();
    private final Deque<T> eventQueue = new LinkedBlockingDeque<T>();
    private final EventDispatcher<T> eventDispatcher = new EventDispatcher();
    private volatile boolean collapsingEvents;
    private volatile boolean blockingEvents;
    private EListener<T> eventSourceListener = new EListener<T>(){

        @Override
        public void onEvent(T event) {
            EventCollector.this.eventQueue.addLast(event);
        }
    };

    public void connectTo(IEventDispatcher<T> eventSource) {
        Objects.requireNonNull(eventSource, "Please provide a non-null eventSource.");
        eventSource.addListener(this.eventSourceListener);
        this.eventSources.add(eventSource);
    }

    public void disconnectFrom(IEventDispatcher<T> eventSource) {
        Objects.requireNonNull(eventSource, "Please provide a non-null eventSource.");
        eventSource.removeListener(this.eventSourceListener);
        this.eventSources.remove(eventSource);
    }

    public void dispose() {
        for (IEventDispatcher<T> eventSource : this.eventSources) {
            eventSource.removeListener(this.eventSourceListener);
        }
    }

    public boolean isCollapsingEvents() {
        return this.collapsingEvents;
    }

    public void setCollapsingEvents(boolean collapsingEvents) {
        this.collapsingEvents = collapsingEvents;
    }

    public boolean isBlockingEvents() {
        return this.blockingEvents;
    }

    public void blockEvents() {
        this.blockingEvents = true;
    }

    public void unblockEvents() {
        this.blockingEvents = false;
    }

    public void unblockEventsAndFireCollectedEvents() {
        this.fireCollectedEvents();
        this.blockingEvents = false;
        this.fireCollectedEvents();
    }

    public void fireCollectedEvents() {
        Object lastEvent = null;
        while (this.eventQueue.size() > 0) {
            T currEvent = this.eventQueue.removeFirst();
            if (!this.collapsingEvents || lastEvent == null || !lastEvent.equals(currEvent)) {
                this.eventDispatcher.fireEvent(currEvent);
            }
            lastEvent = currEvent;
        }
    }

    @Override
    public void addListener(EListener<T> listener) {
        this.eventDispatcher.addListener(listener);
    }

    @Override
    public void removeListener(EListener<T> listener) {
        this.eventDispatcher.removeListener(listener);
    }
}

