/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.registery;

import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.EventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EntityRegistryMap<K, E extends IEntityEventDispatcher<E>>
implements IEntityEventDispatcher<E> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Map<K, E> map = Collections.synchronizedMap(new HashMap());
    protected final Map<E, EntityRegistry.RegistryEntityUpdateListener<E>> entityUpdateListeners = new HashMap<E, EntityRegistry.RegistryEntityUpdateListener<E>>();
    protected final EventDispatcher<EntityEvent<E>> eventDispatcher = new EventDispatcher();

    public EntityRegistryMap<K, E> clone() {
        EntityRegistryMap<K, IEntityEventDispatcher> copy = new EntityRegistryMap<K, IEntityEventDispatcher>();
        for (Map.Entry<K, E> entry : this.entrySet()) {
            copy.put(entry.getKey(), (IEntityEventDispatcher)entry.getValue());
        }
        return copy;
    }

    public Object getMonitor() {
        return this.map;
    }

    public void clear() {
        this.map.clear();
    }

    public E get(Object key) {
        return (E)((IEntityEventDispatcher)this.map.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E put(K key, E newEntity) {
        E removedEntity;
        Objects.requireNonNull(key, "Please provide a non-null key.");
        Objects.requireNonNull(newEntity, "Please provide a non-null newEntity.");
        Object object = this.getMonitor();
        synchronized (object) {
            removedEntity = this.internalRemove(key);
            EntityRegistry.RegistryEntityUpdateListener<E> entityChangeListener = new EntityRegistry.RegistryEntityUpdateListener<E>(this.eventDispatcher);
            newEntity.addListener(entityChangeListener);
            this.entityUpdateListeners.put(newEntity, entityChangeListener);
            this.map.put(key, newEntity);
        }
        if (removedEntity != null) {
            this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.REMOVED, removedEntity, newEntity));
        }
        this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.ADDED, newEntity, removedEntity));
        return removedEntity;
    }

    public E remove(Object key) {
        E removedEntity = this.internalRemove(key);
        if (removedEntity != null) {
            this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.REMOVED, removedEntity));
        }
        return removedEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E internalRemove(Object key) {
        Object object = this.getMonitor();
        synchronized (object) {
            IEntityEventDispatcher existingEntity = (IEntityEventDispatcher)this.map.remove(key);
            EntityRegistry.RegistryEntityUpdateListener<E> listener = this.entityUpdateListeners.get(existingEntity);
            if (listener != null) {
                existingEntity.removeListener(listener);
            }
            return (E)existingEntity;
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set<Map.Entry<K, E>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Collection<E> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void addListener(EListener<EntityEvent<E>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    @Override
    public void removeListener(EListener<EntityEvent<E>> listener) {
        this.eventDispatcher.removeListener(listener);
    }
}

