/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.registery;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntityRegistry<E>
implements IEntityEventDispatcher<E> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected final List<E> entities = Collections.synchronizedList(new ArrayList());
    protected final Map<E, RegistryEntityUpdateListener<E>> entityUpdateListeners = new HashMap<E, RegistryEntityUpdateListener<E>>();
    protected final EventDispatcher<EntityEvent<E>> eventDispatcher = new EventDispatcher();

    public static <E> EntityRegistry<E> create() {
        return new EntityRegistry<E>();
    }

    public EntityRegistry() {
        EListener entityUpdateListener = new EListener<EntityEvent<E>>(){

            @Override
            public void onEvent(EntityEvent<E> event) {
                Object entity = event.getEntity();
                if (entity instanceof IEntityEventDispatcher) {
                    IEntityEventDispatcher notifyingEntity = (IEntityEventDispatcher)entity;
                    if (event.getType() == EntityEventType.ADDED) {
                        RegistryEntityUpdateListener entityChangeListener = new RegistryEntityUpdateListener(EntityRegistry.this.eventDispatcher);
                        notifyingEntity.addListener(entityChangeListener);
                        EntityRegistry.this.entityUpdateListeners.put(entity, entityChangeListener);
                    } else if (event.getType() == EntityEventType.REMOVED) {
                        RegistryEntityUpdateListener entityChangeListener = EntityRegistry.this.entityUpdateListeners.get(entity);
                        notifyingEntity.removeListener(entityChangeListener);
                        EntityRegistry.this.entityUpdateListeners.remove(entity);
                    }
                }
            }
        };
        this.addListener(entityUpdateListener);
    }

    @Override
    public void addListener(EListener<EntityEvent<E>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    @Override
    public void removeListener(EListener<EntityEvent<E>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public boolean add(E entity) {
        Objects.requireNonNull(entity, "Please provide a non-null entity.");
        boolean added = this.entities.add(entity);
        if (added) {
            this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.ADDED, entity));
        }
        return added;
    }

    public boolean addAlterEntity(E entity) {
        Objects.requireNonNull(entity, "Please provide a non-null entity.");
        E foundEntity = this.findAndRemoveEntity(entity, false);
        if (foundEntity != null) {
            return false;
        }
        boolean added = this.entities.add(entity);
        if (added) {
            this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.ADDED, entity));
        }
        return added;
    }

    private E findAndRemoveEntity(E entity, boolean remove) {
        E foundEntity = null;
        try {
            String dsName = this.getDSName(entity);
            Iterator<E> iterator = this.entities.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                String alterEntityDsName;
                E nextEntity = iterator.next();
                String toString = nextEntity.toString();
                if (toString.contains("Alter") && (alterEntityDsName = this.getDSName(nextEntity)).equals(dsName)) {
                    foundEntity = nextEntity;
                    if (remove) {
                        this.entities.remove(index);
                    }
                    break;
                }
                ++index;
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return foundEntity;
    }

    private String getDSName(E entity) throws NoSuchFieldException, IllegalAccessException {
        Field dsNameField = entity.getClass().getDeclaredField("dataSetName");
        dsNameField.setAccessible(true);
        String dsName = (String)dsNameField.get(entity);
        return dsName;
    }

    public boolean remove(E entity) {
        return this.remove(entity, true);
    }

    public boolean remove(E entity, boolean announceIt) {
        Objects.requireNonNull(entity, "Please provide a non-null entity.");
        boolean removed = this.entities.remove(entity);
        if (removed && announceIt) {
            this.announceRemove(entity);
        }
        return removed;
    }

    public boolean removeAlterEntity(E entity, boolean announceIt) {
        E foundEntity = this.findAndRemoveEntity(entity, true);
        if (foundEntity != null) {
            if (announceIt) {
                this.announceRemove(foundEntity);
            }
            return true;
        }
        return false;
    }

    public void announceRemove(E entity) {
        this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.REMOVED, entity));
    }

    public List<E> all() {
        return new ArrayList<E>(this.entities);
    }

    public boolean contains(E entity) {
        return this.entities.contains(entity);
    }

    public int size() {
        return this.entities.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E find(E entity) {
        if (entity == null) {
            return null;
        }
        List<E> list = this.entities;
        synchronized (list) {
            for (E e : this.entities) {
                if (!e.equals(entity)) continue;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E findOrAdd(E entity) {
        E entityInRegistry;
        boolean added = false;
        List<E> list = this.entities;
        synchronized (list) {
            entityInRegistry = this.find(entity);
            if (entityInRegistry == null) {
                added = this.entities.add(entity);
                entityInRegistry = entity;
            }
        }
        if (added) {
            this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.ADDED, entity));
        }
        return entityInRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E addOld(E entity) {
        E entityInRegistry;
        boolean added = false;
        List<E> list = this.entities;
        synchronized (list) {
            entityInRegistry = this.find(entity);
            if (entityInRegistry == null) {
                added = this.entities.add(entity);
                entityInRegistry = entity;
            }
        }
        if (added) {
            this.eventDispatcher.fireEvent(new EntityEvent<E>(EntityEventType.OLDADDED, entity));
        }
        return entityInRegistry;
    }

    public void xxx_enableDebugLogging() {
        PDLoggerJhost.get(EntityRegistry.class).warn((Object)("Enabling debug logging for entity registry " + String.valueOf(this) + " - remove calls to this method if entity event logging generated below is not useful!"));
        this.addListener(new EListener<EntityEvent<E>>(){

            @Override
            public void onEvent(EntityEvent<E> event) {
                PDLoggerJhost.get(EntityRegistry.class).trace((Object)String.format("Entity event: registry=%s %s registryEntities=%s", EntityRegistry.this.getClass().getSimpleName(), event, EntityRegistry.this.entities));
            }
        });
    }

    public static class RegistryEntityUpdateListener<E>
    implements EListener<EntityEvent<E>> {
        private final EventDispatcher<EntityEvent<E>> eventDispatcher;

        public RegistryEntityUpdateListener(EventDispatcher<EntityEvent<E>> eventDispatcher) {
            this.eventDispatcher = eventDispatcher;
        }

        @Override
        public void onEvent(EntityEvent<E> event) {
            this.eventDispatcher.fireEvent(event);
        }
    }
}

