/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.registery;

import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import java.util.Objects;

public class EntityEvent<E> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final EntityEventType eventType;
    private final E entity;
    private final Object detail;

    public EntityEvent(EntityEventType eventType, E entity, Object detail) {
        this.eventType = Objects.requireNonNull(eventType, "Please specify a non-null eventType.");
        this.entity = Objects.requireNonNull(entity, "Please specify a non-null entity.");
        this.detail = detail;
    }

    public EntityEvent(EntityEventType eventType, E entity) {
        this(eventType, entity, null);
    }

    public EntityEventType getType() {
        return this.eventType;
    }

    public E getEntity() {
        return this.entity;
    }

    public Object getDetail() {
        return this.detail;
    }

    public String toString() {
        return String.format("event:{type=%s entity=%s detail=%s}", new Object[]{this.eventType, this.entity, this.detail});
    }

    public boolean equals(Object o) {
        if (!(o instanceof EntityEvent)) {
            return false;
        }
        EntityEvent other = (EntityEvent)o;
        return this.eventType.equals((Object)other.eventType) && this.entity.equals(other.entity) && (this.detail == other.detail || this.detail != null && this.detail.equals(other.detail));
    }

    public int hashCode() {
        int result = 37;
        result = result * 37 + this.eventType.hashCode();
        result = result * 37 + this.entity.hashCode();
        result = result * 37 + (this.detail == null ? 2 : this.detail.hashCode());
        return result;
    }
}

