/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.prefs;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Objects;

public class CertificateInformation
implements Serializable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final long serialVersionUID = 1L;
    private String issuerDetails;
    private String validFromDate;
    private String validToDate;
    private X509Certificate certificateDetails;

    public static CertificateInformation getInstance(X509Certificate aCertificate) {
        Objects.requireNonNull(aCertificate);
        return new CertificateInformation(aCertificate.getIssuerDN().getName(), DateFormat.getInstance().format(aCertificate.getNotBefore()), DateFormat.getInstance().format(aCertificate.getNotAfter()), aCertificate);
    }

    protected CertificateInformation(String issuerDetails, String validFromDate, String validToDate, X509Certificate certificateDetails) {
        this.issuerDetails = issuerDetails;
        this.validFromDate = validFromDate;
        this.validToDate = validToDate;
        this.certificateDetails = certificateDetails;
    }

    public String getIssuerDetails() {
        return this.issuerDetails;
    }

    public void setIssuerDetails(String issuerDetails) {
        this.issuerDetails = issuerDetails;
    }

    public String getValidFromDate() {
        return this.validFromDate;
    }

    public void setValidFromDate(String validFromDate) {
        this.validFromDate = validFromDate;
    }

    public String getValidToDate() {
        return this.validToDate;
    }

    public void setValidToDate(String validToDate) {
        this.validToDate = validToDate;
    }

    public String getCertificateDetails() {
        return this.certificateDetails.toString();
    }

    public void setCertificateDetails(X509Certificate certificateDetails) {
        this.certificateDetails = certificateDetails;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certificateDetails == null ? 0 : this.certificateDetails.hashCode());
        result += this.issuerDetails == null ? 0 : this.issuerDetails.hashCode();
        result += this.validFromDate == null ? 0 : this.validFromDate.hashCode();
        return result += this.validToDate == null ? 0 : this.validToDate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateInformation)) {
            return false;
        }
        CertificateInformation other = (CertificateInformation)obj;
        if (this.certificateDetails == null ? other.certificateDetails != null : !this.certificateDetails.equals(other.certificateDetails)) {
            return false;
        }
        if (this.issuerDetails == null ? other.issuerDetails != null : !this.issuerDetails.equals(other.issuerDetails)) {
            return false;
        }
        if (this.validFromDate == null ? other.validFromDate != null : !this.validFromDate.equals(other.validFromDate)) {
            return false;
        }
        return !(this.validToDate == null ? other.validToDate != null : !this.validToDate.equals(other.validToDate));
    }
}

