/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.core.model;

import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Result<OUTPUT> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int SUCCESS = 0;
    public static final int WARNING = 4;
    public static final int ERROR = 8;
    private int rc = 0;
    protected ArrayList<String> messages = new ArrayList();
    protected OUTPUT output;
    private Calendar createdAt = Calendar.getInstance();
    private Set<Result<?>> subResults = new LinkedHashSet();
    private String displayMessage;

    public Result() {
    }

    public Result(OUTPUT output) {
        this.setOutput(output);
    }

    public Result(Throwable e) {
        this.add(e);
    }

    public Result(CommunicationException e) {
        this.add(e);
    }

    public Result(InvocationTargetException e) {
        this.add(e);
    }

    public Result(int rc) {
        this.setRC(rc);
    }

    public Result(Result<?> resultToWrap) {
        this.addSubResult(resultToWrap);
    }

    protected Result<OUTPUT> clone() {
        Result<OUTPUT> copy = new Result<OUTPUT>();
        copy.copy(this);
        return copy;
    }

    public void copy(Result<OUTPUT> from) {
        this.rc = from.rc;
        this.messages = new ArrayList<String>(from.messages);
        this.output = from.output;
        this.createdAt = from.createdAt;
        this.subResults = new LinkedHashSet(from.subResults);
    }

    public int getRC() {
        int maxRC = this.rc;
        for (Result<?> subResult : this.subResults) {
            if (subResult.getRC() <= maxRC) continue;
            maxRC = subResult.getRC();
        }
        return maxRC;
    }

    public int getResultRC() {
        return this.rc;
    }

    public void setRC(int rc) {
        if (rc == -1) {
            rc = 8;
        }
        if (this.rc <= rc) {
            this.rc = rc;
        }
    }

    public void addSubResult(Result<?> subResult) {
        if (subResult != null) {
            this.subResults.add(subResult);
        }
    }

    public void addSubResultWithOutput(Result<OUTPUT> subResultWithOutput) {
        if (subResultWithOutput == null) {
            this.setOutput(null);
        } else {
            this.setOutput(subResultWithOutput.getOutput());
        }
        this.addSubResult(subResultWithOutput);
    }

    public List<Result<?>> getSubResults() {
        return Collections.unmodifiableList(new ArrayList(this.subResults));
    }

    public void add(String message) {
        if (message != null) {
            this.messages.add(Objects.requireNonNull(message));
        }
    }

    public void add(Collection<String> collectionOfMessages) {
        this.messages.addAll(Objects.requireNonNull(collectionOfMessages));
    }

    public void add(Throwable exception) {
        this.add(exception, false);
    }

    public void add(CommunicationException exception) {
        this.addMessageAndCause(exception);
    }

    public void add(InvocationTargetException exception) {
        this.addMessageAndCause(exception);
    }

    private <T extends Throwable> void addMessageAndCause(T exception) {
        Objects.requireNonNull(exception, "Must provide a non-null exception.");
        PDLoggerJhost.get(this.getClass()).error(exception);
        String localizedMessage = exception.getLocalizedMessage();
        if (localizedMessage != null) {
            this.add(localizedMessage);
        }
        this.setRC(8);
        if (exception.getCause() != null) {
            this.add(exception.getCause());
        }
    }

    public void add(Throwable exception, boolean stackTraceOnly) {
        Objects.requireNonNull(exception);
        this.setRC(8);
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        String renderedException = writer.getBuffer().toString();
        this.messages.add(renderedException);
    }

    public StringBuilder getMessagesCombined() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.messages.size()) {
            sb.append(this.messages.get(i) + "\n");
            ++i;
        }
        for (Result<?> subResult : this.subResults) {
            StringBuilder subMessagesCombined = subResult.getMessagesCombined();
            if (subMessagesCombined.length() <= 0) continue;
            sb.append((CharSequence)subMessagesCombined);
        }
        return sb;
    }

    public String dumpOutputAndMessages(boolean forceOutputToString) {
        StringBuilder sb = new StringBuilder();
        Result.appendIfSupportedType(sb, this.output, forceOutputToString);
        sb.append((CharSequence)this.getMessagesCombined());
        for (Result<?> subResult : this.subResults) {
            Object o = subResult.getOutput();
            Result.appendIfSupportedType(sb, o, forceOutputToString);
        }
        return sb.toString();
    }

    public String dumpOutputAndMessages2(boolean forceOutputToString) {
        StringBuilder sb = new StringBuilder();
        Result.appendIfSupportedType(sb, this.output, forceOutputToString);
        sb.append((CharSequence)this.getMessagesCombined());
        for (Result<?> subResult : this.subResults) {
            sb.append(subResult.dumpOutputAndMessages(forceOutputToString));
        }
        return sb.toString();
    }

    private static void appendIfSupportedType(StringBuilder sb, Object o, boolean forceOutputToString) {
        String outputString;
        if ((o instanceof String || o instanceof StringBuffer || o instanceof StringBuilder) && forceOutputToString && o != null && !(outputString = o.toString()).isEmpty()) {
            sb.append(outputString).append("\n\n");
        }
    }

    public void setOutput(OUTPUT output) {
        this.output = output;
    }

    public OUTPUT getOutput() {
        return this.output;
    }

    public void reformatOutput() {
        if (this.output instanceof StringBuffer) {
            StringBuffer sb = new StringBuffer();
            String[] out = this.output.toString().split("(\r\n|\r|\n)");
            int i = 0;
            while (i < out.length) {
                if (out[i].matches("^[+-10 ].+")) {
                    sb.append(out[i].substring(1) + System.lineSeparator());
                } else {
                    sb.append(out[i] + System.lineSeparator());
                }
                ++i;
            }
            this.output = sb;
        }
    }

    public boolean isSuccessfulWithoutWarnings() {
        return this.getRC() == 0;
    }

    public boolean hasWarning() {
        return this.getRC() >= 4;
    }

    public boolean hasError() {
        return this.getRC() >= 8;
    }

    public Calendar getTimeCreatedAt() {
        return this.createdAt;
    }

    public String toString() {
        StringBuilder messagesCombined;
        StringBuilder sb = new StringBuilder();
        sb.append(new SimpleDateFormat().format(this.createdAt.getTime()));
        sb.append("\nRC = ");
        sb.append(this.rc);
        sb.append(", max RC is ");
        sb.append(this.getRC());
        if (this.output != null) {
            sb.append("\n");
            sb.append(this.output);
        }
        if ((messagesCombined = this.getMessagesCombined()).length() > 0) {
            sb.append((CharSequence)messagesCombined);
        }
        return sb.toString();
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }
}

