/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHostProvider;
import java.util.Objects;

public class PDContext {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String hostID;
    private String hostName;
    private int port;
    private AuthDetails authDetails;
    private final IPDHostProvider hostProvider;

    public PDContext(String hostID, String hostName, int port, String username, String password, IPDHostProvider hostProvider) {
        this.hostID = hostID;
        this.hostName = hostName;
        this.port = port;
        if (username != null) {
            this.authDetails = new AuthDetails(username, username, password);
        }
        this.hostProvider = Objects.requireNonNull(hostProvider, "Please provide a non-null hostProvider.");
    }

    public PDContext(final IPDHost host, AuthDetails auth) {
        this.hostID = host.getHostID();
        this.hostName = host.getHostName();
        this.port = host.getPort();
        this.authDetails = auth;
        this.hostProvider = new IPDHostProvider(){

            @Override
            public IPDHost create(String hostID, String hostName, int port) {
                return host;
            }
        };
    }

    public AuthDetails getAuthDetails() {
        return this.authDetails;
    }

    public IPDHost getPDHost() {
        return this.hostProvider.create(this.hostID, this.hostName, this.port);
    }
}

