/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.Messages;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.prefs.PDCommonPreferencePageJhost;
import com.ibm.pdtools.common.component.jhost.util.DataUtilities;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.Message;
import com.ibm.pdtools.common.component.jhost.util.NonBlockingSocketIOUtilsJhost;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class NonBlockingSocketIOJhost
implements AutoCloseable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String TLS_V13 = "TLSv1.3";
    public static final int READ_TIMEOUT = 500;
    private static final PDLoggerJhost logger = PDLoggerJhost.get(NonBlockingSocketIOJhost.class);
    private static TrustManager[] myTrustManagers = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            if (!PDToolsCommonServerClientJhost.getDefault().acceptCertificate(arg0[0])) {
                throw new CertificateException(Messages.PDToolsCommonServerClient_InvalidCertificate);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }};
    private SSLContext sslContext = null;
    private HostType hostType = HostType.getDefaultHostType();
    private Socket socket;
    private SSLSocket sslSocket;
    private InputStream socketInput = null;
    private OutputStream socketOutput = null;
    private boolean closedLocally = false;
    private String hostName = null;
    private int portNumber = 0;
    private String encoding = null;

    private SSLContext getSSLContext(HostDetails hostDetails) throws CommunicationException {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        try {
            this.sslContext = SSLContext.getInstance(this.getProtocol(hostDetails));
            this.sslContext.init(null, myTrustManagers, null);
            return this.sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommunicationException(e, MessageFormat.format(Messages.NonBlockingSocketIOJhost_PleaseCheckSSLConfigValueCurrentIsNotSupport, this.getProtocol(hostDetails)));
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    @Deprecated
    public NonBlockingSocketIOJhost(String hostName, int portNubmer, HostType hostType) throws CommunicationException {
        this(hostName, portNubmer, hostType, hostType.getDefaultEncoding(), null);
    }

    private void reportConnectionStatus(final int timeout, IHowIsGoing monitor) {
        final SubMonitor sm = monitor != null && monitor.getMonitor() instanceof IProgressMonitor ? SubMonitor.convert((IProgressMonitor)((IProgressMonitor)monitor.getMonitor()), (String)Messages.NonBlockingSocketIOJhost_Connecting, (int)((int)TimeUnit.MILLISECONDS.toSeconds(timeout))) : SubMonitor.convert((IProgressMonitor)new NullProgressMonitor());
        final long sleep = TimeUnit.SECONDS.toMillis(1L);
        new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (!(sm.isCanceled() || NonBlockingSocketIOJhost.this.socket.isConnected() || NonBlockingSocketIOJhost.this.isClosed() || i++ >= timeout)) {
                    sm.worked(1);
                    if (i > 35) {
                        sm.subTask(Messages.NonBlockingSocketIOJhost_WaitingMaybeShouldCancel);
                    } else if (i > 25) {
                        sm.subTask(Messages.NonBlockingSocketIOJhost_WaitingIsServerDownForAllOrJustYou);
                    } else if (i > 15) {
                        sm.subTask(Messages.NonBlockingSocketIOJhost_WaitingMaybeFirewallBlockedConnection);
                    } else if (i > 5) {
                        sm.subTask(Messages.NonBlockingSocketIOJhost_WaitingIsThePortCorrectQ);
                    } else if (i > 0) {
                        sm.subTask(Messages.NonBlockingSocketIOJhost_WaitingForResponse);
                    }
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        logger.trace((Object)"Cancelled.");
                    }
                }
                if (sm.isCanceled() && NonBlockingSocketIOJhost.this.socket != null) {
                    NonBlockingSocketIOJhost.this.closeConnection();
                }
            }
        }).start();
    }

    public NonBlockingSocketIOJhost(String hostName, int portNubmer, HostType hostType, String encoding, IHowIsGoing monitor) throws CommunicationException {
        this.hostName = hostName;
        this.portNumber = portNubmer;
        this.hostType = hostType;
        this.encoding = encoding;
        boolean toJhost = hostType == HostType.LOCAL_HOST;
        InetSocketAddress remoteAddress = new InetSocketAddress(this.hostName, this.portNumber);
        int localPortNumber = 0;
        int localPortStart = 0;
        if (!toJhost && PDCommonPreferencePageJhost.specifyLocalPortRange()) {
            localPortStart = localPortNumber = PDCommonPreferencePageJhost.getCurrentLocalPortNumber();
            logger.debug((Object)("Set local port number option selected. Attempting to bind to a local port number " + localPortNumber));
        } else {
            logger.debug((Object)"The local port number is selected by the operating system.");
        }
        try {
            while (true) {
                try {
                    this.socket = new Socket();
                    this.setSoTimeout((int)TimeUnit.MINUTES.toMillis(1L));
                    this.reportConnectionStatus(this.socket.getSoTimeout() == 0 ? 50 : this.socket.getSoTimeout(), monitor);
                    InetSocketAddress localAddress = toJhost ? null : new InetSocketAddress(localPortNumber);
                    this.socket.setReuseAddress(true);
                    this.socket.bind(localAddress);
                    this.socket.connect(remoteAddress);
                }
                catch (ConnectException e) {
                    String message = e.getMessage();
                    if (message != null) {
                        if (message.startsWith("Connection refused")) {
                            throw new CommunicationException(e, String.format(Messages.NonBlockingSocketIOJhost_HostRefusedConnection, hostName, portNubmer));
                        }
                        if (message.startsWith("Operation timed out")) {
                            throw new CommunicationException(e, String.format("Connection to Host: '%1s' port number '%2s' timed out.\n Some possible causes may be:\n - A firewall is blocking the connection to the server\n - The server is not responding to connections made to the specified port.\n ", hostName, portNubmer));
                        }
                    }
                    throw new CommunicationException(e, MessageFormat.format(Messages.NonBlockingSocketIOJhost_AnExceptionOccurredWhileAttemptingToConnect, e.getClass().getName(), hostName, portNubmer));
                }
                catch (UnknownHostException e) {
                    throw new CommunicationException(e, MessageFormat.format(Messages.NonBlockingSocketIOJhost_UnknownHostSpecifiedTryAgain, hostName));
                }
                catch (SocketException e) {
                    block28: {
                        String msg = e.getMessage();
                        if (msg == null) break block28;
                        switch (msg = msg.toLowerCase()) {
                            case "socket closed": {
                                throw new CommunicationException(e, Messages.NonBlockingSocketIOJhost_ConnectionCancelledSocketClosed);
                            }
                            case "network is unreachable": {
                                throw new CommunicationException(e, Messages.NonBlockingSocketIOJhost_NetworkUnreachable);
                            }
                        }
                    }
                    throw new CommunicationException(e, Messages.NonBlockingSocketIOJhost_SocketExceptionOccurred + e.getMessage());
                }
                catch (IOException e) {
                    if (localPortNumber == 0) {
                        throw new CommunicationException(e, e.getMessage() + " Note: Local Port Number is 0");
                    }
                    localPortNumber = PDCommonPreferencePageJhost.getCurrentLocalPortNumber();
                    if (localPortNumber == localPortStart) {
                        String errMsg = MessageFormat.format("Scanned all local port range and did not find a suitable port. Minimum: {0}  Maximum: {1}", PDCommonPreferencePageJhost.getLocalPortMin(), PDCommonPreferencePageJhost.getLocalPortMax());
                        throw new CommunicationException(e, errMsg);
                    }
                    logger.error("Exception thrown while establishing connection with the server.", PDLoggerJhost.filteredTrace(e.getStackTrace()));
                    if (monitor == null || !monitor.isCanceled()) continue;
                    throw new CommunicationException(new InterruptedException("Connection cancelled"));
                }
                break;
            }
        }
        catch (CommunicationException e) {
            this.closeConnection();
            throw e;
        }
        try {
            this.socket.setKeepAlive(true);
        }
        catch (SocketException e) {
            logger.error((Object)"SocketException thrown while setting SO_KEEPALIVE", e);
        }
        this.setSoTimeout(500);
    }

    public NonBlockingSocketIOJhost(Socket socket) {
        Objects.requireNonNull(socket, "Must specify a non-null socket.");
        this.socket = socket;
    }

    public String getProtocol(HostDetails hostDetails) {
        String protocol = hostDetails.getProtocol();
        return protocol == null ? "TLSv1.1" : protocol;
    }

    public synchronized void doHandshake(HostDetails hostDetails) throws CommunicationException, InterruptedException {
        this.setSoTimeout(0);
        try {
            try {
                if (this.sslSocket != null) {
                    logger.debug((Object)"handshake - sslSocket already exists - closing");
                    if (TLS_V13.equals(hostDetails.getProtocol())) {
                        this.sslSocket.shutdownOutput();
                        this.socketInput.read();
                    }
                    this.sslSocket.close();
                }
                logger.debug((Object)"Loading SSL context");
                SSLContext ctx = this.getSSLContext(hostDetails);
                this.sslSocket = (SSLSocket)ctx.getSocketFactory().createSocket(this.socket, this.hostName, this.portNumber, false);
                String[] newCiphers = this.sslSocket.getSupportedCipherSuites();
                this.sslSocket.setEnabledCipherSuites(newCiphers);
                logger.debug((Object)"Performing handshake");
                this.sslSocket.startHandshake();
                logger.debug((Object)"Finished handshake");
                this.socketInput = this.sslSocket.getInputStream();
                this.socketOutput = this.sslSocket.getOutputStream();
            }
            catch (Exception ex) {
                logger.debug((Object)"Failure while handshaking.");
                if (this.sslSocket != null) {
                    if (this.sslSocket.getSupportedCipherSuites() != null) {
                        logger.error("-Supported cipher suites ", Arrays.toString(this.sslSocket.getSupportedCipherSuites()));
                    } else {
                        logger.error((Object)"- No supported cipher suites.");
                    }
                    if (this.sslSocket.getEnabledCipherSuites() != null) {
                        logger.error("-Enabled cipher suites ", Arrays.toString(this.sslSocket.getEnabledCipherSuites()));
                    } else {
                        logger.error((Object)"- No enabled cipher suites.");
                    }
                } else {
                    logger.error((Object)"An error occurred while handshaking; sslSocket was null.");
                }
                throw new CommunicationException(ex, Messages.NonBlockingSocketIO_SSL_HANDSHAKE_ERR + " " + ex.getMessage());
            }
        }
        finally {
            this.setSoTimeout(500);
        }
    }

    private void setSoTimeout(int timeout) {
        try {
            logger.trace((Object)("Setting socket's SO_TIMEOUT to " + timeout));
            if (!this.socket.isClosed()) {
                this.socket.setSoTimeout(timeout);
            }
        }
        catch (SocketException e) {
            logger.error((Object)"Unable to set socket timeout to 500", e);
        }
    }

    public boolean isClosed() {
        return this.closedLocally || this.socket.isClosed();
    }

    public int bytesAvailable() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.socketInput != null ? this.socketInput.available() : -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public boolean writeMessage(int msgType, IHowIsGoing howIsGoing) {
        Message msg = new Message();
        byte[] msgBytes = new byte[]{};
        msg.setData(msgType, msgBytes, 0, 0, 1, false);
        return NonBlockingSocketIOUtilsJhost.writeMessage(this, msg, howIsGoing);
    }

    public boolean writeMessage(int msgType, String msgStr, IHowIsGoing howIsGoing) throws IOException {
        Message msg = new Message();
        byte[] msgBytes = msgStr.getBytes(this.hostType.getCommunicationEncoding());
        msg.setData(msgType, msgBytes, 0, msgBytes.length, 1, true);
        return NonBlockingSocketIOUtilsJhost.writeMessage(this, msg, howIsGoing);
    }

    public Message readResponseMessage(IHowIsGoing howIsGoing) {
        return NonBlockingSocketIOUtilsJhost.readMessage(this, howIsGoing);
    }

    public String readResponse(IHowIsGoing howIsGoing) throws IOException {
        Message retMsg = this.readResponseMessage(howIsGoing);
        return new String(retMsg.getData(), this.hostType.getCommunicationEncoding());
    }

    public int writeBytes(byte[] buffer, int start, int length, IHowIsGoing howIsGoing) throws IOException {
        Objects.requireNonNull(buffer, "Please provide a non-null buffer.");
        if (this.socketOutput == null) {
            try {
                this.socketOutput = this.socket.getOutputStream();
            }
            catch (IOException e) {
                this.closeConnection();
                throw e;
            }
        }
        try {
            this.socketOutput.write(buffer, start, length);
        }
        catch (IOException e) {
            this.closeConnection();
            throw e;
        }
        return length;
    }

    public int readBytes(byte[] buffer, int length, IHowIsGoing howIsGoing) throws IOException, InterruptedException {
        return this.readBytes(buffer, 0, length, howIsGoing);
    }

    public int readBytes(byte[] buffer, int start, int length, IHowIsGoing howIsGoing) throws IOException, InterruptedException {
        if (howIsGoing != null && howIsGoing.isCanceled()) {
            logger.trace((Object)"Operation cancelled before network read bytes");
            this.closeConnection();
            throw new InterruptedException();
        }
        if (this.socketInput == null) {
            this.socketInput = this.socket.getInputStream();
        }
        try {
            return this.readBytesDirect(buffer, start, length, howIsGoing);
        }
        catch (InterruptedException e) {
            this.closeConnection();
            throw e;
        }
    }

    private int readBytesDirect(byte[] buffer, int start, int length, IHowIsGoing howIsGoing) throws IOException, InterruptedException {
        Objects.requireNonNull(buffer, "Please provide a non-null buffer.");
        int bytesRead = 0;
        while (bytesRead != length) {
            if (howIsGoing != null && howIsGoing.isCanceled()) {
                throw new InterruptedException("Cancelled.");
            }
            try {
                int len = this.socketInput.read(buffer, start + bytesRead, length - bytesRead);
                if (len == -1) {
                    throw new IOException(MessageFormat.format(Messages.NonBlockingSocketIO_SOCK_READ_ERR, length));
                }
                bytesRead += len;
            }
            catch (SocketTimeoutException e) {
                if (howIsGoing == null || !howIsGoing.isCanceled()) continue;
                throw new InterruptedException(Messages.NonBlockingSocketIOJhost_Cancelled);
            }
        }
        return length;
    }

    @Deprecated
    public boolean writeUnsignedInt(int value, IHowIsGoing howIsGoing) throws IOException {
        byte[] buffer = DataUtilities.intToByteArray(value);
        return this.writeBytes(buffer, 0, 4, howIsGoing) == 4;
    }

    public int readUnsignedInt(IHowIsGoing howIsGoing) throws IOException, InterruptedException {
        byte[] buffer = new byte[4];
        try {
            this.readBytes(buffer, 0, 4, howIsGoing);
        }
        catch (IOException e) {
            return -1;
        }
        int value = DataUtilities.byteArrayToInt(buffer);
        return value;
    }

    public int readUnsignedShort(IHowIsGoing howIsGoing) throws IOException, InterruptedException {
        byte[] buffer = new byte[2];
        try {
            this.readBytes(buffer, 0, 2, howIsGoing);
        }
        catch (IOException e) {
            return -1;
        }
        int value = DataUtilities.byteArrayToShort(buffer);
        return value;
    }

    public void closeConnection() {
        block8: {
            try {
                try {
                    if (this.socket == null) break block8;
                    logger.trace((Object)MessageFormat.format("Forcing close of connection {0} : {1} {2} connected={3} isClosed={4} localPort={5}", this.hostName, this.portNumber, this.encoding, this.socket.isConnected(), this.socket.isClosed(), this.socket.getLocalPort()));
                    if (this.sslSocket != null) {
                        try {
                            this.sslSocket.shutdownOutput();
                        }
                        catch (Exception e) {
                            logger.error(e);
                        }
                        this.sslSocket.close();
                    }
                    this.socket.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error closing socket connection", e);
                    this.closedLocally = true;
                }
            }
            finally {
                this.closedLocally = true;
            }
        }
    }

    public Socket getSocket() {
        if (this.sslSocket != null) {
            return this.sslSocket;
        }
        return this.socket;
    }

    public HostType getHostType() {
        return this.hostType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() {
        this.closeConnection();
    }
}

