/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.Messages;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.AuthTokenExpiredException;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.ConnectState;
import com.ibm.pdtools.common.component.jhost.comms.ConnectionProgressReporter;
import com.ibm.pdtools.common.component.jhost.comms.ConnectionUtilitiesJhost;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.IAuthDetailsProvider;
import com.ibm.pdtools.common.component.jhost.comms.IConnectionUtilities;
import com.ibm.pdtools.common.component.jhost.comms.IConnectionUtilities2;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.prefs.PDCommonPreferencePageJhost;
import com.ibm.pdtools.common.component.jhost.util.DialogUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class NewConnectionProviderJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int MAX_INITIAL_SERVER_RESPONSE_MSG_LEN = 65536;
    private static final PDLoggerJhost logger = PDLoggerJhost.get(NewConnectionProviderJhost.class);

    @Deprecated
    public static NonBlockingSocketIOJhost newConnection(HostDetails hostDetails, String configName, Map<Object, String> options, AuthDetails authInfo, IAuthDetailsProvider authInfoProvider, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        if (configName == null) {
            throw new IllegalArgumentException("Please specify a non-null configName.");
        }
        Objects.requireNonNull(hostDetails, "Please specify a non-null hostDetails.");
        return NewConnectionProviderJhost.newConnection(hostDetails, configName, options, authInfo != null ? authInfo : authInfoProvider.getAuthInfo(new TheHost(hostDetails)), monitor);
    }

    public static NonBlockingSocketIOJhost newConnection(HostDetails hostDetails, String configName, Map<Object, String> options, AuthDetails login, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        String userName = login.getUsername();
        String hostName = hostDetails.getHostID();
        boolean mfaEnabled = PDToolsCommonServerClientJhost.getAuthDetailsFetcher().mfaEnabled(userName, hostName);
        if (configName == null) {
            throw new IllegalArgumentException("Please specify a non-null configName.");
        }
        if (login == null) {
            throw new CommunicationException(Messages.CommunicationSecurityException_INVALID_CREDENTIALS);
        }
        Objects.requireNonNull(hostDetails, "Please specify a non-null hostDetails.");
        ConnectionProgressReporter connStateLogger = new ConnectionProgressReporter(hostDetails, login, monitor, null);
        connStateLogger.logConnectionStateChange(ConnectState.S1_START);
        logger.debug((Object)("Connecting to " + hostDetails.getConnectionName() + ". CONFIG=" + configName));
        NonBlockingSocketIOJhost socketIO = null;
        connStateLogger.logConnectionStateChange(ConnectState.S1_b_Retrieving_Authentication_Details);
        try {
            PDToolsCommonServerClientJhost.getAuthTokenManager().startHandshake(hostDetails, login.getUsername(), monitor);
            int thePortNumber = hostDetails.getPortNumber(login);
            if (thePortNumber == 0) {
                String errorMsg = Messages.PDToolsCommonServerPortIsZero;
                throw new CommunicationException(errorMsg);
            }
            socketIO = new NonBlockingSocketIOJhost(hostDetails.getHostname(), thePortNumber, hostDetails.getHostType(), hostDetails.getCommunicationCodePage(), monitor);
            connStateLogger.logConnectionStateChange(ConnectState.S1_C_Socket_Connected);
            connStateLogger.logConnectionStateChange(ConnectState.S2_PARSING_SERVER_PROPERTIES);
            Map<String, String> serverProps = null;
            try {
                serverProps = NewConnectionProviderJhost.parseServerResponse(socketIO, hostDetails, monitor);
            }
            catch (AuthTokenExpiredException e) {
                socketIO.close();
                PDToolsCommonServerClientJhost.getAuthTokenManager().removeAuthToken(hostDetails, login.getUsername());
                PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                throw new CommunicationException(Messages.AuthenticationTokenExpired);
            }
            hostDetails.setServerProperties(serverProps);
            connStateLogger.logConnectionStateChange(ConnectState.S3_CHECK_PROTOCOL_VERSION);
            NewConnectionProviderJhost.checkProtocolVersion(hostDetails, null);
            if (hostDetails.isSecured()) {
                connStateLogger.logConnectionStateChange(ConnectState.S4_FIRST_SSL_HANDSHAKE);
                socketIO.doHandshake(hostDetails);
                connStateLogger.logConnectionStateChange(ConnectState.S4_B_FIRST_SSL_HANDSHAKE_COMPLETED);
            }
            String auth = "config=" + configName;
            if (options != null && options.size() > 0) {
                for (Map.Entry<Object, String> entry : options.entrySet()) {
                    auth = auth + " " + String.valueOf(entry.getKey()) + "=" + entry.getValue();
                }
            }
            auth = PDCommonPreferencePageJhost.getDebugMode() ? auth + " DEBUG=YES" : auth + " DEBUG=NO";
            if (serverProps.containsKey("PASSTK") && serverProps.get("PASSTK").equals("YES")) {
                PDToolsCommonServerClientJhost.getAuthTokenManager().setConnectionIdUsingTokens(hostDetails.getHostname(), hostDetails.getPortNumber());
                if (PDToolsCommonServerClientJhost.getAuthTokenManager().hasAuthToken(hostDetails, login.getUsername(), monitor)) {
                    login.setPassToken(PDToolsCommonServerClientJhost.getAuthTokenManager().getAuthToken(hostDetails, login.getUsername(), monitor));
                }
            }
            if (login.getPassToken() == null) {
                if (serverProps.containsKey("PASSTK") && serverProps.get("PASSTK").equals("YES")) {
                    auth = auth + " PASSTK=YES";
                }
                if (mfaEnabled) {
                    PDToolsCommonServerClientJhost.getAuthDetailsFetcher().invokeLoginDialog(login);
                }
                auth = "user=" + login.getUsername() + " pass=" + NewConnectionProviderJhost.passwordOrPassphrase(login.getPassword()) + " " + auth;
            } else {
                auth = auth + " PASSTK=" + login.getPassToken();
            }
            if (hostDetails.isUsingATTLS()) {
                auth = auth + " CLNTVER=2 ";
            }
            connStateLogger.logConnectionStateChange(ConnectState.S5_RETRIEVE_SERVER_CONFIGURATION);
            ByteBuffer buf = ByteBuffer.allocate(4 + auth.length());
            buf.putInt(auth.length());
            buf.put(auth.getBytes(ConnectionUtilitiesJhost.getEncoding(hostDetails)));
            socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
            connStateLogger.logConnectionStateChange(ConnectState.S6_PARSING_RESPONSE_FROM_SERVER);
            Map<String, String> authResultsProps = null;
            try {
                authResultsProps = NewConnectionProviderJhost.parseServerResponse(socketIO, hostDetails, monitor);
            }
            catch (AuthTokenExpiredException e) {
                socketIO.close();
                PDToolsCommonServerClientJhost.getAuthTokenManager().removeAuthToken(hostDetails, login.getUsername());
                PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                throw new CommunicationException(Messages.AuthenticationTokenExpired);
            }
            String authStatus = authResultsProps.get("AUTH");
            if (login.isAuthenticationRequired() && !"Y".equals(authStatus)) {
                String err = authResultsProps.get("ERROR");
                if (err == null) {
                    String errMsg = MessageFormat.format(Messages.Connection_UnknownErr, login.getUsername());
                    logger.error(Messages.ERROR_TITLE, errMsg);
                    PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                    throw new CommunicationException(errMsg);
                }
                if ("'INVALID PASSWORD'".equals(err)) {
                    String errMsg = MessageFormat.format(Messages.Connection_InvalidPassword, login.getUsername());
                    PDToolsCommonServerClientJhost.getAuthDetailsFetcher().setMFAFailureHostDetails(hostDetails.getHostID() + ":" + login.getUsername());
                    logger.error(Messages.ERROR_TITLE, errMsg);
                    PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                    socketIO.close();
                    throw new CommunicationException(Messages.Connection_SAF_Failure);
                }
                if ("'EXPIRED PASSWORD'".equals(err)) {
                    NonBlockingSocketIOJhost nonBlockingSocketIOJhost = NewConnectionProviderJhost.newConnectionChangePasswordFirst(hostDetails, configName, options, login.getPassword(), monitor);
                    return nonBlockingSocketIOJhost;
                }
                if ("'UNKNOWN USER'".equals(err)) {
                    String errMsg = MessageFormat.format(Messages.Connection_UnknownUserErr, login.getUsername());
                    logger.error(Messages.ERROR_TITLE, errMsg);
                    throw new CommunicationException(errMsg);
                }
                if ("'SAF FAILURE'".equals(err)) {
                    logger.error(Messages.ERROR_TITLE, Messages.Connection_SAF_Failure);
                    PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                    socketIO.close();
                    throw new CommunicationException(Messages.Connection_SAF_Failure);
                }
                String errMsg = MessageFormat.format(Messages.Connection_OtherErr, login.getUsername(), configName, err);
                logger.error(Messages.ERROR_TITLE, errMsg);
                PDToolsCommonServerClientJhost.getAuthDetailsFetcher().setMFAFailureHostDetails(hostDetails.getHostID() + ":" + login.getUsername());
                PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                throw new CommunicationException(errMsg);
            }
            PDToolsCommonServerClientJhost.getAuthDetailsFetcher().setMFAFailureHostDetails(null);
            if (authResultsProps.containsKey("PASSTK")) {
                login.setPassToken(authResultsProps.get("PASSTK"));
                PDToolsCommonServerClientJhost.getAuthTokenManager().setAuthToken(hostDetails, login.getUsername(), login.getPassToken());
            }
            if (hostDetails.getHostType() == HostType.ZOS && !hostDetails.isUsingATTLS()) {
                if (hostDetails.isSecured()) {
                    connStateLogger.logConnectionStateChange(ConnectState.S8_A_SECOND_HANDSHAKE);
                    socketIO.doHandshake(hostDetails);
                    connStateLogger.logConnectionStateChange(ConnectState.S8_A_SECOND_HANDSHAKE_COMPLETE);
                }
            } else {
                connStateLogger.logConnectionStateChange(ConnectState.S8_B_AT_TLS_DO_SKIPPING_SECOND_HANDSHAKE);
            }
            connStateLogger.logConnectionStateChange(ConnectState.S10_Connected);
            NonBlockingSocketIOJhost nonBlockingSocketIOJhost = socketIO;
            return nonBlockingSocketIOJhost;
        }
        catch (CommunicationException | InterruptedException e) {
            if (socketIO != null) {
                socketIO.close();
            }
            throw e;
        }
        catch (Exception e) {
            if (socketIO != null) {
                socketIO.close();
            }
            throw new CommunicationException(e);
        }
        finally {
            PDToolsCommonServerClientJhost.getAuthTokenManager().endHandshake(hostDetails, login.getUsername());
        }
    }

    private static void checkConnection(HostDetails hostDetails, AuthDetails authDetails, IHowIsGoing monitor) throws InterruptedException {
        StringBuilder result = new StringBuilder();
        ArrayList<String> extensions = new ArrayList<String>();
        if (NewConnectionProviderJhost.checkConnection(hostDetails, authDetails, result, extensions, new ConnectionUtilitiesJhost(), monitor)) {
            logger.info(Messages.INFO_TITLE, Messages.NewConnectionProvider_0, result.toString());
        } else {
            logger.error(Messages.ERROR_TITLE, Messages.NewConnectionProvider_1, result.toString());
        }
    }

    @Deprecated
    public static boolean checkConnection(HostDetails hostDetails, AuthDetails login, StringBuilder info, List<String> extensions, IConnectionUtilities iConnectionUtilities, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(hostDetails, "Must specify a non-null hostDetails.");
        if (login == null) {
            try {
                login = iConnectionUtilities.getLoginCall(new TheHost(hostDetails));
            }
            catch (Exception e) {
                info.append(Messages.NewConnectionProvider_ErrorIndicator);
                info.append(Messages.NewConnectionProvider_3);
                return false;
            }
        }
        return NewConnectionProviderJhost.checkConnectionImpl(hostDetails, login, info, extensions, iConnectionUtilities, monitor, "");
    }

    public static boolean checkConnection(HostDetails hostDetails, AuthDetails login, StringBuilder info, List<String> extensions, IConnectionUtilities2 iConnectionUtilities, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(hostDetails, "Must specify a non-null hostDetails.");
        if (login == null) {
            try {
                login = iConnectionUtilities.getLoginCall(new TheHost(hostDetails), monitor);
            }
            catch (Exception e) {
                info.append(Messages.NewConnectionProvider_ErrorIndicator);
                info.append(Messages.NewConnectionProvider_3);
                return false;
            }
        }
        return NewConnectionProviderJhost.checkConnectionImpl(hostDetails, login, info, extensions, iConnectionUtilities, monitor, "");
    }

    public static boolean checkConnectionToChangePass(HostDetails hostDetails, AuthDetails login, StringBuilder info, List<String> extensions, IConnectionUtilities2 iConnectionUtilities, String newPassword, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(hostDetails, "Must specify a non-null hostDetails.");
        if (login == null) {
            try {
                login = iConnectionUtilities.getLoginCall(new TheHost(hostDetails), monitor);
            }
            catch (Exception e) {
                info.append(Messages.NewConnectionProvider_ErrorIndicator);
                info.append(Messages.NewConnectionProvider_3);
                return false;
            }
        }
        return NewConnectionProviderJhost.checkConnectionImpl(hostDetails, login, info, extensions, iConnectionUtilities, monitor, newPassword);
    }

    /*
     * Exception decompiling
     */
    private static boolean checkConnectionImpl(HostDetails hostDetails, AuthDetails login, StringBuilder info, List<String> extensions, IConnectionUtilities iConnectionUtilities, IHowIsGoing monitor, String newPassword) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void parseServerExtensionInfo(String extensionsStr, List<String> extensions) {
        StringTokenizer st = new StringTokenizer(extensionsStr, "\n");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String aConfig = st.nextToken();
            String extName = aConfig.substring(aConfig.indexOf(61) + 1);
            extensions.add(extName);
        }
    }

    private static String dumpException(Exception exception) {
        StringWriter writer = new StringWriter();
        writer.write(MessageFormat.format(Messages.NewConnectionProvider_41, exception.getMessage()));
        logger.error(exception);
        return writer.getBuffer().toString() + "\n\n";
    }

    private static NonBlockingSocketIOJhost newConnectionChangePasswordFirst(HostDetails hostDetails, String configName, Map<Object, String> options, String oldPassword, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        if (configName == null) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(hostDetails, "Must provide a non-null hostDetails");
        logger.debug((Object)("Connecting to " + hostDetails.getConnectionName() + " and want to change password first. CONFIG=" + configName));
        NonBlockingSocketIOJhost socketIO = null;
        try {
            AuthDetails login = PDToolsCommonServerClientJhost.getPwdChangeFetcher().fetchAuthDetails(hostDetails.getHostID());
            if (login == null) {
                throw new CommunicationException(Messages.Connection_ChangePasswordCancelled);
            }
            ConnectionProgressReporter connStateLogger = new ConnectionProgressReporter(hostDetails, login, monitor, null);
            connStateLogger.logConnectionStateChange(ConnectState.S1_START);
            socketIO = new NonBlockingSocketIOJhost(hostDetails.getHostname(), hostDetails.getPortNumber(), hostDetails.getHostType(), hostDetails.getCommunicationCodePage(), monitor);
            connStateLogger.logConnectionStateChange(ConnectState.S1_C_Socket_Connected);
            connStateLogger.logConnectionStateChange(ConnectState.S2_PARSING_SERVER_PROPERTIES);
            Map<String, String> serverProps = NewConnectionProviderJhost.parseServerResponse(socketIO, hostDetails, monitor);
            hostDetails.setServerProperties(serverProps);
            connStateLogger.logConnectionStateChange(ConnectState.S3_CHECK_PROTOCOL_VERSION);
            NewConnectionProviderJhost.checkProtocolVersion(hostDetails, null);
            if (hostDetails.isSecured()) {
                connStateLogger.logConnectionStateChange(ConnectState.S4_FIRST_SSL_HANDSHAKE);
                socketIO.doHandshake(hostDetails);
                connStateLogger.logConnectionStateChange(ConnectState.S4_B_FIRST_SSL_HANDSHAKE_COMPLETED);
                logger.trace((Object)"attempting to change password.");
            }
            String auth = "config=" + configName;
            if (options != null && options.size() > 0) {
                for (Map.Entry<Object, String> entry : options.entrySet()) {
                    auth = auth + " " + String.valueOf(entry.getKey()) + "=" + entry.getValue();
                }
            }
            logger.debug((Object)("Connecting and changing password for user=" + login.getUsername() + ": " + auth));
            auth = PDCommonPreferencePageJhost.getDebugMode() ? auth + " DEBUG=YES" : auth + " DEBUG=NO";
            if (login.getPassToken() == null) {
                if (serverProps.containsKey("PASSTK")) {
                    auth = auth + " PASSTK=YES";
                }
                auth = "user=" + login.getUsername() + " pass=" + NewConnectionProviderJhost.passwordOrPassphrase(oldPassword) + " " + auth + " NEWPASS=" + NewConnectionProviderJhost.passwordOrPassphrase(login.getPassword());
            } else {
                auth = auth + " PASSTK=" + login.getPassToken() + " NEWPASS=" + NewConnectionProviderJhost.passwordOrPassphrase(login.getPassword());
            }
            if (hostDetails.isUsingATTLS()) {
                auth = auth + " CLNTVER=2 ";
            }
            connStateLogger.logConnectionStateChange(ConnectState.S5_RETRIEVE_SERVER_CONFIGURATION);
            ByteBuffer buf = ByteBuffer.allocate(4 + auth.length());
            buf.putInt(auth.length());
            buf.put(auth.getBytes(ConnectionUtilitiesJhost.getEncoding(hostDetails)));
            socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
            connStateLogger.logConnectionStateChange(ConnectState.S6_PARSING_RESPONSE_FROM_SERVER);
            Map<String, String> authResultsProps = NewConnectionProviderJhost.parseServerResponse(socketIO, hostDetails, monitor);
            String authStatus = authResultsProps.get("AUTH");
            if (!"Y".equals(authStatus)) {
                String err = authResultsProps.get("ERROR");
                if (err == null) {
                    String errMsg = MessageFormat.format(Messages.Connection_UnknownErr_whileChangePassword, login.getUsername());
                    if (DialogUtils.openQuestionThreadSafe(errMsg)) {
                        logger.error((Object)"Failed to change password with unknown error. Trying again.");
                        return NewConnectionProviderJhost.newConnectionChangePasswordFirst(hostDetails, configName, options, oldPassword, monitor);
                    }
                    logger.error((Object)"Failed to change password with unknown error. Quit.");
                    throw new CommunicationException(errMsg);
                }
                if ("'NEW PASSWORD INVALID'".equals(err)) {
                    logger.error((Object)"New password is invalid. Trying again.");
                    logger.error(Messages.ERROR_TITLE, Messages.Connection_InvalidNewPassword);
                    return NewConnectionProviderJhost.newConnectionChangePasswordFirst(hostDetails, configName, options, oldPassword, monitor);
                }
                String errMsg = MessageFormat.format(Messages.Connection_OtherErr_whileChangePassword, login.getUsername(), err);
                if (DialogUtils.openQuestionThreadSafe(errMsg)) {
                    logger.error((Object)("Failed to change password. Trying again. Msg: " + err));
                    return NewConnectionProviderJhost.newConnectionChangePasswordFirst(hostDetails, configName, options, oldPassword, monitor);
                }
                logger.error((Object)("Failed to change password. Quit. Msg: " + err));
                throw new CommunicationException(errMsg);
            }
            logger.debug((Object)"Managed to change password.");
            if (hostDetails.isSecured() && !hostDetails.isUsingATTLS()) {
                connStateLogger.logConnectionStateChange(ConnectState.S8_A_SECOND_HANDSHAKE);
                socketIO.doHandshake(hostDetails);
                connStateLogger.logConnectionStateChange(ConnectState.S8_A_SECOND_HANDSHAKE_COMPLETE);
            } else {
                connStateLogger.logConnectionStateChange(ConnectState.S8_B_AT_TLS_DO_SKIPPING_SECOND_HANDSHAKE);
            }
            if (!oldPassword.equals(login.getPassword())) {
                PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                JOptionPane.showMessageDialog(null, Messages.NonBlockingSocketIOJhost_PasswordChanged);
            }
            return socketIO;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    private static String passwordOrPassphrase(String aPassword) {
        if (aPassword == null || aPassword.length() <= 8) {
            return aPassword;
        }
        return "'" + aPassword + "'";
    }

    private static void checkProtocolVersion(HostDetails hostDetails, StringBuilder infoBuffer) throws CommunicationException {
        String serverProtocolVersion = hostDetails.getServerProperties().get("SERVERVERSION");
        try {
            int major = Integer.parseInt(serverProtocolVersion.substring(0, serverProtocolVersion.indexOf(46)));
            int minor = Integer.parseInt(serverProtocolVersion.substring(serverProtocolVersion.indexOf(46) + 1));
            if (major == 1) {
                if (minor == 3) {
                    if (infoBuffer != null) {
                        infoBuffer.append(Messages.NewConnectionProvider_44 + "\n");
                        return;
                    }
                    return;
                }
                if (minor < 3) {
                    String msg = MessageFormat.format(Messages.Connection_ServerUseOlderProtocol, "V1.6", "PM67623");
                    logger.debug((Object)msg);
                    if (infoBuffer != null) {
                        infoBuffer.append(msg + "\n");
                        return;
                    }
                    if (PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems()) {
                        boolean warnIncompatibility = DialogUtils.openWarningWithToggleThreadSafe(Messages.NewConnectionProvider_WARNING, msg, Messages.PDCommonPreferencePage_REPORT_VER_ERR, PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems());
                        PDCommonPreferencePageJhost.setReportVersionIncompatibleProblems(warnIncompatibility);
                    }
                    return;
                }
                String msg = Messages.Connection_ServerUseNewerProtocol;
                logger.debug((Object)msg);
                if (infoBuffer != null) {
                    infoBuffer.append(msg + "\n");
                    return;
                }
                if (PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems()) {
                    boolean warnIncompatibility = DialogUtils.openWarningWithToggleThreadSafe(Messages.NewConnectionProvider_WARNING, msg, Messages.PDCommonPreferencePage_REPORT_VER_ERR, PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems());
                    PDCommonPreferencePageJhost.setReportVersionIncompatibleProblems(warnIncompatibility);
                }
                return;
            }
            String errMsg = MessageFormat.format(Messages.Connection_IncompatibleProtocol, "V1.6", "PM67623");
            logger.debug((Object)errMsg);
            if (infoBuffer != null) {
                infoBuffer.append(errMsg + "\n");
                return;
            }
            logger.error(Messages.ERROR_TITLE, errMsg);
            throw new CommunicationException(errMsg);
        }
        catch (CommunicationException ce) {
            throw ce;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.Connection_UnknwonServerProtocol, "V1.6", "PM67623");
            logger.error((Object)errMsg);
            if (infoBuffer != null) {
                infoBuffer.append(errMsg + "\n");
                return;
            }
            logger.error(Messages.ERROR_TITLE, errMsg);
            throw new CommunicationException(errMsg);
        }
    }

    private static boolean supportDetailedDiagnosis(HostDetails hostDetails) throws CommunicationException {
        String serverProtocolVersion = hostDetails.getServerProperties().get("SERVERVERSION");
        try {
            int major = Integer.parseInt(serverProtocolVersion.substring(0, serverProtocolVersion.indexOf(46)));
            int minor = Integer.parseInt(serverProtocolVersion.substring(serverProtocolVersion.indexOf(46) + 1));
            return major >= 1 && minor >= 3;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Map<String, String> parseServerResponse(NonBlockingSocketIOJhost socketIO, HostDetails hostDetails, IHowIsGoing monitor) throws AuthTokenExpiredException, CommunicationException, InterruptedException, IOException {
        HashMap<String, String> responses = new HashMap<String, String>();
        int responseLength = socketIO.readUnsignedInt(monitor);
        if (responseLength == -1 || responseLength > 65536) {
            String msg = MessageFormat.format(Messages.NewConnectionProviderJhost_InvalidResponseLength, responseLength);
            logger.error((Object)msg);
            throw new CommunicationException(msg);
        }
        byte[] data = new byte[responseLength];
        socketIO.readBytes(data, responseLength, monitor);
        String serverResponse = new String(data, hostDetails.getHostType().getCommunicationEncoding());
        logger.trace((Object)serverResponse);
        if ("Server AT-TLS rule is missing or invalid.".equals(serverResponse)) {
            throw new IOException(Messages.NewConnectionProviderJhost_NoOrBadATTLSRule);
        }
        if ("PASSTK token invalid or expired".equals(serverResponse.trim())) {
            throw new AuthTokenExpiredException();
        }
        StringTokenizer st = new StringTokenizer(serverResponse, ",");
        while (st.hasMoreTokens()) {
            String keyValuePair = st.nextToken();
            int equalindex = keyValuePair.indexOf(61);
            if (equalindex == -1) {
                throw new CommunicationException(MessageFormat.format(Messages.Connection_InvalidResponseDataFromHost, serverResponse));
            }
            String key = keyValuePair.substring(0, equalindex).trim();
            String value = keyValuePair.substring(equalindex + 1).trim();
            responses.put(key, value);
        }
        return responses;
    }
}

