/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.Messages;
import java.util.ArrayList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HostType {
    ZOS(Messages.HostType_ZOS){

        @Override
        public String getDefaultEncoding() {
            return HostType.ZOS_DEFAULT_ENCODING;
        }

        @Override
        public String getCommunicationEncoding() {
            return HostType.ZOS_DEFAULT_ENCODING;
        }
    }
    ,
    POWER_AIX(Messages.HostType_AIX){

        @Override
        public String getDefaultEncoding() {
            return HostType.UNICODE_ENCODING;
        }

        @Override
        public String getCommunicationEncoding() {
            return HostType.UNICODE_ENCODING;
        }
    }
    ,
    POWER_REDHAT(Messages.HostType_RedHat){

        @Override
        public String getDefaultEncoding() {
            return HostType.UNICODE_ENCODING;
        }

        @Override
        public String getCommunicationEncoding() {
            return HostType.UNICODE_ENCODING;
        }
    }
    ,
    INTEL_LINUX(Messages.HostType_Linux){

        @Override
        public String getDefaultEncoding() {
            return HostType.UNICODE_ENCODING;
        }

        @Override
        public String getCommunicationEncoding() {
            return HostType.UNICODE_ENCODING;
        }
    }
    ,
    LOCAL_HOST(Messages.HostType_LocalHost, false){

        @Override
        public String getDefaultEncoding() {
            return HostType.UNICODE_ENCODING;
        }

        @Override
        public String getCommunicationEncoding() {
            return HostType.UNICODE_ENCODING;
        }
    };

    private static final String ZOS_DEFAULT_ENCODING = "cp037";
    private static final String UNICODE_ENCODING = "utf-8";
    private String name;
    private boolean instanceable;

    private HostType(String name) {
        this(name, true);
    }

    private HostType(String name, boolean instanceable) {
        this.name = name;
        this.instanceable = instanceable;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInstanceable() {
        return this.instanceable;
    }

    public static HostType getDefaultHostType() {
        return ZOS;
    }

    public static boolean validHostType(String aType) {
        if (aType == null || aType.trim().isEmpty()) {
            return false;
        }
        HostType[] hostTypeArray = HostType.values();
        int n = hostTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HostType aHostType = hostTypeArray[n2];
            if (aHostType.toString().equalsIgnoreCase(aType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static HostType parseHostType(String aType) {
        if (aType == null || aType.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid host type: " + aType);
        }
        HostType[] hostTypeArray = HostType.values();
        int n = hostTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HostType aHostType = hostTypeArray[n2];
            if (aHostType.toString().equalsIgnoreCase(aType)) {
                return aHostType;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid host type: " + aType);
    }

    public static HostType[] instanceableValues() {
        ArrayList<HostType> hostTypes = new ArrayList<HostType>();
        HostType[] hostTypeArray = HostType.values();
        int n = hostTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HostType aHostType = hostTypeArray[n2];
            if (aHostType.isInstanceable()) {
                hostTypes.add(aHostType);
            }
            ++n2;
        }
        return hostTypes.toArray(new HostType[hostTypes.size()]);
    }

    public abstract String getDefaultEncoding();

    public abstract String getCommunicationEncoding();
}

