/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.Messages;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.ConnectState;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.PDGenerics;
import com.ibm.pdtools.common.component.jhost.util.TimeUtils;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ConnectionProgressReporter {
    private static final PDLoggerJhost logger = PDLoggerJhost.get(ConnectionProgressReporter.class);
    private final HostDetails hostDetails;
    private final AuthDetails authDetails;
    private final SubMonitor subMonitor;
    private Calendar connectTime;
    private Calendar stateChangeTIme;
    private final StringBuilder info;

    public ConnectionProgressReporter(HostDetails HostDetailsSupplier, AuthDetails authDetailsSupplier, IHowIsGoing monitor, StringBuilder info) {
        this.hostDetails = Objects.requireNonNull(HostDetailsSupplier, "Can only provide logging if connection details are non-null.");
        this.authDetails = Objects.requireNonNull(authDetailsSupplier, "Can only provide logging if auth details are non-null.");
        NullProgressMonitor ipm = null;
        if (monitor != null) {
            ipm = PDGenerics.castIfInstanceOf(monitor.getMonitor(), IProgressMonitor.class);
        }
        this.subMonitor = SubMonitor.convert((IProgressMonitor)(ipm == null ? new NullProgressMonitor() : ipm), (String)Messages.ConnectionProgressReporter_0, (int)ConnectState.values().length);
        this.info = info;
        this.connectTime = Calendar.getInstance();
        this.stateChangeTIme = Calendar.getInstance();
    }

    public void logConnectionStateChange(ConnectState state) throws InterruptedException {
        Objects.requireNonNull(state, "Must specify connection state.");
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("{7}@{2}:{3} {4} {0} {1} | {5} | {6} ", new Object[]{state, state.getProgressMessage(), this.hostDetails.getHostname(), this.hostDetails.getPortNumber(), this.hostDetails.getHostDefaultEncoding(), TimeUtils.formatDifference(this.stateChangeTIme, Calendar.getInstance()), TimeUtils.formatDifference(this.connectTime, Calendar.getInstance()), this.authDetails.getUsername()}).replace('\n', ' '));
        }
        this.stateChangeTIme = Calendar.getInstance();
        this.subMonitor.worked(1);
        this.subMonitor.subTask(state.getProgressMessage());
        if (this.info != null) {
            String msg = state.getStatusMessage(this.hostDetails, this.authDetails);
            if (msg != null) {
                this.info.append(msg.trim() + System.lineSeparator());
            } else {
                logger.error((Object)(String.valueOf((Object)state) + " has a null status message!"));
            }
        }
        if (this.subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
    }
}

