/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.Messages;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import java.text.MessageFormat;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ConnectState {
    S1_START{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return MessageFormat.format(Messages.NewConnectionProvider_2, hd.getHostname(), hd.getPortNumber());
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_Connecting;
        }
    }
    ,
    S1_b_Retrieving_Authentication_Details{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return MessageFormat.format(Messages.NewConnectionProvider_5, ad.getUsername());
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_1;
        }
    }
    ,
    S1_C_Socket_Connected{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_6;
        }

        @Override
        String getProgressMessage() {
            return Messages.NewConnectionProvider_6;
        }
    }
    ,
    S2_PARSING_SERVER_PROPERTIES{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return "";
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_ParsingServerProps;
        }
    }
    ,
    S3_CHECK_PROTOCOL_VERSION{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return "";
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_CheckingProtocolVersion;
        }
    }
    ,
    S4_FIRST_SSL_HANDSHAKE{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_16;
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_FirstSSLHandshake;
        }
    }
    ,
    S4_B_FIRST_SSL_HANDSHAKE_COMPLETED{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_17;
        }

        @Override
        String getProgressMessage() {
            return Messages.NewConnectionProvider_17;
        }
    }
    ,
    S5_RETRIEVE_SERVER_CONFIGURATION{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_20;
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_RetrievingServerConfig;
        }
    }
    ,
    S6_PARSING_RESPONSE_FROM_SERVER{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_22;
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_ParsingServerResponse;
        }
    }
    ,
    S7_LOADING_INSTALLED_EXTENSIONS_INFO{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_30;
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_LoadingInstalledExtensions;
        }
    }
    ,
    S8_A_SECOND_HANDSHAKE{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_34;
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_DoingSecondHandshake;
        }
    }
    ,
    S8_B_AT_TLS_DO_SKIPPING_SECOND_HANDSHAKE{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.ConnectState_SSLAndUsingATTLS;
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_SkippingSecondHandshakeUsingATTLS;
        }
    }
    ,
    S8_A_SECOND_HANDSHAKE_COMPLETE{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_35;
        }

        @Override
        String getProgressMessage() {
            return Messages.NewConnectionProvider_35;
        }
    }
    ,
    S9_ASK_SERVER_FOR_STATUS{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return "";
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_AskServerForStatus;
        }
    }
    ,
    S10_Connected{

        @Override
        String getStatusMessage(HostDetails hd, AuthDetails ad) {
            return Messages.NewConnectionProvider_40;
        }

        @Override
        String getProgressMessage() {
            return Messages.ConnectState_FinishedConnect;
        }
    };


    abstract String getStatusMessage(HostDetails var1, AuthDetails var2);

    abstract String getProgressMessage();
}

