/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost.comms;

import com.ibm.pdtools.common.component.jhost.comms.TheCredential;
import java.io.Serializable;
import java.util.Objects;

public class AuthDetails
implements Serializable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final long serialVersionUID = 2L;
    private String profileName;
    private String username;
    private String pwd;
    private String passToken;
    private boolean savePassword = false;
    private boolean requiredAuthentication = true;

    public static boolean isValidUsername(String username) {
        Objects.requireNonNull(username, "Please specify a non-null username.");
        return username.length() >= 1;
    }

    public AuthDetails(String profileName, String username, String password) {
        if (!AuthDetails.isValidUsername(username)) {
            throw new IllegalArgumentException(username);
        }
        this.profileName = profileName != null ? profileName : "";
        this.username = username;
        this.pwd = password;
    }

    public AuthDetails(String profileName, String username, boolean requiredAuthentication) {
        if (!AuthDetails.isValidUsername(username)) {
            throw new IllegalArgumentException(username);
        }
        this.profileName = profileName != null ? profileName : "";
        this.username = username;
        this.pwd = "";
        this.requiredAuthentication = requiredAuthentication;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.pwd = password;
    }

    public String getPassword() {
        return this.pwd;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public boolean isAuthenticationRequired() {
        return this.requiredAuthentication;
    }

    public String toString() {
        String strRep = this.username + "/";
        strRep = this.pwd == null ? strRep + "<No Password Saved>" : strRep + this.pwd.replaceAll(".", "*");
        return strRep;
    }

    public int hashCode() {
        return this.username.hashCode() * this.pwd.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthDetails) {
            AuthDetails otherAuth = (AuthDetails)obj;
            if (this.pwd == null) {
                return this.username.equals(otherAuth.username);
            }
            return this.username.equals(otherAuth.username) && this.pwd.equals(otherAuth.pwd);
        }
        return false;
    }

    public static AuthDetails makeAuthDetails(String profileName, TheCredential theCredential) throws NullPointerException {
        Objects.requireNonNull(theCredential, "Must provide non-null theCredential to make AuthDetails.");
        return new AuthDetails(profileName, theCredential.getUserId(), theCredential.getPass());
    }

    public String getPassToken() {
        return this.passToken;
    }

    public void setPassToken(String passToken) {
        this.passToken = passToken;
    }
}

