/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.jhost;

import com.ibm.pdtools.common.component.jhost.IAuthDetailsFetcher;
import com.ibm.pdtools.common.component.jhost.IAuthTokenManager;
import com.ibm.pdtools.common.component.jhost.Messages;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener2;
import com.ibm.pdtools.common.component.jhost.core.model.ICertificateTruster;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.prefs.CertificateInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;

public class PDToolsCommonServerClientJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PD_TOOLS_PROJECT_NAME = "PDTools";
    public static final int PROTOCOL_VERSION_MAJOR = 1;
    public static final int PROTOCOL_VERSION_MINOR = 3;
    public static final String CURRENT_PDTCS_VERSION = "V1.6";
    public static final String CURRENT_APAR_LEVEL = "PM67623";
    public static final String IPV_FILE = "ipv.certs";
    private static PDToolsCommonServerClientJhost plugin;
    private ArrayList<CertificateInformation> knownCertificate;
    private final ArrayList<IPDToolsConnectionRequestListener> connectionRequestListeners = new ArrayList();
    private final ArrayList<IPDToolsConnectionRequestListener2> connectionRequestListeners2 = new ArrayList();
    private static IAuthDetailsFetcher authFetcher;
    private static IAuthDetailsFetcher pwdChangeFetcher;
    private static IAuthTokenManager authTokenManager;
    private File certificateFile;
    private static ICertificateTruster certificateTruster;

    static {
        authFetcher = null;
        pwdChangeFetcher = null;
        authTokenManager = null;
        certificateTruster = null;
    }

    private PDToolsCommonServerClientJhost() {
    }

    public static PDToolsCommonServerClientJhost getDefault() {
        if (plugin == null) {
            plugin = new PDToolsCommonServerClientJhost();
        }
        return plugin;
    }

    public static IAuthDetailsFetcher getAuthDetailsFetcher() {
        return authFetcher;
    }

    public static void setAuthDetailsFetcher(IAuthDetailsFetcher authFetcher) {
        PDToolsCommonServerClientJhost.authFetcher = authFetcher;
    }

    public static IAuthDetailsFetcher getPwdChangeFetcher() {
        return pwdChangeFetcher;
    }

    public static void setPwdChangeFetcher(IAuthDetailsFetcher pwdChangeFetcher) {
        PDToolsCommonServerClientJhost.pwdChangeFetcher = pwdChangeFetcher;
    }

    public static IAuthTokenManager getAuthTokenManager() {
        return authTokenManager;
    }

    public static void setAuthTokenManager(IAuthTokenManager authTokenManager) {
        PDToolsCommonServerClientJhost.authTokenManager = authTokenManager;
    }

    public ArrayList<CertificateInformation> getKnownCertificates() {
        return this.knownCertificate;
    }

    public void setKnownCertificates(ArrayList<CertificateInformation> knownCertificate) {
        this.knownCertificate = knownCertificate;
    }

    public void addNewCertificate(CertificateInformation newCertificate) {
        if (!this.certificateExists(newCertificate)) {
            this.knownCertificate.add(newCertificate);
            this.saveCertificates();
        }
    }

    public boolean certificateExists(CertificateInformation certificateDetails) {
        if (this.knownCertificate != null) {
            int i = 0;
            while (i < this.knownCertificate.size()) {
                CertificateInformation aCert = this.knownCertificate.get(i);
                if (aCert.equals(certificateDetails)) {
                    return true;
                }
                ++i;
            }
        } else {
            this.setKnownCertificates(new ArrayList<CertificateInformation>());
        }
        return false;
    }

    public void removeCertificate(CertificateInformation aCertificate) {
        if (this.knownCertificate == null) {
            this.setKnownCertificates(new ArrayList<CertificateInformation>());
        }
        int i = 0;
        while (i < this.knownCertificate.size()) {
            CertificateInformation aCert = this.knownCertificate.get(i);
            if (aCert.getCertificateDetails() != null && aCert.getCertificateDetails().equals(aCertificate.getCertificateDetails())) {
                this.knownCertificate.remove(i);
                return;
            }
            ++i;
        }
        this.saveCertificates();
    }

    public void setCertificateFileLocation(File file) {
        this.certificateFile = file;
        this.loadCertificates();
    }

    public void saveCertificates() {
        if (this.certificateFile != null) {
            if (this.certificateFile.exists() && !this.certificateFile.delete()) {
                PDLoggerJhost.get(PDToolsCommonServerClientJhost.class).error((Object)"Exception occured while deleting cert file before saving.");
            }
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.certificateFile));){
                    output.writeObject(PDToolsCommonServerClientJhost.getDefault().getKnownCertificates());
                    PDLoggerJhost.get(PDToolsCommonServerClientJhost.class).trace((Object)MessageFormat.format("Saved certificates to {0}", this.certificateFile));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PDLoggerJhost.get(PDToolsCommonServerClientJhost.class).error((Object)("Error occurred while writing certificate file: " + String.valueOf(e)));
            }
        }
    }

    private void loadCertificates() {
        if (this.certificateFile != null) {
            if (this.certificateFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (ObjectInputStream input = new ObjectInputStream(new FileInputStream(this.certificateFile));){
                        this.setKnownCertificates((ArrayList)input.readObject());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    this.setKnownCertificates(new ArrayList<CertificateInformation>());
                }
            } else {
                this.setKnownCertificates(new ArrayList<CertificateInformation>());
            }
        }
    }

    public static synchronized void setCertificateTruster(ICertificateTruster truster) {
        if (certificateTruster == null) {
            certificateTruster = truster;
        }
    }

    public boolean acceptCertificate(X509Certificate aCertificate) {
        if (this.certificateExists(CertificateInformation.getInstance(Objects.requireNonNull(aCertificate)))) {
            return true;
        }
        if (certificateTruster == null) {
            PDLoggerJhost.get(PDToolsCommonServerClientJhost.class).error((Object)Messages.PDToolsCommonServerClientJhost0);
        } else if (certificateTruster.isCertificateTrusted(aCertificate)) {
            return true;
        }
        return false;
    }

    @Deprecated
    public void addConnectionListener(IPDToolsConnectionRequestListener aListener) {
        if (aListener != null) {
            this.connectionRequestListeners.add(aListener);
        }
    }

    @Deprecated
    public ArrayList<IPDToolsConnectionRequestListener> getListeners() {
        return this.connectionRequestListeners;
    }

    @Deprecated
    public void removeListener(IPDToolsConnectionRequestListener aListener) {
        if (aListener != null) {
            this.connectionRequestListeners.remove(aListener);
        }
    }

    public void addConnectionListener2(IPDToolsConnectionRequestListener2 aListener) {
        if (aListener != null) {
            this.connectionRequestListeners2.add(aListener);
        }
    }

    public ArrayList<IPDToolsConnectionRequestListener2> getListeners2() {
        return this.connectionRequestListeners2;
    }

    public void removeListener(IPDToolsConnectionRequestListener2 aListener) {
        if (aListener != null) {
            this.connectionRequestListeners2.remove(aListener);
        }
    }
}

