/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.wizards.ims.ImsUtilFuncWizardModel;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class ImsWizardProcessingKeysOptions {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ImsUtilFuncWizardModel<?> model;
    private final ModelViewConnector controller;
    private final Class<?> clazz;
    private Combo wKeysRange;
    private Combo wKeysList;
    private Combo wKeysFile;
    private Combo wMaxNumSegments;
    private Button wDisplayDatabaseDataSetNames;

    public ImsWizardProcessingKeysOptions(ImsUtilFuncWizardModel<?> model, ModelViewConnector controller, Class<?> clazz, Group group) {
        this.model = model;
        this.controller = controller;
        this.clazz = clazz;
        this.createControl(group);
    }

    public void createControl(Group processingGroup) {
        GUI.label.left((Composite)processingGroup, (String)Messages.ImsWizardProcessingKeysOptions_KeyRange, (Object)GUI.grid.d.left1());
        this.wKeysRange = GUI.combo.editable((Composite)processingGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wKeysRange.setToolTipText(Messages.ImsWizardProcessingKeysOptions_KeyRangeTooltip);
        new ComboValueSaver(this.wKeysRange, this.clazz.getCanonicalName() + "keyRange");
        GUI.label.left((Composite)processingGroup, (String)Messages.ImsWizardProcessingKeysOptions_KeyList, (Object)GUI.grid.d.left1());
        this.wKeysList = GUI.combo.editable((Composite)processingGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wKeysList.setToolTipText(Messages.ImsWizardProcessingKeysOptions_KeyListTooltip);
        new ComboValueSaver(this.wKeysList, this.clazz.getCanonicalName() + "keysList");
        GUI.label.left((Composite)processingGroup, (String)Messages.ImsWizardProcessingKeysOptions_KeysFile, (Object)GUI.grid.d.left1());
        this.wKeysFile = GUI.combo.editable((Composite)processingGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wKeysFile.setToolTipText(Messages.ImsWizardProcessingKeysOptions_KeysFileTooltip);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)processingGroup), this.wKeysFile, this.model).types(DataSet.class, Member.class).addResourceContentProposals(this.clazz.getCanonicalName() + "KeysFile").create();
        GUI.label.left((Composite)processingGroup, (String)Messages.ImsWizardProcessingKeysOptions_MaxRoots, (Object)GUI.grid.d.left1());
        this.wMaxNumSegments = GUI.combo.editable((Composite)processingGroup, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer.addTo(this.wMaxNumSegments, this.getClass().getCanonicalName() + "maxNumSegments");
        this.wMaxNumSegments.setToolTipText(Messages.ImsWizardProcessingKeysOptions_MaxRootsTooltip);
        this.wDisplayDatabaseDataSetNames = GUI.button.checkbox((Composite)processingGroup, (String)Messages.ImsWizardProcessingKeysOptions_DisplayDBDatasetNames, (Object)GUI.grid.d.fillH((int)2));
        this.controller.listenTo((Control)this.wMaxNumSegments);
        this.controller.listenTo((Control)this.wDisplayDatabaseDataSetNames);
        this.controller.listenTo((Control)this.wKeysRange);
        this.controller.listenTo((Control)this.wKeysList);
        this.controller.listenTo((Control)this.wKeysFile);
        this.wKeysRange.setFocus();
    }

    public void updateViewFromModelImpl() {
        ModelViewConnector.setText((Combo)this.wKeysRange, (String)this.model.getKeyRange());
        ModelViewConnector.setText((Combo)this.wKeysList, (String)this.model.getKeyList());
        ModelViewConnector.setText((Combo)this.wKeysFile, (String)this.model.getKeysFileDd());
        ModelViewConnector.setText((Combo)this.wMaxNumSegments, (String)this.model.getMaxNumberSegments());
        this.wDisplayDatabaseDataSetNames.setSelection(this.model.isEditingDatabaseDataSets());
        this.wDisplayDatabaseDataSetNames.setEnabled(this.model.getRegionType() == ImsRegionType.DLI);
    }

    protected void updateModelFromViewImpl() {
        this.model.setKeyList(this.wKeysList.getText());
        this.model.setKeyRange(this.wKeysRange.getText());
        this.model.setKeysFileDd(this.wKeysFile.getText());
        this.model.setEditingDatabaseDataSets(this.wDisplayDatabaseDataSetNames.getSelection());
        this.model.setMaxNumberSegments(this.wMaxNumSegments.getText());
    }

    public String getValidationErrorMessage() {
        if (!this.model.getKeysFileDd().isEmpty() && !Member.isParseable((String)this.model.getKeysFileDd(), (boolean)false, (String)this.model.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsWizardProcessingKeysOptions_KeysFileInvalidError, this.model.getKeysFileDd());
        }
        return null;
    }
}

