/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsBmpRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ImsDatabaseLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsPcbLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsPsbLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.views.systems.handlers.ModifyImsSubsystemConfig;
import com.ibm.etools.fm.ui.wizards.ims.ImsUtilFuncWizardModel;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ImsWizardFirstPageHeader {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ImsUtilFuncWizardModel<?> model;
    private final ModelViewConnector controller;
    private Text wSubsystem;
    private Button wSubsystemLookup;
    private Button wRegionBmp;
    private Button wRegionDli;
    private Button wModeDynamic;
    private Button wModeStatic;
    private Composite wModeComposite;
    private Composite wStaticComposite;
    private Composite wDynamicComposite;
    private Button wDatabaseLookup;
    private Button wPsbLookup;
    private Button wPcbLookup;
    private Combo wPsbMember;
    private Combo wDatabaseNameStatic;
    private Combo wDatabaseNameDynamic;
    private final Class<?> clazz;

    public ImsWizardFirstPageHeader(ImsUtilFuncWizardModel<?> model, ModelViewConnector controller, Class<?> clazz, Group group) {
        this.model = model;
        this.controller = controller;
        this.clazz = clazz;
        this.createSubsystemsWidgets(group);
        this.createRegionTypeWidgets(group);
        this.createModeWidgets(group);
        controller.listenTo((Control)this.getwRegionBmp());
        controller.listenTo((Control)this.getwRegionDli());
        controller.listenTo((Control)this.getwModeStatic());
        controller.listenTo((Control)this.getwModeDynamic());
        controller.listenTo((Control)this.getwDatabaseNameDynamic());
        controller.listenTo((Control)this.getwDatabaseNameStatic());
        controller.listenTo((Control)this.getwPsbMember());
    }

    public ImsUtilFuncWizardModel<?> getModel() {
        return this.model;
    }

    public ModelViewConnector getController() {
        return this.controller;
    }

    public Text getwSubsystem() {
        return this.wSubsystem;
    }

    public Button getwSubsystemLookup() {
        return this.wSubsystemLookup;
    }

    public Button getwRegionBmp() {
        return this.wRegionBmp;
    }

    public Button getwRegionDli() {
        return this.wRegionDli;
    }

    public Button getwModeDynamic() {
        return this.wModeDynamic;
    }

    public Button getwModeStatic() {
        return this.wModeStatic;
    }

    public Composite getwModeComposite() {
        return this.wModeComposite;
    }

    public Composite getwStaticComposite() {
        return this.wStaticComposite;
    }

    public Composite getwDynamicComposite() {
        return this.wDynamicComposite;
    }

    public Button getwDatabaseLookup() {
        return this.wDatabaseLookup;
    }

    public Button getwPsbLookup() {
        return this.wPsbLookup;
    }

    public Button getwPcbLookup() {
        return this.wPcbLookup;
    }

    public Combo getwPsbMember() {
        return this.wPsbMember;
    }

    public Combo getwDatabaseNameStatic() {
        return this.wDatabaseNameStatic;
    }

    public Combo getwDatabaseNameDynamic() {
        return this.wDatabaseNameDynamic;
    }

    public void createSubsystemsWidgets(Group parent) {
        GUI.label.left((Composite)parent, (String)Messages.ImsWizardFirstPageHeader_Subsystem, (Object)GUI.grid.d.left1());
        this.wSubsystem = GUI.text.fieldReadOnly((Composite)parent, (Object)GUI.grid.d.fillH((int)1));
        Composite subsystemButtonsComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.left1());
        Button wSubsystemEdit = GUI.button.push((Composite)subsystemButtonsComp, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/ims_customize_subsystem_config.gif"), (String)Messages.CUSTOMIZE_IMS_SUBSYSTEM, (Object)GUI.grid.d.left1());
        wSubsystemEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsSubsystemConfig config = ImsWizardFirstPageHeader.this.model.getSubsystemConfig();
                boolean editSuccess = ModifyImsSubsystemConfig.editConfigAndSaveIfSuccessful(config);
                if (editSuccess) {
                    ImsWizardFirstPageHeader.this.controller.doManualViewUpdate();
                }
            }
        });
        this.wSubsystemLookup = LookupButton.createLookupButtonLeft1(subsystemButtonsComp);
        this.wSubsystemLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsSubsystemConfig selectedConfig = ImsSubsystemLookupDialog.promptForValidConfig(ImsWizardFirstPageHeader.this.model.getSystem(), null);
                if (selectedConfig != null) {
                    ImsWizardFirstPageHeader.this.model.setSubsystemConfig(selectedConfig);
                }
            }
        });
    }

    public void createRegionTypeWidgets(Group parent) {
        GUI.label.left((Composite)parent, (String)Messages.ImsWizardFirstPageHeader_RegionType, (Object)new GridData(16384, 128, false, false, 1, 1));
        Composite regionTypeComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        this.wRegionBmp = GUI.button.radio((Composite)regionTypeComp, (String)Messages.ImsWizardFirstPageHeader_BMP, (Object)GUI.grid.d.fillH((int)1));
        this.wRegionDli = GUI.button.radio((Composite)regionTypeComp, (String)Messages.ImsWizardFirstPageHeader_DLI, (Object)GUI.grid.d.fillH((int)1));
    }

    public void createModeWidgets(Group parent) {
        GUI.label.left((Composite)parent, (String)Messages.ImsWizardFirstPageHeader_PSBType, (Object)GUI.grid.d.left1());
        Composite modeComp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        this.wModeDynamic = GUI.button.radio((Composite)modeComp, (String)Messages.ImsWizardFirstPageHeader_Dynamic, (Object)GUI.grid.d.fillH((int)1));
        this.wModeStatic = GUI.button.radio((Composite)modeComp, (String)Messages.ImsWizardFirstPageHeader_Static, (Object)GUI.grid.d.fillH((int)1));
        this.wModeComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)3));
        this.wModeComposite.setLayout((Layout)new StackLayout());
        this.createStaticComposite(this.wModeComposite);
        this.createDynamicComposite(this.wModeComposite);
    }

    private void createStaticComposite(Composite parent) {
        this.wStaticComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)5, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)this.wStaticComposite, (String)Messages.ImsWizardFirstPageHeader_PSBName, (Object)GUI.grid.d.left1());
        this.wPsbMember = GUI.combo.editable((Composite)this.wStaticComposite, (Object)GUI.grid.d.fillH((int)3));
        this.wPsbMember.setToolTipText(Messages.ImsWizardFirstPageHeader_PSBNameTooltip);
        new ComboValueSaver(this.wPsbMember, this.clazz.getCanonicalName() + "Psb");
        this.wPsbLookup = LookupButton.createLookupButtonLeft1(this.wStaticComposite);
        this.wPsbLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsPsb selectedPsb;
                if (ImsWizardFirstPageHeader.this.model.getPsbMember().length() <= 8 && (selectedPsb = ImsPsbLookupDialog.promptForValidPsb(ImsWizardFirstPageHeader.this.model.getSystem(), ImsWizardFirstPageHeader.this.model.getSubsystemConfig(), ImsWizardFirstPageHeader.this.model.getPsbMember().trim().toUpperCase(), ImsWizardFirstPageHeader.this.model.getRegionType(), ImsWizardFirstPageHeader.this.model.getAccessMode())) != null) {
                    ImsWizardFirstPageHeader.this.model.setPsbMember(selectedPsb.getName());
                    ImsWizardFirstPageHeader.this.model.fireModelChangeEvent();
                }
            }
        });
        GUI.label.left((Composite)this.wStaticComposite, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        this.wDatabaseNameStatic = GUI.combo.editable((Composite)this.wStaticComposite, (Object)GUI.grid.d.fillH((int)3));
        this.wDatabaseNameStatic.setToolTipText(Messages.ImsWizardFirstPageHeader_DBNameTooltip);
        new ComboValueSaver(this.wDatabaseNameStatic, this.clazz.getCanonicalName() + "DatabaseStatic");
        this.wPcbLookup = LookupButton.createLookupButtonLeft1(this.wStaticComposite);
        this.wPcbLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsWizardFirstPageHeader.this.selectPCB(ImsWizardFirstPageHeader.this.model, ImsWizardFirstPageHeader.this.wDatabaseNameStatic.getText().trim().toUpperCase());
            }
        });
    }

    public void selectPCB(ImsUtilFuncWizardModel<?> model, String filter) {
        ImsPcb selectedPcb = ImsPcbLookupDialog.promptForValidPcb(model.getRegionConfig(), model.getPSB(), null, filter);
        if (selectedPcb != null) {
            String pcbName = selectedPcb.getName();
            if (!pcbName.isEmpty() || pcbName != " ") {
                model.setPcbName(pcbName);
            }
            model.setDbdMember(selectedPcb.getDbd().getName());
            model.setPcbIndex(selectedPcb.getIndex());
            model.fireModelChangeEvent();
        }
    }

    private void createDynamicComposite(Composite parent) {
        this.wDynamicComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)this.wDynamicComposite, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        this.wDatabaseNameDynamic = GUI.combo.editable((Composite)this.wDynamicComposite, (Object)GUI.grid.d.fillH((int)2));
        this.wDatabaseNameDynamic.setToolTipText(Messages.ImsWizardFirstPageHeader_DBNameTooltip);
        new ComboValueSaver(this.wDatabaseNameDynamic, this.clazz.getCanonicalName() + "DatabaseDynamic");
        this.wDatabaseLookup = LookupButton.createLookupButtonLeft1(this.wDynamicComposite);
        this.wDatabaseLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsDatabase selectedDatabase = ImsDatabaseLookupDialog.promptForValidConfig(ImsWizardFirstPageHeader.this.model.getSystem(), ImsWizardFirstPageHeader.this.model.getSubsystemConfig(), null, ImsWizardFirstPageHeader.this.model.getDbdMember(), ImsWizardFirstPageHeader.this.model.getRegionType(), ImsWizardFirstPageHeader.this.model.getAccessMode(), null);
                if (selectedDatabase != null) {
                    ImsWizardFirstPageHeader.this.model.setDbdMember(selectedDatabase.getName());
                    ImsWizardFirstPageHeader.this.model.fireModelChangeEvent();
                }
            }
        });
    }

    public Text getSubSystemText() {
        return this.wSubsystem;
    }

    public Button getSubSystemLookupButton() {
        return this.wSubsystemLookup;
    }

    public void updateViewFromModel() {
        this.getSubSystemText().setText(this.model.getSubsystemConfig().getLabel());
        this.getwRegionBmp().setSelection(this.model.getRegionType() == ImsRegionType.BMP);
        this.getwRegionDli().setSelection(this.model.getRegionType() == ImsRegionType.DLI);
        this.getwModeStatic().setSelection(this.model.getAccessMode() == ImsAccessMode.STATIC);
        this.getwModeDynamic().setSelection(this.model.getAccessMode() == ImsAccessMode.DYNAMIC);
        if (this.model.getAccessMode() == ImsAccessMode.STATIC) {
            ModelViewConnector.setText((Combo)this.getwDatabaseNameStatic(), (String)this.model.getDbdMember());
            ModelViewConnector.setText((Combo)this.getwDatabaseNameDynamic(), (String)"");
        } else {
            ModelViewConnector.setText((Combo)this.getwDatabaseNameDynamic(), (String)this.model.getDbdMember());
            ModelViewConnector.setText((Combo)this.getwDatabaseNameStatic(), (String)"");
        }
        ModelViewConnector.setText((Combo)this.getwPsbMember(), (String)this.model.getPsbMember());
        this.getwRegionBmp().setEnabled(this.model.getSubsystemConfig().getBmpConfig().isConnectable());
        this.getwRegionDli().setEnabled(this.model.getSubsystemConfig().getDliConfig().isConnectable());
        ImsBmpRegionConfig regionConfig = this.model.getRegionType() == ImsRegionType.BMP ? this.model.getSubsystemConfig().getBmpConfig() : this.model.getSubsystemConfig().getDliConfig();
        this.getwModeDynamic().setEnabled(regionConfig.isDynamicAccessSupported() && !this.model.getSubsystemConfig().isDir());
        this.getwModeStatic().setEnabled(regionConfig.isStaticAccessSupported());
        this.showMode(this.model.getAccessMode() == ImsAccessMode.DYNAMIC);
        this.getwDatabaseNameDynamic().setEnabled(this.model.getAccessMode() == ImsAccessMode.DYNAMIC);
        this.getwPsbMember().setEnabled(this.model.getAccessMode() == ImsAccessMode.STATIC);
        this.getwPcbLookup().setEnabled(Member.isValidName((String)this.model.getPsbMember(), (String)this.model.getSystem().getCodePage()));
    }

    public void updateModelFromView() {
        if (this.getwRegionBmp().getSelection()) {
            this.model.setRegionType(ImsRegionType.BMP);
        } else if (this.getwRegionDli().getSelection()) {
            this.model.setRegionType(ImsRegionType.DLI);
        }
        if (this.getwModeStatic().getSelection()) {
            this.model.setAccessMode(ImsAccessMode.STATIC);
            this.model.setDbdMember(this.getwDatabaseNameStatic().getText());
        } else if (this.getwModeDynamic().getSelection()) {
            this.model.setAccessMode(ImsAccessMode.DYNAMIC);
            this.model.setDbdMember(this.getwDatabaseNameDynamic().getText());
        }
        this.model.setPsbMember(this.getwPsbMember().getText());
    }

    private void showMode(boolean isDynamic) {
        Layout layout = this.getwModeComposite().getLayout();
        if (layout instanceof StackLayout) {
            ((StackLayout)layout).topControl = isDynamic ? this.getwDynamicComposite() : this.getwStaticComposite();
            this.getwModeComposite().layout();
        }
    }

    public boolean setFocus() {
        if (this.model.getSubsystemConfig() == null) {
            this.getSubSystemLookupButton().setFocus();
        } else if (this.model.getAccessMode() == ImsAccessMode.DYNAMIC && this.model.getDbdMember().isEmpty()) {
            this.getwDatabaseNameDynamic().setFocus();
        } else if (this.model.getAccessMode() == ImsAccessMode.STATIC && this.model.getPsbMember().isEmpty()) {
            this.getwPsbMember().setFocus();
        } else {
            return false;
        }
        return true;
    }

    public String getValidationErrorMessage() {
        if (this.model.getSubsystemConfig() == null) {
            return Messages.ImsWizardFirstPageHeader_SubsystemTooltip;
        }
        if (this.model.getAccessMode() == ImsAccessMode.DYNAMIC) {
            if (this.model.getDbdMember().isEmpty()) {
                return Messages.ImsWizardFirstPageHeader_DBNameEmptyError;
            }
            if (!Member.isValidName((String)this.model.getDbdMember(), (String)this.model.getSystem().getCodePage())) {
                return MessageFormat.format(Messages.ImsWizardFirstPageHeader_DBNameInvalid, this.model.getDbdMember());
            }
        }
        if (this.model.getAccessMode() == ImsAccessMode.STATIC) {
            if (this.model.getPsbMember().trim().isEmpty()) {
                return Messages.ImsWizardFirstPageHeader_PSBNameEmpty;
            }
            if (!Member.isValidName((String)this.model.getPsbMember(), (String)this.model.getSystem().getCodePage())) {
                return MessageFormat.format(Messages.ImsWizardFirstPageHeader_PSBNameInvalid, this.model.getPsbMember());
            }
            if (!this.model.getDbdMember().isEmpty() && !Member.isValidName((String)this.model.getDbdMember(), (String)this.model.getSystem().getCodePage())) {
                return MessageFormat.format(Messages.ImsWizardFirstPageHeader_DBNameInvalid, this.model.getDbdMember());
            }
        }
        return null;
    }
}

