/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.RelatedDBToPCBMapping;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.dialog.ImsDatabaseDataSetDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsPcbLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsRelatedDBPcbLookupDialog;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.etools.fm.ui.wizards.ims.ImsUtilFuncWizardModel;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public abstract class ImsRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected final ImsUtilFuncWizardModel<?> model;

    public ImsRunnable(ImsUtilFuncWizardModel<?> model) {
        this.model = model;
    }

    private void aRelatedDBIsReferencedByMultiplePCBs(final List<RelatedDBToPCBMapping> loadPCBsMappings) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuilder pcbNum = new StringBuilder("(");
                pcbNum.append(ImsRunnable.this.model.getPcbIndex());
                for (RelatedDBToPCBMapping relatedDB : loadPCBsMappings) {
                    List pcbList = relatedDB.getPcbList();
                    switch (pcbList.size()) {
                        case 1: {
                            pcbNum.append(",").append(((ImsPcb)pcbList.get(0)).getIndex());
                            break;
                        }
                        default: {
                            ImsRelatedDBPcbLookupDialog lookupDialog = new ImsRelatedDBPcbLookupDialog(ImsRunnable.this.model.getSystem(), pcbList);
                            if (lookupDialog.open() == 0) {
                                ImsPcb pcb = (ImsPcb)lookupDialog.getFirstSelectedObject();
                                pcbNum.append(",").append(pcb.getIndex());
                                break;
                            }
                            return;
                        }
                    }
                }
                pcbNum.append(")");
                ImsRunnable.this.model.setPcbIndex(pcbNum.toString());
                ImsRunnable.this.model.fireModelChangeEvent();
            }
        });
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        monitor.beginTask(this.getName(), 30);
        monitor.worked(1);
        Result<StringBuffer> result = null;
        monitor.worked(1);
        try {
            Result<StringBuffer> result2;
            block19: {
                Throwable throwable = null;
                Object var4_7 = null;
                CommonConnectionFM connection = (CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(this.model.getSubsystem().getSystem(), (IPDConnectEndpoint)this.model.getSubsystem(), monitor);
                try {
                    if (this.model.getRegionType() == ImsRegionType.DLI && !this.model.getSubsystemConfig().getDliConfig().getDynamicAllocationUsedForDDs() && this.model.getDatabaseInfo() != null && !this.model.getDatabaseInfo().isHalDb()) {
                        result = ImsDatabaseDataSetDialog.allocateDatabaseDataSets(connection, this.model.getDatabase(), this.model.isEditingDatabaseDataSets(), this.model.getAccessMode(), monitor);
                    }
                    if (result == null) {
                        monitor.worked(1);
                        result = UtilityFunctionRunner.runCommand((CommonConnectionFM)connection, this.model.toUtilityFunction(), (IHowIsGoing)monitor);
                    }
                    result2 = result;
                    if (connection == null) break block19;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    catch (CommunicationException e) {
                        Result result3 = new Result(e);
                        return result3;
                    }
                }
                connection.close();
            }
            return result2;
        }
        finally {
            monitor.worked(1);
            monitor.done();
        }
    }

    @Override
    protected abstract String getName();

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }

    private void mulitplePrimaryPcbs() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ImsPcb pcb = ImsPcbLookupDialog.promptForValidPcb(ImsRunnable.this.model.getRegionConfig(), ImsRunnable.this.model.getPSB(), null, "");
                ImsRunnable.this.model.setDbdMember(pcb.getDbd().getName());
                ImsRunnable.this.model.setPcbIndex(pcb.getIndex());
                ImsRunnable.this.model.setPcbName(pcb.getName());
                ImsRunnable.this.model.fireModelChangeEvent();
            }
        });
    }

    private void onlyOnePcb(ImsPcb pcb) throws CommunicationException {
        if (pcb.getUseabilityNote() != null) {
            throw new CommunicationException(pcb.getUseabilityNote());
        }
        this.model.setDbdMember(pcb.getDbd().getName());
        this.model.setPcbIndex(pcb.getIndex());
        this.model.setPcbName(pcb.getName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ImsRunnable.this.model.fireModelChangeEvent();
            }
        });
    }

    @Override
    protected abstract boolean preWizardClose(IHowIsGoing var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean preIMSWizardClose(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        monitor.beginTask(Messages.ImsRunnable_TaskVerifyIMSFunctionParameters, 15);
        monitor.subTask(Messages.ImsRunnable_SubTask_LoadingPSBs);
        monitor.worked(1);
        if (this.model.getAccessMode() == ImsAccessMode.STATIC) {
            if (!ImsPsb.isValidName((String)this.model.getPsbMember(), (String)this.model.getSystem().getCodePage())) throw new CommunicationException(MessageFormat.format(Messages.ImsRunnable_PSBHasInvalidName, this.model.getPsbMember()));
            Result result = ImsPsb.loadPSBsResults((ImsPsbQuery)new ImsPsbQuery(this.model.getSubsystem(), "*", this.model.getRegionType(), this.model.getAccessMode()), (IHowIsGoing)monitor);
            if (!result.isSuccessfulWithoutWarnings()) throw new CommunicationException(result.getMessagesCombined().toString());
            monitor.worked(1);
            List psbs = (List)result.getOutput();
            boolean psbExists = false;
            for (Member psb : psbs) {
                if (!psb.getName().equals(this.model.getPsbMember())) continue;
                psbExists = true;
                break;
            }
            monitor.worked(1);
            if (!psbExists) throw new CommunicationException(MessageFormat.format(Messages.ImsRunnable_PSBNotFoundInLibs, this.model.getPsbMember()));
            List<ImsPcb> pcbs = this.model.loadPossiblePcbs(monitor);
            monitor.worked(1);
            if (pcbs == null) throw new CommunicationException(MessageFormat.format(Messages.ImsRunnable_PSBHasNoUseablePCBs, this.model.getPsbMember()));
            switch (pcbs.size()) {
                case 0: {
                    throw new CommunicationException(Messages.ImsRunnable_SelectPSBHasNoPCBs);
                }
                case 1: {
                    ImsPcb pcb = pcbs.get(0);
                    this.onlyOnePcb(pcb);
                    break;
                }
                default: {
                    this.mulitplePrimaryPcbs();
                }
            }
            monitor.subTask(Messages.ImsRunnable_SubTask_LoadingPCBsForPSB);
            monitor.worked(1);
            List<RelatedDBToPCBMapping> loadPCBsMappings = this.model.loadPossibleRelatedDBPcbs(monitor, this.model.getPcbIndex());
            monitor.worked(1);
            if (loadPCBsMappings.size() > 0) {
                this.aRelatedDBIsReferencedByMultiplePCBs(loadPCBsMappings);
            }
            monitor.worked(1);
            monitor.subTask(Messages.ImsRunnable_SubTask_CheckingForRelatedDBs);
            return true;
        } else {
            monitor.subTask(Messages.ImsRunnable_SubTask_LoadingDBInfo);
            monitor.worked(3);
            ImsDatabase db = this.model.getDatabase();
            this.model.setDbdMember(db.getName());
            monitor.worked(1);
            Result dbInfoResult = db.loadInfo(monitor, this.model.getFunctionCode(), this.model.getRegionType());
            monitor.worked(1);
            if (!dbInfoResult.isSuccessfulWithoutWarnings()) throw new CommunicationException(MessageFormat.format(Messages.ImsRunnable_FailedToLoadDBInfo, db.getName(), dbInfoResult.getMessagesCombined().toString()));
            this.model.setDatabaseInfo((ImsDatabaseInfo)dbInfoResult.getOutput());
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ImsRunnable.this.model.fireModelChangeEvent();
                }
            });
            monitor.worked(1);
        }
        return true;
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 4);
    }
}

