/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.func.ims.IPR;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.wizards.ims.ImsPrintModel;
import com.ibm.etools.fm.ui.wizards.ims.ImsWizardFirstPageHeader;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ImsPrintWizardPageFirst
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.ImsPrintWizardPageFirst_BasicSettings;
    private final ImsPrintModel model;
    private ImsPrintWizardPageFirstConnector controller = new ImsPrintWizardPageFirstConnector();
    private Combo wView;
    private Button wPrintFormatChar;
    private Button wPrintFormatHex;
    private Button wPrintFormatSingle;
    private Button wPrintFormatTable;
    private ImsWizardFirstPageHeader header;

    protected ImsPrintWizardPageFirst(ImsPrintModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.ImsPrintWizardPageFirst_EnterPrintParameters);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group inputGroup = GUI.group((Composite)parent, (String)Messages.ImsPrintWizardPageFirst_Input, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.header = new ImsWizardFirstPageHeader(this.model, this.controller, ((Object)((Object)this)).getClass(), inputGroup);
        Group outputGroup = GUI.group((Composite)parent, (String)Messages.ImsPrintWizardPageFirst_Output, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)outputGroup, (String)Messages.ImsPrintWizardPageFirst_UseView, (Object)GUI.grid.d.left1());
        this.wView = GUI.combo.editable((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wView.setToolTipText(Messages.ImsPrintWizardPageFirst_UseViewTooltip);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)outputGroup), this.wView, (IHostProvider)this.model).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "view").types(DataSet.class, Member.class).create();
        GUI.label.left((Composite)outputGroup, (String)Messages.ImsPrintWizardPageFirst_PrintFormat, (Object)GUI.grid.d.left1());
        Composite printFormatComp = GUI.composite((Composite)outputGroup, (Layout)GUI.grid.l.noMargins((int)4, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        this.wPrintFormatChar = GUI.button.radio((Composite)printFormatComp, (String)IPR.IprPrtForm.CHAR.getLabel(), (Object)GUI.grid.d.fillH((int)1));
        this.wPrintFormatHex = GUI.button.radio((Composite)printFormatComp, (String)IPR.IprPrtForm.HEX.getLabel(), (Object)GUI.grid.d.fillH((int)1));
        this.wPrintFormatSingle = GUI.button.radio((Composite)printFormatComp, (String)IPR.IprPrtForm.SNGL.getLabel(), (Object)GUI.grid.d.fillH((int)1));
        this.wPrintFormatTable = GUI.button.radio((Composite)printFormatComp, (String)IPR.IprPrtForm.TABL.getLabel(), (Object)GUI.grid.d.fillH((int)1));
        this.controller.listenTo(this.model);
        this.controller.listenTo((Control)this.wView);
        this.controller.listenTo((Control)this.wPrintFormatChar);
        this.controller.listenTo((Control)this.wPrintFormatHex);
        this.controller.listenTo((Control)this.wPrintFormatSingle);
        this.controller.listenTo((Control)this.wPrintFormatTable);
        this.controller.doManualViewUpdate();
        this.header.setFocus();
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.controller.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        String headerError = this.header.getValidationErrorMessage();
        if (headerError != null) {
            return headerError;
        }
        if (this.model.getViewDsn().isEmpty()) {
            if (this.model.getPrintFormat() == IPR.IprPrtForm.SNGL) {
                return Messages.ImsPrintWizardPageFirst_SinglePrintError;
            }
            if (this.model.getPrintFormat() == IPR.IprPrtForm.TABL) {
                return Messages.ImsPrintWizardPageFirst_TableFormatPrintError;
            }
        } else if (!Member.isParseable((String)this.model.getViewDsn(), (boolean)false, (String)this.model.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsPrintWizardPageFirst_ViewDSIsInvalid, this.model.getViewDsn());
        }
        return null;
    }

    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    private class ImsPrintWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ImsPrintWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            ImsPrintWizardPageFirst.this.header.updateModelFromView();
            ImsPrintWizardPageFirst.this.model.setViewDsn(ImsPrintWizardPageFirst.this.wView.getText());
            if (ImsPrintWizardPageFirst.this.wPrintFormatChar.getSelection()) {
                ImsPrintWizardPageFirst.this.model.setPrintFormat(IPR.IprPrtForm.CHAR);
            } else if (ImsPrintWizardPageFirst.this.wPrintFormatHex.getSelection()) {
                ImsPrintWizardPageFirst.this.model.setPrintFormat(IPR.IprPrtForm.HEX);
            } else if (ImsPrintWizardPageFirst.this.wPrintFormatSingle.getSelection()) {
                ImsPrintWizardPageFirst.this.model.setPrintFormat(IPR.IprPrtForm.SNGL);
            } else if (ImsPrintWizardPageFirst.this.wPrintFormatTable.getSelection()) {
                ImsPrintWizardPageFirst.this.model.setPrintFormat(IPR.IprPrtForm.TABL);
            }
            ImsPrintWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            ImsPrintWizardPageFirst.this.header.updateViewFromModel();
            ImsPrintWizardPageFirstConnector.setText((Combo)ImsPrintWizardPageFirst.this.wView, (String)ImsPrintWizardPageFirst.this.model.getViewDsn());
            ImsPrintWizardPageFirst.this.wPrintFormatChar.setSelection(ImsPrintWizardPageFirst.this.model.getPrintFormat() == IPR.IprPrtForm.CHAR);
            ImsPrintWizardPageFirst.this.wPrintFormatHex.setSelection(ImsPrintWizardPageFirst.this.model.getPrintFormat() == IPR.IprPrtForm.HEX);
            ImsPrintWizardPageFirst.this.wPrintFormatSingle.setSelection(ImsPrintWizardPageFirst.this.model.getPrintFormat() == IPR.IprPrtForm.SNGL);
            ImsPrintWizardPageFirst.this.wPrintFormatTable.setSelection(ImsPrintWizardPageFirst.this.model.getPrintFormat() == IPR.IprPrtForm.TABL);
            ImsPrintWizardPageFirst.this.wPrintFormatSingle.setEnabled(!ImsPrintWizardPageFirst.this.model.getViewDsn().isEmpty());
            ImsPrintWizardPageFirst.this.wPrintFormatTable.setEnabled(!ImsPrintWizardPageFirst.this.model.getViewDsn().isEmpty());
            String validationErrorMessage = ImsPrintWizardPageFirst.this.getValidationErrorMessage();
            ImsPrintWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            ImsPrintWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }
    }
}

