/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.wizards.FMWizardResultHelper;
import com.ibm.etools.fm.ui.wizards.ims.ImsPrintModel;
import com.ibm.etools.fm.ui.wizards.ims.ImsRunnable;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;

public class ImsPrintRunnable
extends ImsRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public ImsPrintRunnable(ImsPrintModel model) {
        super(model);
    }

    @Override
    protected String getName() {
        return "Printing data from IMS";
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result = super.execute(monitor);
        if (result != null && result.getRC() <= 4) {
            FMWizardResultHelper.displayResult(result, Messages.ImsPrintRunnable_ImsPrintFailed, monitor);
        }
        monitor.worked(1);
        monitor.done();
        return result;
    }

    @Override
    protected boolean preWizardClose(IHowIsGoing monitor) {
        try {
            return super.preIMSWizardClose(monitor);
        }
        catch (InterruptedException e) {
            logger.trace((Object)"User cancelled pre-wizard close");
            return false;
        }
        catch (CommunicationException e) {
            logger.error((Object)"Failed to complete pre-print checks", (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)Messages.ImsExtractRunnable_Error, (String)Messages.ImsPrintRunnable_0, (String)ThrowableRenderer.renderShortForm((Throwable)e).toString());
            return false;
        }
    }
}

