/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.ims.IPR;
import com.ibm.etools.fm.core.socket.func.ims.RelatedDBToPCBMapping;
import com.ibm.etools.fm.ui.wizards.ims.ImsUtilFuncWizardModel;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Collections;
import java.util.List;

public class ImsPrintModel
extends ImsUtilFuncWizardModel<IPR> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String dbdMember = "";
    private String viewDsn = "";
    private String maxNumberSegments = "";
    private IPR.IprPrtForm printFormat = (IPR.IprPrtForm)IPR.PRTFORM.getDefaultValue();
    private String psbMember = "";
    private String pcbName = "";
    private String pcbIndex = "";
    private String keyRange = "";
    private String keyList = "";
    private String keysFileDd = "";
    private boolean editingDatabaseDataSets = false;
    private ImsDatabaseInfo dbInfo = null;

    public ImsPrintModel(IPDHost host, ImsRegionType regionType) {
        super(host, "IPR");
        this.regionType = regionType;
    }

    protected ImsPrintModel clone() {
        ImsPrintModel copy = new ImsPrintModel(this.getHostProvider(), this.getRegionType());
        copy.setSubsystemConfig(this.getSubsystemConfig());
        copy.regionType = this.regionType;
        copy.accessMode = this.accessMode;
        copy.dbdMember = this.dbdMember;
        copy.viewDsn = this.viewDsn;
        copy.printFormat = this.printFormat;
        copy.psbMember = this.psbMember;
        copy.pcbName = this.pcbName;
        copy.pcbIndex = this.pcbIndex;
        copy.keyRange = this.keyRange;
        copy.keyList = this.keyList;
        copy.keysFileDd = this.keysFileDd;
        copy.maxNumberSegments = this.maxNumberSegments;
        copy.editingDatabaseDataSets = this.editingDatabaseDataSets;
        return copy;
    }

    @Override
    public IPR toUtilityFunction() {
        IPR ipr = new IPR();
        ipr.setSubsystemConfig(this.getSubsystemConfig());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.IMSID, (Object)this.getSubsystem().getSubsystemID(), this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.REGNTYPE, (Object)this.regionType, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.PSBTYPE, (Object)this.accessMode, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.DBDMEM, (Object)this.dbdMember, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.VIEW, (Object)(!this.viewDsn.isEmpty() ? 1 : 0), this.getSubsystem().getSystem());
        if (!this.viewDsn.isEmpty()) {
            ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.VIEWDSN, (Object)this.viewDsn, this.getSubsystem().getSystem());
        }
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.MAXROOTS, (Object)this.maxNumberSegments, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.PRTFORM, (Object)this.printFormat, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.PSBMEM, (Object)this.psbMember, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.PCBNUM, (Object)this.pcbIndex, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.KEYRANGE, (Object)this.keyRange, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.KEYLIST, (Object)this.keyList, this.getSubsystem().getSystem());
        ipr.setValue((NewUtilityFunction.IUtilFuncParam)IPR.KEYPRT, (Object)(!this.keysFileDd.isEmpty() ? 1 : 0), this.getSubsystem().getSystem());
        if (!this.keysFileDd.isEmpty()) {
            ipr.setDD("KEYSFILE", this.keysFileDd);
        }
        return ipr;
    }

    @Override
    public void fromUtilityFunction(IPR function) {
        this.regionType = (ImsRegionType)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.REGNTYPE, this.provider);
        this.accessMode = (ImsAccessMode)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.PSBTYPE, this.provider);
        this.dbdMember = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.DBDMEM, this.provider);
        this.viewDsn = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.VIEWDSN, this.provider);
        this.maxNumberSegments = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.MAXROOTS, this.provider);
        this.printFormat = (IPR.IprPrtForm)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.PRTFORM, this.provider);
        this.psbMember = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.PSBMEM, this.provider);
        this.pcbName = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.PCBNAME, this.provider);
        this.pcbIndex = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.PCBNUM, this.provider);
        this.keyRange = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.KEYRANGE, this.provider);
        this.keyList = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IPR.KEYLIST, this.provider);
        this.keysFileDd = function.getDD("KEYSFILE");
    }

    @Override
    public void setSubsystemConfig(ImsSubsystemConfig config) {
        if (!config.isConnectable()) {
            throw new IllegalArgumentException();
        }
        if (this.regionType == ImsRegionType.BMP && !config.getBmpConfig().isConnectable()) {
            this.regionType = ImsRegionType.DLI;
        } else if (this.regionType == ImsRegionType.DLI && !config.getDliConfig().isConnectable()) {
            this.regionType = ImsRegionType.BMP;
        }
        if (this.regionType == ImsRegionType.BMP) {
            if (this.accessMode == ImsAccessMode.STATIC && !config.getBmpConfig().isStaticAccessSupported()) {
                this.accessMode = ImsAccessMode.DYNAMIC;
            } else if (this.accessMode == ImsAccessMode.DYNAMIC && !config.getBmpConfig().isDynamicAccessSupported()) {
                this.accessMode = ImsAccessMode.STATIC;
            }
        } else if (this.regionType == ImsRegionType.DLI) {
            if (this.accessMode == ImsAccessMode.STATIC && !config.getDliConfig().isStaticAccessSupported()) {
                this.accessMode = ImsAccessMode.DYNAMIC;
            } else if (this.accessMode == ImsAccessMode.DYNAMIC && !config.getDliConfig().isDynamicAccessSupported()) {
                this.accessMode = ImsAccessMode.STATIC;
            }
        }
        super.setSubsystemConfig(config);
    }

    @Override
    public List<ImsPcb> loadPossiblePcbs(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        return ImsPcb.loadPCBsFiltered((IHowIsGoing)monitor, (ImsSubsystem)this.getSubsystem(), (ImsSubsystemConfig)this.getSubsystemConfig(), (ImsRegionType)this.regionType, (String)this.psbMember, (String)this.dbdMember, (String)"IPR");
    }

    @Override
    public List<RelatedDBToPCBMapping> loadPossibleRelatedDBPcbs(IHowIsGoing monitor, String pcbNum) throws InterruptedException, CommunicationException {
        return Collections.emptyList();
    }

    @Override
    public ImsDatabase getDatabase() {
        return new ImsDatabase(this.getSubsystem(), this.dbdMember);
    }

    @Override
    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    @Override
    public void setRegionType(ImsRegionType regionType) {
        this.regionType = regionType;
    }

    @Override
    public ImsAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void setAccessMode(ImsAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public String getDbdMember() {
        return this.dbdMember;
    }

    @Override
    public void setDbdMember(String dbdMemberName) {
        this.dbdMember = dbdMemberName;
    }

    public String getViewDsn() {
        return this.viewDsn;
    }

    public void setViewDsn(String viewDsn) {
        this.viewDsn = viewDsn;
    }

    public IPR.IprPrtForm getPrintFormat() {
        return this.printFormat;
    }

    public void setPrintFormat(IPR.IprPrtForm printFormat) {
        this.printFormat = printFormat;
    }

    @Override
    public String getPsbMember() {
        if (this.getAccessMode() == ImsAccessMode.STATIC) {
            return this.psbMember;
        }
        return "";
    }

    @Override
    public void setPsbMember(String psbMem) {
        this.psbMember = psbMem;
    }

    public String getPcbName() {
        if (this.getAccessMode() == ImsAccessMode.STATIC) {
            return this.pcbName;
        }
        return "";
    }

    @Override
    public void setPcbName(String pcbName) {
        this.pcbName = pcbName;
    }

    @Override
    public String getKeyRange() {
        return this.keyRange;
    }

    @Override
    public void setKeyRange(String keyRange) {
        this.keyRange = keyRange;
    }

    @Override
    public String getKeyList() {
        return this.keyList;
    }

    @Override
    public void setKeyList(String keyList) {
        this.keyList = keyList;
    }

    @Override
    public String getKeysFileDd() {
        return this.keysFileDd;
    }

    @Override
    public void setKeysFileDd(String keysFileDd) {
        this.keysFileDd = keysFileDd;
    }

    @Override
    public boolean isEditingDatabaseDataSets() {
        return this.regionType == ImsRegionType.DLI && this.editingDatabaseDataSets;
    }

    @Override
    public void setEditingDatabaseDataSets(boolean editingDatabaseDataSets) {
        this.editingDatabaseDataSets = editingDatabaseDataSets;
    }

    @Override
    public ImsDatabaseInfo getDatabaseInfo() {
        return this.dbInfo;
    }

    @Override
    public void setDatabaseInfo(ImsDatabaseInfo dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public String getMaxNumberSegments() {
        return this.maxNumberSegments;
    }

    @Override
    public void setMaxNumberSegments(String maxNumberSegments) {
        this.maxNumberSegments = maxNumberSegments;
    }

    @Override
    public String getPcbIndex() {
        if (this.getAccessMode() == ImsAccessMode.STATIC) {
            return this.pcbIndex;
        }
        return "";
    }

    @Override
    public void setPcbIndex(String pcbNum) {
        this.pcbIndex = pcbNum;
    }
}

