/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsBmpRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsDliRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsRegionSpecificQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.socket.func.ims.IPR;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.ims.ImsPrintActionItem;
import com.ibm.etools.fm.ui.wizards.ims.ImsPrintModel;
import com.ibm.etools.fm.ui.wizards.ims.ImsPrintWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class ImsPrintHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String COMMAND_ID = "com.ibm.etools.fm.ui.model.commands.ims.Print";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (host == null) {
            return;
        }
        ImsPrintHandler.doOpen(selected, host);
    }

    public static void doOpen(Object selected, IPDHost host) {
        ImsPrintModel model = new ImsPrintModel(host, (ImsRegionType)IPR.REGNTYPE.getDefaultValue());
        if (selected instanceof ImsSubsystem) {
            ImsSubsystem subsystem = (ImsSubsystem)selected;
            model.setSubsystemConfig(subsystem.getCanonicalConfig());
        } else if (selected instanceof ImsSubsystemConfig && ((ImsSubsystemConfig)selected).isConnectable()) {
            model.setSubsystemConfig(((ImsSubsystemConfig)selected).getSubsystem().getCanonicalConfig());
        } else if (selected instanceof ImsRegionConfig) {
            ImsRegionConfig regionConfig = (ImsRegionConfig)selected;
            model.setSubsystemConfig(regionConfig.getSubsystemConfig().getSubsystem().getCanonicalConfig());
            if (regionConfig instanceof ImsBmpRegionConfig && regionConfig.isConnectable()) {
                model.setRegionType(ImsRegionType.BMP);
            } else if (regionConfig instanceof ImsDliRegionConfig && regionConfig.isConnectable()) {
                model.setRegionType(ImsRegionType.DLI);
            }
        } else if (selected instanceof ImsRegionSpecificQuery) {
            ImsRegionSpecificQuery query = (ImsRegionSpecificQuery)selected;
            ImsSubsystemConfig config = query.getSubsystem().getCanonicalConfig();
            model.setSubsystemConfig(config);
            if (query instanceof ImsPsbQuery) {
                model.setAccessMode(ImsAccessMode.STATIC);
            } else if (query instanceof ImsDatabaseQuery) {
                model.setAccessMode(ImsAccessMode.DYNAMIC);
            }
        } else if (selected instanceof ImsDatabase) {
            ImsDatabase db = (ImsDatabase)selected;
            ImsSubsystemConfig config = db.getSubsystem().getCanonicalConfig();
            model.setSubsystemConfig(config);
            model.setDbdMember(db.getName());
            model.setAccessMode(ImsAccessMode.DYNAMIC);
        } else if (selected instanceof ImsPsb) {
            ImsPsb psb = (ImsPsb)selected;
            ImsSubsystemConfig config = psb.getSubsystem().getCanonicalConfig();
            model.setSubsystemConfig(config);
            model.setAccessMode(ImsAccessMode.STATIC);
            model.setPsbMember(psb.getName());
        } else if (selected instanceof ImsPcb) {
            ImsPcb pcb = (ImsPcb)selected;
            ImsSubsystemConfig config = pcb.getSubsystem().getCanonicalConfig();
            model.setSubsystemConfig(config);
            model.setDbdMember(pcb.getDbd().getName());
            model.setAccessMode(ImsAccessMode.STATIC);
            model.setDbdMember(pcb.getDbd().getName());
            model.setPsbMember(pcb.getPsb().getName());
            model.setPcbName(pcb.getName());
        } else if (selected instanceof ImsSubsystemProvider) {
            model.setSubsystemConfig(((ImsSubsystemProvider)selected).getSubsystem().getCanonicalConfig());
        } else {
            ImsSubsystemConfig config = ImsSubsystemLookupDialog.promptForValidConfig(host, null);
            if (config == null) {
                return;
            }
            model.setSubsystemConfig(config);
        }
        ImsPrintHandler.showImsPrintWizard(model);
    }

    public static void showImsPrintWizard(ImsPrintModel model) {
        Objects.requireNonNull(model, "Must provide a non-null session");
        ImsPrintWizard wizard = new ImsPrintWizard(model);
        final ImsPrintActionItem action = new ImsPrintActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

