/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractModel;
import com.ibm.etools.fm.ui.wizards.ims.ImsWizardProcessingKeysOptions;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ImsExtractWizardPageProcessing
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.ImsExtractWizardPageProcessing_ProcessingOptions;
    private final ImsExtractModel model;
    private ImsExtractWizardPageProcessingConnector controller = new ImsExtractWizardPageProcessingConnector();
    private ImsWizardProcessingKeysOptions wKeysCombos;
    private Button wWriteSdepTimestamp;
    private Combo wCriteria;

    protected ImsExtractWizardPageProcessing(ImsExtractModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.ImsExtractWizardPageProcessing_SpecifyProcessingOptsToRestrictExtract);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group processingGroup = GUI.group((Composite)parent, (String)PAGE_TITLE, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)processingGroup, (String)Messages.ImsExtractWizardPageProcessing_CriteriaDS, (Object)GUI.grid.d.left1());
        this.wCriteria = GUI.combo.editable((Composite)processingGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wCriteria.setToolTipText(Messages.ImsExtractWizardPageProcessing_CriteriaDSTooltip);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)processingGroup), this.wCriteria, (IHostProvider)this.model).types(DataSet.class, Member.class).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Criteria").create();
        this.wKeysCombos = new ImsWizardProcessingKeysOptions(this.model, this.controller, ((Object)((Object)this)).getClass(), processingGroup);
        this.wWriteSdepTimestamp = GUI.button.checkbox((Composite)processingGroup, (String)Messages.ImsExtractWizardPageProcessing_WriteSDEPTooltip, (Object)GUI.grid.d.fillH((int)3));
        this.controller.listenTo(this.model);
        this.controller.listenTo((Control)this.wCriteria);
        this.controller.listenTo((Control)this.wWriteSdepTimestamp);
        this.controller.doManualViewUpdate();
        this.wCriteria.setFocus();
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.controller.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if (!this.model.getCriteriaDsn().isEmpty() && !Member.isParseable((String)this.model.getCriteriaDsn(), (boolean)false, (String)this.model.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsExtractWizardPageProcessing_CriteriaDSInvalidError, this.model.getCriteriaDsn());
        }
        String keysMessage = this.wKeysCombos.getValidationErrorMessage();
        if (keysMessage != null) {
            return keysMessage;
        }
        return null;
    }

    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    private class ImsExtractWizardPageProcessingConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ImsExtractWizardPageProcessingConnector() {
        }

        protected void updateModelFromViewImpl() {
            ImsExtractWizardPageProcessing.this.wKeysCombos.updateModelFromViewImpl();
            ImsExtractWizardPageProcessing.this.model.setCriteriaDsn(ImsExtractWizardPageProcessing.this.wCriteria.getText());
            ImsExtractWizardPageProcessing.this.model.setWritingSdepTimestamp(ImsExtractWizardPageProcessing.this.wWriteSdepTimestamp.getSelection());
            ImsExtractWizardPageProcessing.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            ImsExtractWizardPageProcessing.this.wKeysCombos.updateViewFromModelImpl();
            ImsExtractWizardPageProcessingConnector.setText((Combo)ImsExtractWizardPageProcessing.this.wCriteria, (String)ImsExtractWizardPageProcessing.this.model.getCriteriaDsn());
            ImsExtractWizardPageProcessing.this.wWriteSdepTimestamp.setSelection(ImsExtractWizardPageProcessing.this.model.isWritingSdepTimestamp());
            ImsExtractWizardPageProcessing.this.wWriteSdepTimestamp.setEnabled(ImsExtractWizardPageProcessing.this.model.getRegionType() == ImsRegionType.BMP);
            String validationErrorMessage = ImsExtractWizardPageProcessing.this.getValidationErrorMessage();
            ImsExtractWizardPageProcessing.this.setPageComplete(validationErrorMessage == null);
            ImsExtractWizardPageProcessing.this.setErrorMessage(validationErrorMessage);
        }
    }
}

