/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractModel;
import com.ibm.etools.fm.ui.wizards.ims.ImsWizardFirstPageHeader;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ImsExtractWizardPageFirst
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.ImsExtractWizardPageFirst_BasicSettings;
    private final ImsExtractModel model;
    private ImsExtractWizardPageFirstConnector controller = new ImsExtractWizardPageFirstConnector();
    private Combo wUnloadDataSet;
    private Combo wOutputTemplate;
    private ImsWizardFirstPageHeader header;

    protected ImsExtractWizardPageFirst(ImsExtractModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.ImsExtractWizardPageFirst_EnterExtractParameters);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group inputGroup = GUI.group((Composite)parent, (String)Messages.ImsExtractWizardPageFirst_Input, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.header = new ImsWizardFirstPageHeader(this.model, this.controller, ((Object)((Object)this)).getClass(), inputGroup);
        Group outputGroup = GUI.group((Composite)parent, (String)Messages.ImsExtractWizardPageFirst_Output, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)outputGroup, (String)Messages.ImsExtractWizardPageFirst_UnloadDS, (Object)GUI.grid.d.left1());
        this.wUnloadDataSet = GUI.combo.editable((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wUnloadDataSet.setToolTipText(Messages.ImsExtractWizardPageFirst_UnloadDSToolTip);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)outputGroup), this.wUnloadDataSet, (IHostProvider)this.model).types(DataSet.class, Member.class).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Unload").create();
        GUI.label.left((Composite)outputGroup, (String)Messages.ImsExtractWizardPageFirst_CreateTemplate, (Object)GUI.grid.d.left1());
        this.wOutputTemplate = GUI.combo.editable((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wOutputTemplate.setToolTipText(Messages.ImsExtractWizardPageFirst_OutputTemplateTooltip);
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)outputGroup), this.wOutputTemplate, (IHostProvider)this.model).types(DataSet.class, Member.class).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "OutputTemplate").create();
        this.controller.listenTo(this.model);
        this.controller.listenTo((Control)this.wUnloadDataSet);
        this.controller.listenTo((Control)this.wOutputTemplate);
        this.controller.doManualViewUpdate();
        if (!this.header.setFocus()) {
            this.wUnloadDataSet.setFocus();
        }
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.controller.doManualViewUpdate();
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        String headerError = this.header.getValidationErrorMessage();
        if (headerError != null) {
            return headerError;
        }
        if (this.model.getUnloadDd().isEmpty()) {
            return Messages.ImsExtractWizardPageFirst_UnloadDSEmptyMessage;
        }
        if (!Member.isParseable((String)this.model.getUnloadDd(), (boolean)false, (String)this.model.getSystem().getCodePage())) {
            return MessageFormat.format(Messages.ImsExtractWizardPageFirst_UnloadDSBadNameError, this.model.getUnloadDd());
        }
        if (!(this.model.getOutputTemplate().isEmpty() || Member.isParseable((String)this.model.getOutputTemplate(), (boolean)false, (String)this.model.getSystem().getCodePage()) && ((DataSetOrMember)ZRLs.parseZRL((IPDHost)this.model.getHostProvider(), (String)this.model.getOutputTemplate())).asMember() != null)) {
            return MessageFormat.format(Messages.ImsExtractWizardPageFirst_OutputTemplateDSError, this.model.getOutputTemplate());
        }
        return null;
    }

    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    private class ImsExtractWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ImsExtractWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            ImsExtractWizardPageFirst.this.header.updateModelFromView();
            ImsExtractWizardPageFirst.this.model.setUnloadDd(ImsExtractWizardPageFirst.this.wUnloadDataSet.getText());
            ImsExtractWizardPageFirst.this.model.setOutputTemplate(ImsExtractWizardPageFirst.this.wOutputTemplate.getText());
            ImsExtractWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            ImsExtractWizardPageFirstConnector.setText((Combo)ImsExtractWizardPageFirst.this.wUnloadDataSet, (String)ImsExtractWizardPageFirst.this.model.getUnloadDd());
            ImsExtractWizardPageFirstConnector.setText((Combo)ImsExtractWizardPageFirst.this.wOutputTemplate, (String)ImsExtractWizardPageFirst.this.model.getOutputTemplate());
            ImsExtractWizardPageFirst.this.header.updateViewFromModel();
            String validationErrorMessage = ImsExtractWizardPageFirst.this.getValidationErrorMessage();
            ImsExtractWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            ImsExtractWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }
    }
}

