/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.core.socket.func.DSAQ;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractModel;
import com.ibm.etools.fm.ui.wizards.ims.ImsRunnable;
import com.ibm.pdtools.common.component.core.util.TypedRunnable;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;

public class ImsExtractRunnable
extends ImsRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public ImsExtractRunnable(ImsExtractModel model) {
        super(model);
    }

    private ImsExtractModel getModel() {
        return (ImsExtractModel)this.model;
    }

    @Override
    protected String getName() {
        return "Extracting data from IMS";
    }

    @Override
    protected boolean preWizardClose(IHowIsGoing monitor) {
        try {
            DataSetOrMember unloadTarget = Member.parse((IPDHost)this.getModel().getSystem(), (String)this.getModel().getUnloadDd());
            ImsExtractRunnable.loadDataSetDetails(unloadTarget, monitor);
            if (!unloadTarget.asDataSet().getConfirmedExists()) {
                unloadTarget = ImsExtractRunnable.ensureValidUnloadTarget(unloadTarget, monitor);
            } else if (unloadTarget.asDataSet().getType() != DataSetType.PS && unloadTarget.asDataSet().getType() != DataSetType.PDS && unloadTarget.asDataSet().getType() != DataSetType.LIBRARY) {
                PDDialogs.openErrorThreadSafe((String)Messages.ImsExtractRunnable_InvalidDSType, (String)MessageFormat.format(Messages.ImsExtractRunnable_IncorrectDSTypeNeedPSPDSOrLibrary, unloadTarget.asDataSet().getFormattedName()));
                unloadTarget = ImsExtractRunnable.ensureValidUnloadTarget(unloadTarget, monitor);
            } else if (!ImsExtractRunnable.isValidRecordFormat(unloadTarget.asDataSet())) {
                PDDialogs.openInfoThreadSafe((String)Messages.ImsExtractRunnable_InvalidRecFormat, (String)MessageFormat.format(Messages.ImsExtractRunnable_RecFormatNotVB, unloadTarget.asDataSet().getFormattedName()));
                unloadTarget = ImsExtractRunnable.ensureValidUnloadTarget(unloadTarget, monitor);
            } else if (!(unloadTarget.asDataSet().getType() != DataSetType.PDS && unloadTarget.asDataSet().getType() != DataSetType.LIBRARY || Member.isParseable((String)this.getModel().getUnloadDd(), (boolean)true, (String)this.getModel().getSystem().getCodePage()))) {
                String memberName = ImsExtractRunnable.promptForMemberName(unloadTarget.asDataSet(), false);
                unloadTarget = Member.create((DataSet)unloadTarget.asDataSet(), (String)memberName);
            }
            this.getModel().setUnloadDd(unloadTarget.getFormattedName());
            return super.preIMSWizardClose(monitor);
        }
        catch (InterruptedException e) {
            logger.trace((Object)"User cancelled pre-wizard close");
            return false;
        }
        catch (CommunicationException e) {
            logger.error((Object)"Failed to complete pre-extract checks", (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)Messages.ImsExtractRunnable_Error, (String)Messages.ImsExtractRunnable_FailedToCompletePreChecks, (String)ThrowableRenderer.renderShortForm((Throwable)e).toString());
            return false;
        }
    }

    private static void loadDataSetDetails(DataSetOrMember unloadTarget, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        DataSet candidateUnloadDataSet = unloadTarget.asDataSet();
        Result unloadRefreshResult = candidateUnloadDataSet.refreshSelf(monitor);
        if (!unloadRefreshResult.isSuccessfulWithoutWarnings()) {
            throw new CommunicationException(Messages.ImsExtractRunnable_FailedToCheckUnloadDS);
        }
    }

    private static boolean isValidRecordFormat(DataSet unloadTarget) {
        DataSetProperties props = unloadTarget.getProperties();
        String recfm = props.getPropertyValue("Record format");
        return DSAQ.QsamRecordFormat.VB.name().equals(recfm);
    }

    private static DataSetOrMember ensureValidUnloadTarget(DataSetOrMember originalUnloadTarget, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        boolean originalHasMember = originalUnloadTarget.asMember() != null;
        AllocateDataSetModel allocateParams = new AllocateDataSetModel();
        allocateParams.setHost(originalUnloadTarget.getSystem());
        allocateParams.setDataSetName(originalUnloadTarget.asDataSet().getFormattedName());
        allocateParams.setDataSetType(originalHasMember ? DataSetType.PDS : DataSetType.PS);
        allocateParams.setPossibleTypes(new DataSetType[]{DataSetType.PS, DataSetType.PDS, DataSetType.LIBRARY});
        allocateParams.setQSAMrecordFormat(DSAQ.QsamRecordFormat.VB);
        allocateParams.setQSAMrecordLength("32756");
        allocateParams.setQSAMblockSize("32760");
        allocateParams.setAllocationPrimary("50");
        allocateParams.setAllocationSecondary("50");
        allocateParams.setAllocationUnits(DSAQ.SpaceUnit.TRK);
        Member newUnloadTarget = null;
        while (newUnloadTarget == null) {
            Result<StringBuffer> result = ImsExtractRunnable.promptUserToAllocate(allocateParams);
            if (!result.isSuccessfulWithoutWarnings()) continue;
            DataSet candidateUnloadDataSet = DataSet.create((IPDHost)originalUnloadTarget.getSystem(), (String)allocateParams.getDataSetName());
            ImsExtractRunnable.loadDataSetDetails((DataSetOrMember)candidateUnloadDataSet, monitor);
            if (!candidateUnloadDataSet.getConfirmedExists()) {
                PDDialogs.openInfoThreadSafe((String)Messages.ImsExtractRunnable_AllocdDSNotFound, (String)MessageFormat.format(Messages.ImsExtractRunnable_AllocdDsNotFoundRetry, candidateUnloadDataSet.getFormattedName()));
                continue;
            }
            if (candidateUnloadDataSet.getType() != DataSetType.PS && candidateUnloadDataSet.getType() != DataSetType.PDS && candidateUnloadDataSet.getType() != DataSetType.LIBRARY) {
                PDDialogs.openErrorThreadSafe((String)Messages.ImsExtractRunnable_InvalidDSType, (String)MessageFormat.format(Messages.ImsExtractRunnable_IncorrectDSTypeNeedPSPDSOrLibrary, candidateUnloadDataSet.getFormattedName()));
                continue;
            }
            if (!ImsExtractRunnable.isValidRecordFormat(candidateUnloadDataSet)) {
                PDDialogs.openErrorThreadSafe((String)Messages.ImsExtractRunnable_InvalidRecFormat, (String)MessageFormat.format(Messages.ImsExtractRunnable_RecFormatNotVB, candidateUnloadDataSet.getFormattedName()));
                continue;
            }
            newUnloadTarget = candidateUnloadDataSet;
        }
        if (newUnloadTarget.asDataSet().getType() == DataSetType.PDS || newUnloadTarget.asDataSet().getType() == DataSetType.LIBRARY) {
            String memberName = originalHasMember ? originalUnloadTarget.asMember().getName() : ImsExtractRunnable.promptForMemberName(newUnloadTarget.asDataSet(), true);
            newUnloadTarget = Member.create((DataSet)newUnloadTarget.asDataSet(), (String)memberName);
        }
        return newUnloadTarget;
    }

    private static Result<StringBuffer> promptUserToAllocate(AllocateDataSetModel allocateParams) throws InterruptedException {
        final AllocateDataSetWizard wizard = AllocateDataSetWizard.create(allocateParams);
        final CountDownLatch latch = new CountDownLatch(1);
        final Result result = new Result(0);
        final AtomicInteger wizardOpenRCRef = new AtomicInteger(0);
        wizard.getRunnable().addCallback((Runnable)new TypedRunnable<Result<StringBuffer>, Void>(){

            public Void run(Result<StringBuffer> in) {
                if (!wizard.getRunnable().isCompletedSuccessfully()) {
                    result.setRC(8);
                    result.add(Messages.CommDSGCommand_DATASET_ALLOCATION_FAILED);
                }
                latch.countDown();
                return null;
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int returnValue = PDScrollableWizardDialog.openWizard((IWizard)wizard);
                wizardOpenRCRef.set(returnValue);
            }
        });
        int wizardReturn = wizardOpenRCRef.get();
        if (wizardReturn == 1) {
            throw new InterruptedException();
        }
        latch.await();
        return result;
    }

    private static String promptForMemberName(DataSet dataset, final boolean isAllocated) throws InterruptedException {
        final String dsn = dataset.getFormattedName();
        final String codepage = dataset.getSystem().getCodePage();
        final AtomicReference memName = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String msg = "";
                msg = isAllocated ? MessageFormat.format(Messages.ImsExtractRunnable_AllocdPDSButNoMember, dsn) : MessageFormat.format(Messages.ImsExtractRunnable_SpecifiedPDSButNoMember, dsn);
                InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), Messages.ImsExtractRunnable_EnterMemberName, msg, "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (!Member.isValidName((String)newText, (String)codepage)) {
                            return Messages.ImsExtractRunnable_InvalidMemberName;
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0) {
                    memName.set(dlg.getValue());
                }
            }
        });
        if (memName.get() == null) {
            throw new InterruptedException();
        }
        return (String)memName.get();
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result = super.execute(monitor);
        monitor.worked(1);
        PDSystemsTreeUpdater.refreshAllRelatedTo((Object)Member.parse((IPDHost)this.getModel().getSystem(), (String)this.getModel().getUnloadDd()));
        if (!this.getModel().getOutputTemplate().isEmpty()) {
            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)Member.parse((IPDHost)this.getModel().getSystem(), (String)this.getModel().getOutputTemplate()));
        }
        monitor.done();
        return result;
    }

    @Override
    public void showResult() {
        Result<StringBuffer> result = this.getResult();
        if (result != null) {
            if (result.getRC() > 4) {
                FMDialogWithText.showResultDump(result, false, 0);
            } else {
                FMDialogWithText.showResultDump(result, false, 0, new String[]{Messages.ImsExtractRunnable_ViewExtractedData}, new PDDialogWithText.ITextDialogRunnable[]{new PDDialogWithText.ITextDialogRunnable(){

                    public void run(PDDialogWithText context) {
                        DataSetOrMember unloadTarget = Member.parse((IPDHost)ImsExtractRunnable.this.getModel().getSystem(), (String)ImsExtractRunnable.this.getModel().getUnloadDd());
                        String templateDsn = ImsExtractRunnable.this.getModel().getOutputTemplate();
                        DataSetOrMember template = null;
                        if (Member.isParseable((String)templateDsn, (boolean)false, (String)ImsExtractRunnable.this.getModel().getSystem().getCodePage())) {
                            template = Member.parse((IPDHost)ImsExtractRunnable.this.getModel().getSystem(), (String)templateDsn);
                        }
                        context.close();
                        OpenFormatted.showFormattedEditorDialog(ImsExtractRunnable.this.getModel().getSystem(), (IZRL)unloadTarget, (IZRL)template, null, null);
                    }
                }});
            }
        }
    }
}

