/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.ims.IXB;
import com.ibm.etools.fm.core.socket.func.ims.RelatedDBToPCBMapping;
import com.ibm.etools.fm.ui.wizards.ims.ImsUtilFuncWizardModel;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.List;

public class ImsExtractModel
extends ImsUtilFuncWizardModel<IXB> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String IXBFuncCode = "IXB";
    private String unloadDd = "";
    private String dbdMember = "";
    private String criteriaDD = "";
    private String keyRange = "";
    private String keyList = "";
    private String keysFileDd = "";
    private String maxNumberSegments = "";
    private boolean writingSdepTimestamp = (Boolean)IXB.SDEPTSO.getDefaultValue();
    private String outputTemplate = "";
    private String psbMember = "";
    private String pcbName = "";
    private String pcbIndex = "";
    private boolean editingDatabaseDataSets = false;
    private ImsDatabaseInfo dbInfo = null;

    public ImsExtractModel(IPDHost host, ImsRegionType regionType) {
        super(host, IXBFuncCode);
        this.regionType = regionType;
    }

    protected ImsExtractModel clone() {
        ImsExtractModel copy = new ImsExtractModel(this.getHostProvider(), this.getRegionType());
        copy.setSubsystemConfig(this.getSubsystemConfig());
        copy.unloadDd = this.unloadDd;
        copy.regionType = this.regionType;
        copy.accessMode = this.accessMode;
        copy.dbdMember = this.dbdMember;
        copy.dbInfo = this.dbInfo;
        copy.criteriaDD = this.criteriaDD;
        copy.keysFileDd = this.keysFileDd;
        copy.writingSdepTimestamp = this.writingSdepTimestamp;
        copy.outputTemplate = this.outputTemplate;
        copy.psbMember = this.psbMember;
        copy.pcbName = this.pcbName;
        copy.pcbIndex = this.pcbIndex;
        copy.keyRange = this.keyRange;
        copy.keyList = this.keyList;
        copy.maxNumberSegments = this.maxNumberSegments;
        copy.editingDatabaseDataSets = this.editingDatabaseDataSets;
        return copy;
    }

    @Override
    public IXB toUtilityFunction() {
        IXB ixb = new IXB();
        ixb.setSubsystemConfig(this.getSubsystemConfig());
        ixb.setDD("UNLOAD", this.unloadDd.toUpperCase());
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.IMSID, (Object)this.getSubsystem().getSubsystemID(), this.getSubsystem().getSystem());
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.REGNTYPE, (Object)this.regionType, this.getSubsystem().getSystem());
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.PSBTYPE, (Object)this.accessMode, this.getSubsystem().getSystem());
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.DBDMEM, (Object)this.dbdMember, this.getSubsystem().getSystem());
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.CRITERIA, (Object)(!this.criteriaDD.isEmpty() ? 1 : 0), this.getSubsystem().getSystem());
        if (!this.criteriaDD.isEmpty()) {
            ixb.setDD("CRITDD", this.criteriaDD.toUpperCase());
        }
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.KEYRANGE, (Object)this.keyRange, this.getSubsystem().getSystem());
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.KEYLIST, (Object)this.keyList, this.getSubsystem().getSystem());
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.KEYEXT, (Object)(!this.keysFileDd.isEmpty() ? 1 : 0), this.getSubsystem().getSystem());
        if (!this.keysFileDd.isEmpty()) {
            ixb.setDD("KEYSFILE", this.keysFileDd.toUpperCase());
        }
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.MAXROOTS, (Object)this.maxNumberSegments, this.getSubsystem().getSystem());
        if (this.regionType == ImsRegionType.BMP) {
            ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.SDEPTSO, (Object)this.writingSdepTimestamp, this.getSubsystem().getSystem());
        }
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.TCREATE, (Object)(!this.outputTemplate.isEmpty() ? 1 : 0), this.getSubsystem().getSystem());
        if (!this.outputTemplate.isEmpty()) {
            ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.TDSNOUT, (Object)this.outputTemplate, this.getSubsystem().getSystem());
        }
        ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.PSBMEM, (Object)this.psbMember, this.getSubsystem().getSystem());
        if (!this.pcbIndex.isEmpty()) {
            ixb.setValue((NewUtilityFunction.IUtilFuncParam)IXB.PCBNUM, (Object)this.pcbIndex, this.getSubsystem().getSystem());
        }
        return ixb;
    }

    @Override
    public void fromUtilityFunction(IXB function) {
        this.unloadDd = function.getDD("UNLOAD");
        this.regionType = (ImsRegionType)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.REGNTYPE, this.provider);
        this.accessMode = (ImsAccessMode)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.PSBTYPE, this.provider);
        this.dbdMember = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.DBDMEM, this.provider);
        this.criteriaDD = function.getDD("CRITDD");
        this.keyRange = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.KEYRANGE, this.provider);
        this.keyList = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.KEYLIST, this.provider);
        this.keysFileDd = function.getDD("KEYSFILE");
        this.maxNumberSegments = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.MAXROOTS, this.provider);
        this.writingSdepTimestamp = (Boolean)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.SDEPTSO, this.provider);
        this.outputTemplate = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.TDSNOUT, this.provider);
        this.psbMember = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.PSBMEM, this.provider);
        this.pcbName = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.PCBNAME, this.provider);
        this.pcbIndex = (String)function.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)IXB.PCBNUM, this.provider);
    }

    @Override
    public void setSubsystemConfig(ImsSubsystemConfig config) {
        if (!config.isConnectable()) {
            throw new IllegalArgumentException();
        }
        if (this.regionType == ImsRegionType.BMP && !config.getBmpConfig().isConnectable()) {
            this.regionType = ImsRegionType.DLI;
        } else if (this.regionType == ImsRegionType.DLI && !config.getDliConfig().isConnectable()) {
            this.regionType = ImsRegionType.BMP;
        }
        if (this.regionType == ImsRegionType.BMP) {
            if (this.accessMode == ImsAccessMode.STATIC && !config.getBmpConfig().isStaticAccessSupported()) {
                this.accessMode = ImsAccessMode.DYNAMIC;
            } else if (this.accessMode == ImsAccessMode.DYNAMIC && !config.getBmpConfig().isDynamicAccessSupported()) {
                this.accessMode = ImsAccessMode.STATIC;
            }
        } else if (this.regionType == ImsRegionType.DLI) {
            if (this.accessMode == ImsAccessMode.STATIC && !config.getDliConfig().isStaticAccessSupported()) {
                this.accessMode = ImsAccessMode.DYNAMIC;
            } else if (this.accessMode == ImsAccessMode.DYNAMIC && !config.getDliConfig().isDynamicAccessSupported()) {
                this.accessMode = ImsAccessMode.STATIC;
            }
        }
        super.setSubsystemConfig(config);
    }

    @Override
    public List<ImsPcb> loadPossiblePcbs(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        monitor.beginTask(Messages.ImsExtractModel_0, 2);
        monitor.worked(1);
        return ImsPcb.loadPCBsFiltered((IHowIsGoing)monitor, (ImsSubsystem)this.getSubsystem(), (ImsSubsystemConfig)this.getSubsystemConfig(), (ImsRegionType)this.regionType, (String)this.psbMember, (String)this.dbdMember, (String)IXBFuncCode);
    }

    @Override
    public List<RelatedDBToPCBMapping> loadPossibleRelatedDBPcbs(IHowIsGoing monitor, String pcbNum) throws InterruptedException, CommunicationException {
        monitor.beginTask(Messages.ImsExtractModel_0, 2);
        monitor.worked(1);
        return ImsPcb.loadRelatedDatabasePCBs((IHowIsGoing)monitor, (ImsSubsystem)this.getSubsystem(), (ImsSubsystemConfig)this.getSubsystemConfig(), (ImsRegionType)this.regionType, (String)this.psbMember, (String)this.dbdMember, (String)IXBFuncCode, (String)pcbNum);
    }

    @Override
    public ImsDatabase getDatabase() {
        if (this.dbdMember.isEmpty()) {
            return null;
        }
        return new ImsDatabase(this.getSubsystem(), this.dbdMember);
    }

    public String getUnloadDd() {
        return this.unloadDd;
    }

    public void setUnloadDd(String unloadDd) {
        this.unloadDd = unloadDd;
    }

    @Override
    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    @Override
    public void setRegionType(ImsRegionType regionType) {
        this.regionType = regionType;
    }

    @Override
    public ImsAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void setAccessMode(ImsAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public String getDbdMember() {
        return this.dbdMember;
    }

    @Override
    public void setDbdMember(String dbdMemberName) {
        this.dbdMember = dbdMemberName;
    }

    public String getCriteriaDsn() {
        return this.criteriaDD;
    }

    public void setCriteriaDsn(String criteriaDsn) {
        this.criteriaDD = criteriaDsn;
    }

    @Override
    public String getKeyRange() {
        return this.keyRange;
    }

    @Override
    public void setKeyRange(String keyRange) {
        this.keyRange = keyRange;
    }

    @Override
    public String getKeyList() {
        return this.keyList;
    }

    @Override
    public void setKeyList(String keyList) {
        this.keyList = keyList;
    }

    @Override
    public String getKeysFileDd() {
        return this.keysFileDd;
    }

    @Override
    public void setKeysFileDd(String keysFileDd) {
        this.keysFileDd = keysFileDd;
    }

    @Override
    public String getMaxNumberSegments() {
        return this.maxNumberSegments;
    }

    @Override
    public void setMaxNumberSegments(String maxNumberSegments) {
        this.maxNumberSegments = maxNumberSegments;
    }

    public boolean isWritingSdepTimestamp() {
        return this.regionType == ImsRegionType.BMP && this.writingSdepTimestamp;
    }

    public void setWritingSdepTimestamp(boolean writingSdepTimestamp) {
        this.writingSdepTimestamp = writingSdepTimestamp;
    }

    public String getOutputTemplate() {
        return this.outputTemplate;
    }

    public void setOutputTemplate(String outputTemplate) {
        this.outputTemplate = outputTemplate;
    }

    @Override
    public String getPsbMember() {
        if (this.getAccessMode() == ImsAccessMode.STATIC) {
            return this.psbMember;
        }
        return "";
    }

    @Override
    public void setPsbMember(String psbMem) {
        this.psbMember = psbMem;
    }

    public String getPcbName() {
        if (this.getAccessMode() == ImsAccessMode.STATIC) {
            return this.pcbName;
        }
        return "";
    }

    @Override
    public void setPcbName(String pcbName) {
        this.pcbName = pcbName;
    }

    @Override
    public String getPcbIndex() {
        if (this.getAccessMode() == ImsAccessMode.STATIC) {
            return this.pcbIndex;
        }
        return "";
    }

    @Override
    public void setPcbIndex(String pcbNum) {
        this.pcbIndex = pcbNum;
    }

    @Override
    public boolean isEditingDatabaseDataSets() {
        return this.regionType == ImsRegionType.DLI && this.editingDatabaseDataSets;
    }

    @Override
    public void setEditingDatabaseDataSets(boolean editingDatabaseDataSets) {
        this.editingDatabaseDataSets = editingDatabaseDataSets;
    }

    @Override
    public ImsDatabaseInfo getDatabaseInfo() {
        return this.dbInfo;
    }

    @Override
    public void setDatabaseInfo(ImsDatabaseInfo dbInfo) {
        this.dbInfo = dbInfo;
    }
}

