/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.ims;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.socket.func.ims.IPR;
import com.ibm.etools.fm.core.socket.func.ims.IXB;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractModel;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractRunnable;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;

public class ImsExtractActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_SUBSYSTEM = "ssid";
    private static final String KEY_EDITING_DB_DSNS = "editingDbDsns";
    private ImsExtractModel model;

    public ImsExtractActionItem(ImsExtractModel model) {
        super(ActionType.IXB, Objects.requireNonNull(model, "Must specify a non-null model.").getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        return MessageFormat.format(Messages.ImsExtractActionItem_ExtractFromTo, this.model.getDbdMember(), this.model.getUnloadDd());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        memento.putString(KEY_SUBSYSTEM, this.model.getSubsystem().getSubsystemID());
        memento.putBoolean(KEY_EDITING_DB_DSNS, this.model.isEditingDatabaseDataSets());
        IXB utilFunc = this.model.toUtilityFunction();
        IActionItemSaver.saveParameterMapping(memento, utilFunc.getParameterValues());
        IActionItemSaver.saveDDs(memento, utilFunc.getDDs());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        IXB function = new IXB();
        function.setParameterValues(IActionItemSaver.loadParameterMapping(memento));
        function.setDDs(IActionItemSaver.loadDDs(memento));
        ImsExtractModel model = new ImsExtractModel(system, (ImsRegionType)IPR.REGNTYPE.getDefaultValue());
        String ssid = memento.getString(KEY_SUBSYSTEM);
        model.fromUtilityFunction(function);
        model.setSubsystemConfig(new ImsSubsystem(system, ssid).getCanonicalConfig());
        model.setEditingDatabaseDataSets(memento.getBoolean(KEY_EDITING_DB_DSNS));
        return new ImsExtractActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        ImsExtractRunnable runnable = new ImsExtractRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        if (!runnable.run()) {
            this.finishExecution(true);
        }
    }

    @Override
    public void modify() {
        this.beginExecution();
        final ImsExtractModel clone = this.model.clone();
        ImsExtractWizard wizard = new ImsExtractWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                ImsExtractActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
    }

    @Override
    public ImsExtractActionItem clone() {
        ImsExtractActionItem clone = new ImsExtractActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ImsExtractActionItem) {
            return this.model.equals((Object)((ImsExtractActionItem)obj).model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.model.hashCode();
    }
}

