/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintModel;
import com.ibm.etools.fm.ui.wizards.db2.IFmDb2WizardPage;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Db2PrintWizardPageFirst
extends WizardPage
implements IFmDb2WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.Db2PrintWizardPageFirst_TITLE;
    private final Db2PrintModel model;
    private Db2PrintWizardPageFirstConnector connector = new Db2PrintWizardPageFirstConnector();
    private Combo wSubsystem;
    private Button wSubsystemLookup;
    private Combo wObjectOwner;
    private Button wObjectOwnerLookup;
    private Combo wObjectName;
    private Button wObjectNameLookup;
    private Combo wTemplateIn;
    private Button wTemplateInEdit;
    private Button wFormatSingle;
    private Button wUncommittedRead;
    private Button wHex;
    private Combo wNullIndicator;
    private Combo wRows;

    protected Db2PrintWizardPageFirst(Db2PrintModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.Db2PrintWizardPageFirst_DEFAULT_MSG);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group systemGroup = GUI.group((Composite)parent, (String)Messages.__SYSTEM, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)systemGroup, (String)Messages.LABEL__DB2_SUBSYSTEM, (Object)GUI.grid.d.left1());
        this.wSubsystem = GUI.combo.editable((Composite)systemGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wSubsystem.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new ComboValueSaver(this.wSubsystem, this.getClass().getCanonicalName() + "Subsystem");
        this.wSubsystemLookup = LookupButton.createLookupButtonLeft1((Composite)systemGroup);
        this.wSubsystemLookup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2PrintWizardPageFirst.this.model.getHostProvider().getSystem());
                if (lookup.open() == 0) {
                    if (event.widget instanceof Button) {
                        ((Button)event.widget).setFocus();
                    }
                    Db2PrintWizardPageFirst.this.model.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    Db2PrintWizardPageFirst.this.model.fireModelChangeEvent();
                    Db2PrintWizardPageFirst.this.wSubsystem.setText(Db2PrintWizardPageFirst.this.model.getSubsystemSet());
                }
            }
        });
        Group objectGroup = GUI.group((Composite)parent, (String)Messages.Db2PrintWizardPageFirst_OBJECT_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Listener objectLookup = new Listener(){

            public void handleEvent(Event event) {
                Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2PrintWizardPageFirst.this.model.getSubsystem());
                lookup.setInitialOwnerPattern(Db2PrintWizardPageFirst.this.wObjectOwner.getText());
                lookup.setInitialNamePattern(Db2PrintWizardPageFirst.this.wObjectName.getText());
                if (lookup.open() == 0) {
                    if (event.widget instanceof Button) {
                        ((Button)event.widget).setFocus();
                    }
                    Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                    Db2PrintWizardPageFirst.this.model.setObject(selected);
                    Db2PrintWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        };
        GUI.label.left((Composite)objectGroup, (String)Messages.Db2PrintWizardPageFirst_OWNER, (Object)GUI.grid.d.left1());
        this.wObjectOwner = GUI.combo.editable((Composite)objectGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wObjectOwnerLookup = LookupButton.createLookupButtonLeft1((Composite)objectGroup);
        this.wObjectOwnerLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)objectGroup, (String)Messages.Db2PrintWizardPageFirst_NAME, (Object)GUI.grid.d.left1());
        this.wObjectName = GUI.combo.editable((Composite)objectGroup, (Object)GUI.grid.d.fillH((int)2));
        Db2TableContentProposals.addTo(this.wObjectOwner, this.wObjectName, this.model, this.getClass().getCanonicalName() + "Object");
        this.wObjectNameLookup = LookupButton.createLookupButtonLeft1((Composite)objectGroup);
        this.wObjectNameLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)objectGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateIn = GUI.combo.editable((Composite)objectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateInEdit = GUI.button.push((Composite)objectGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateInEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities2.openTemplateEditSession(new Db2TemplateOptions((Db2SubsystemProvider)Db2PrintWizardPageFirst.this.model.getObject(), (DataSetOrMember)Db2PrintWizardPageFirst.this.model.getTemplateIn()));
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)objectGroup), this.wTemplateIn, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2PrintWizardPageFirst.this.model.setTemplateIn(zrl.getFormattedName());
                    Db2PrintWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateIn").create();
        Group optionsGroup = GUI.group((Composite)parent, (String)Messages.Db2PrintWizardPageFirst_OPTS_GROUP, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2PrintWizardPageFirst_ROWS, (Object)GUI.grid.d.left1());
        this.wRows = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wRows, this.getClass().getCanonicalName() + "Rows");
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2PrintWizardPageFirst_NULL_INDICATOR, (Object)GUI.grid.d.left1());
        this.wNullIndicator = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wNullIndicator, this.getClass().getCanonicalName() + "NullIndicator");
        this.wFormatSingle = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2PrintWizardPageFirst_FORMAT_SINGLE, (Object)GUI.grid.d.fillH((int)2));
        this.wUncommittedRead = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2PrintWizardPageFirst_UNCOMMITTED_READ, (Object)GUI.grid.d.fillH((int)2));
        this.wHex = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2PrintWizardPageFirst_HEX, (Object)GUI.grid.d.fillH((int)2));
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wSubsystem);
        this.connector.listenTo((Control)this.wObjectOwner);
        this.connector.listenTo((Control)this.wObjectName);
        this.connector.listenTo((Control)this.wTemplateIn);
        this.connector.listenTo((Control)this.wFormatSingle);
        this.connector.listenTo((Control)this.wUncommittedRead);
        this.connector.listenTo((Control)this.wHex);
        this.connector.listenTo((Control)this.wNullIndicator);
        this.connector.listenTo((Control)this.wRows);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
            ModelViewConnector.guessFocus((Control)this.getControl());
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if (this.model.getSubsystem() == null) {
            return Messages.Db2PrintWizardPageFirst_INVALID_SUBSYSTEM;
        }
        if (!Db2Table.isValidName((IPDHost)this.model.getSystem(), (String)this.model.getObjectName())) {
            return Messages.Db2PrintWizardPageFirst_INVALID_OBJECT_NAME;
        }
        if (this.model.getTemplateInSet().length() > 0 && !Member.isParseable((String)this.model.getTemplateInSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2PrintWizardPageFirst_INVALID_TEMPLATE;
        }
        if (",".equals(this.model.getNullIndicator())) {
            return Messages.Db2PrintWizardPageFirst_INVALID_NULL_INDICATOR;
        }
        if (this.model.getNullIndicator().length() != 1) {
            return Messages.Db2PrintWizardPageFirst_NULL_IND_SINGLE_CHAR;
        }
        if (this.model.getRows().length() > 0 && !"ALL".equals(this.model.getRows()) && !UIValidator.isInRange(this.model.getRows(), 1, 99999999)) {
            return Messages.Db2PrintWizardPageFirst_INVALID_ROW_COUNT;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    @Override
    public boolean validateDb2Object() {
        Result result;
        Db2Table aTable = this.model.getObject();
        if (!ZrlLoaderDialogUtils.tableExists(aTable, result = new Result(), true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, aTable.getOwner(), aTable.getName()));
            return false;
        }
        return true;
    }

    private class Db2PrintWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private Db2PrintWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (Db2PrintWizardPageFirstConnector.focussed((Control)Db2PrintWizardPageFirst.this.wSubsystem)) {
                Db2PrintWizardPageFirst.this.model.setSubsystem(Db2PrintWizardPageFirst.this.wSubsystem.getText());
            }
            if (Db2PrintWizardPageFirstConnector.focussed((Control)Db2PrintWizardPageFirst.this.wObjectOwner)) {
                Db2PrintWizardPageFirst.this.model.setObjectOwner(Db2PrintWizardPageFirst.this.wObjectOwner.getText());
            }
            if (Db2PrintWizardPageFirstConnector.focussed((Control)Db2PrintWizardPageFirst.this.wObjectName)) {
                Db2PrintWizardPageFirst.this.model.setObjectName(Db2PrintWizardPageFirst.this.wObjectName.getText());
            }
            if (Db2PrintWizardPageFirstConnector.focussed((Control)Db2PrintWizardPageFirst.this.wTemplateIn)) {
                Db2PrintWizardPageFirst.this.model.setTemplateIn(Db2PrintWizardPageFirst.this.wTemplateIn.getText());
            }
            Db2PrintWizardPageFirst.this.model.setFormatSingle(Db2PrintWizardPageFirst.this.wFormatSingle.getSelection());
            Db2PrintWizardPageFirst.this.model.setUncommittedRead(Db2PrintWizardPageFirst.this.wUncommittedRead.getSelection());
            Db2PrintWizardPageFirst.this.model.setHex(Db2PrintWizardPageFirst.this.wHex.getSelection());
            if (Db2PrintWizardPageFirstConnector.focussed((Control)Db2PrintWizardPageFirst.this.wNullIndicator)) {
                Db2PrintWizardPageFirst.this.model.setNullIndicator(Db2PrintWizardPageFirst.this.wNullIndicator.getText());
            }
            if (Db2PrintWizardPageFirstConnector.focussed((Control)Db2PrintWizardPageFirst.this.wRows)) {
                Db2PrintWizardPageFirst.this.model.setRows(Db2PrintWizardPageFirst.this.wRows.getText());
            }
            Db2PrintWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(Db2PrintWizardPageFirst.this.wSubsystem, Db2PrintWizardPageFirst.this.model.getSubsystemSet());
            this.updateComboFromModelIfNeeded(Db2PrintWizardPageFirst.this.wObjectOwner, Db2PrintWizardPageFirst.this.model.getObjectOwner());
            this.updateComboFromModelIfNeeded(Db2PrintWizardPageFirst.this.wObjectName, Db2PrintWizardPageFirst.this.model.getObjectName());
            Db2PrintWizardPageFirst.this.wObjectOwnerLookup.setEnabled(Db2PrintWizardPageFirst.this.model.getSubsystem() != null);
            Db2PrintWizardPageFirst.this.wObjectNameLookup.setEnabled(Db2PrintWizardPageFirst.this.model.getSubsystem() != null);
            this.updateComboFromModelIfNeeded(Db2PrintWizardPageFirst.this.wTemplateIn, Db2PrintWizardPageFirst.this.model.getTemplateInSet());
            Db2PrintWizardPageFirst.this.wTemplateInEdit.setEnabled(Db2PrintWizardPageFirst.this.model.getObject() != null && Db2PrintWizardPageFirst.this.model.getTemplateIn() != null);
            Db2PrintWizardPageFirst.this.wFormatSingle.setSelection(Db2PrintWizardPageFirst.this.model.isFormatSingle());
            Db2PrintWizardPageFirst.this.wUncommittedRead.setSelection(Db2PrintWizardPageFirst.this.model.isUncommittedRead());
            Db2PrintWizardPageFirst.this.wHex.setSelection(Db2PrintWizardPageFirst.this.model.isHex());
            this.updateComboFromModelIfNeeded(Db2PrintWizardPageFirst.this.wNullIndicator, Db2PrintWizardPageFirst.this.model.getNullIndicator());
            this.updateComboFromModelIfNeeded(Db2PrintWizardPageFirst.this.wRows, Db2PrintWizardPageFirst.this.model.getRows());
            String validationErrorMessage = Db2PrintWizardPageFirst.this.getValidationErrorMessage();
            Db2PrintWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            Db2PrintWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }
    }
}

