/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.wizards.FMWizardResultHelper;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintModel;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;

public class Db2PrintRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Db2PrintModel model;

    public Db2PrintRunnable(Db2PrintModel model) {
        this.model = model;
    }

    @Override
    protected String getName() {
        return "Printing data from DB2";
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result;
        monitor.beginTask(this.getName(), 3000);
        monitor.worked(1000);
        try {
            result = this.model.execute(monitor);
        }
        catch (InterruptedException e) {
            result = null;
        }
        monitor.worked(1000);
        if (result != null && result.getRC() <= 4) {
            FMWizardResultHelper.displayResult(result, Messages.Db2PrintRunnable_DB2_PRINT_FAILED, monitor);
            monitor.worked(1000);
        }
        monitor.done();
        return result;
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 4);
    }
}

