/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.DBP;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.wizards.db2.Db2ObjectModelUtil;
import com.ibm.etools.fm.ui.wizards.db2.Db2UtilFuncWizardModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Objects;

public class Db2PrintModel
extends Db2UtilFuncWizardModel<DBP> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2PrintModel.class);
    private String objectOwner = "";
    private String objectName = "";
    private String templateIn = "";
    private boolean formatSingle;
    private boolean uncommittedRead;
    private boolean hex;
    private String nullIndicator = (String)DBP.NULLIND.getDefaultValue();
    private String rows = "ALL";

    public Db2PrintModel(IPDHost host) {
        super(host);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        DBP dbp = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSubsystem().getSystem(), (IPDConnectEndpoint)this.getSubsystem(), (UtilityFunction)dbp, (IHowIsGoing)monitor);
    }

    @Override
    public DBP toUtilityFunction() {
        this.guessDefaultDb2ObjectOwner();
        DBP dbp = new DBP();
        dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.FORMAT, (Object)(this.formatSingle ? DBP.DbpFormat.SINGLE : DBP.DbpFormat.TABLE), this.getSystem());
        dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.OBJIOWNR, (Object)Db2ObjectModelUtil.getObjectName(this.objectOwner), this.getSystem());
        dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.OBJINAME, (Object)Db2ObjectModelUtil.getObjectName(this.objectName), this.getSystem());
        dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.TMIN, (Object)this.templateIn, this.getSystem());
        dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.UCREAD, (Object)this.uncommittedRead, this.getSystem());
        if (this.hex) {
            dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.HEX, (Object)this.hex, this.getSystem());
        }
        dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.NULLIND, (Object)this.nullIndicator, this.getSystem());
        dbp.setValue((NewUtilityFunction.IUtilFuncParam)DBP.ROWS, (Object)this.rows, this.getSystem());
        return dbp;
    }

    @Override
    public void fromUtilityFunction(DBP dbp) {
        this.setFormatSingle(dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.FORMAT, this.getSystem()) == DBP.DbpFormat.SINGLE);
        this.setObjectOwner((String)dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.OBJIOWNR, this.getSystem()));
        this.setObjectName((String)dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.OBJINAME, this.getSystem()));
        this.setTemplateIn((String)dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.TMIN, this.getSystem()));
        this.setUncommittedRead((Boolean)dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.UCREAD, this.getSystem()));
        this.setHex((Boolean)dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.HEX, this.getSystem()));
        this.setNullIndicator((String)dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.NULLIND, this.getSystem()));
        this.setRows((String)dbp.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBP.ROWS, this.getSystem()));
    }

    private void guessDefaultDb2ObjectOwner() {
        if (this.objectOwner.isEmpty()) {
            try {
                AuthDetails auth = this.getSystem().getLogin(false);
                this.objectOwner = auth == null ? "" : auth.getUsername();
            }
            catch (InterruptedException e) {
                logger.trace((Object)"user cancelled providing backup owner for db2 object");
            }
        }
    }

    public Db2PrintModel clone() {
        Db2PrintModel clone = new Db2PrintModel(this.getSystem());
        clone.setSubsystem(this.getSubsystemSet());
        clone.objectOwner = Db2ObjectModelUtil.getObjectName(this.objectOwner);
        clone.objectName = Db2ObjectModelUtil.getObjectName(this.objectName);
        clone.templateIn = this.templateIn;
        clone.formatSingle = this.formatSingle;
        clone.uncommittedRead = this.uncommittedRead;
        clone.hex = this.hex;
        clone.nullIndicator = this.nullIndicator;
        clone.rows = this.rows;
        return clone;
    }

    public String getTemplateInSet() {
        return this.templateIn;
    }

    public Member getTemplateIn() {
        if (Member.isParseable((String)this.templateIn, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateIn).asMember();
        }
        return null;
    }

    public void setTemplateIn(String templateIn) {
        this.templateIn = templateIn;
    }

    public void setObject(Db2Table object) {
        Objects.requireNonNull(object, "Must provide a non-null object");
        if (!object.getSubsystem().equals((Object)this.getSubsystem())) {
            throw new IllegalArgumentException(object.getSubsystem().toString());
        }
        this.objectOwner = Db2ObjectModelUtil.getObjectName(object.getOwner());
        this.objectName = Db2ObjectModelUtil.getObjectName(object.getName());
    }

    public Db2Table getObject() {
        Db2Subsystem subSys = this.getSubsystem();
        if (subSys != null && Db2Table.isValidName((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectName)) && Db2Table.isValidOwner((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectOwner))) {
            return new Db2Table(subSys, Db2ObjectModelUtil.getObjectName(this.objectName), Db2ObjectModelUtil.getObjectName(this.objectOwner));
        }
        return null;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public void setObjectOwner(String objectOwner) {
        this.objectOwner = Db2ObjectModelUtil.getObjectName(objectOwner);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = Db2ObjectModelUtil.getObjectName(objectName);
    }

    public boolean isFormatSingle() {
        return this.formatSingle;
    }

    public void setFormatSingle(boolean formatSingle) {
        this.formatSingle = formatSingle;
    }

    public boolean isUncommittedRead() {
        return this.uncommittedRead;
    }

    public void setUncommittedRead(boolean uncommittedRead) {
        this.uncommittedRead = uncommittedRead;
    }

    public boolean isHex() {
        return this.hex;
    }

    public void setHex(boolean hex) {
        this.hex = hex;
    }

    public String getNullIndicator() {
        return this.nullIndicator;
    }

    public void setNullIndicator(String nullIndicator) {
        this.nullIndicator = nullIndicator;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }
}

