/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintActionItem;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class Db2PrintHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (host == null) {
            return;
        }
        Db2PrintHandler.doOpen(selected, host);
    }

    public static void doOpen(Object selected, IPDHost host) {
        Db2PrintModel model = new Db2PrintModel(host);
        if (selected instanceof Db2Subsystem) {
            model.setSubsystem((Db2Subsystem)selected);
        } else if (selected instanceof Db2ObjectQuery) {
            Db2ObjectQuery query = (Db2ObjectQuery)selected;
            model.setSubsystem(query.getSubsystem());
            model.setObjectOwner(Db2ObjectQuery.stripWildcards((String)query.getOwnerPattern()));
            model.setObjectName(Db2ObjectQuery.stripWildcards((String)query.getNamePattern()));
        } else if (selected instanceof Db2Table) {
            Db2Table table = (Db2Table)selected;
            model.setSubsystem(table.getSubsystem());
            model.setObject(table);
        }
        Db2PrintHandler.showDb2PrintWizard(model);
    }

    public static void showDb2PrintWizard(Db2PrintModel model) {
        Objects.requireNonNull(model, "Must specify a non-null model.");
        Db2PrintWizard wizard = new Db2PrintWizard(model);
        final Db2PrintActionItem action = new Db2PrintActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

