/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.func.db2.DBP;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintModel;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintRunnable;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Db2PrintActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String KEY_SUBSYSTEM = "ssid";
    private Db2PrintModel model;

    public Db2PrintActionItem(Db2PrintModel model) {
        super(ActionType.DBP, model.getSystem());
        this.model = model;
    }

    @Override
    public String getDefaultLabel() {
        Member template = this.model.getTemplateIn();
        if (template == null) {
            return MessageFormat.format(Messages.DSPActionItem_PRINT_LABEL, this.model.getObject().getFormattedName());
        }
        return MessageFormat.format(Messages.DSPActionItem_PRINT_XXX_USING_TEMPLATE_YYY, this.model.getObject().getFormattedName(), template.getFormattedName());
    }

    @Override
    public void saveTo(IMemento memento) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        memento.putString(KEY_SUBSYSTEM, this.model.getSubsystem().getName());
        IActionItemSaver.saveParameterMapping(memento, this.model.toUtilityFunction().getParameterValues());
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        DBP function = new DBP();
        Map<String, String> loadedParamValues = IActionItemSaver.loadParameterMapping(memento);
        function.setParameterValues(loadedParamValues);
        Db2PrintModel model = new Db2PrintModel(system);
        model.setSubsystem(memento.getString(KEY_SUBSYSTEM));
        model.fromUtilityFunction(function);
        return new Db2PrintActionItem(model);
    }

    @Override
    public void execute() {
        this.beginExecution();
        Db2PrintRunnable runnable = new Db2PrintRunnable(this.model);
        runnable.addCallback(this.getUpdateStateCallback(runnable));
        runnable.addCallback(this.getFinishExecutionCallBack());
        runnable.run();
    }

    @Override
    public void modify() {
        this.beginExecution();
        final Db2PrintModel clone = this.model.clone();
        Db2PrintWizard wizard = new Db2PrintWizard(clone);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                Db2PrintActionItem.this.model = clone;
            }
        });
        wizard.getRunnable().addCallback(this.getUpdateStateCallback(wizard.getRunnable()));
        wizard.getRunnable().addCallback(this.getFinishExecutionCallBack());
        if (PDScrollableWizardDialog.openWizard((IWizard)wizard) == 1) {
            this.finishExecution(true);
        }
    }

    @Override
    public Db2PrintActionItem clone() {
        Db2PrintActionItem clone = new Db2PrintActionItem(this.model.clone());
        this.syncState(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Db2PrintActionItem) {
            return this.model.equals(((Db2PrintActionItem)obj).model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public IPropertySource getPropertySource() {
        return new Db2PrintActionItemPropertySource(this.model);
    }

    private static class Db2PrintActionItemPropertySource
    implements IPropertySource {
        private static final Object KEY_OBJECT_OWNER = new Object();
        private static final Object KEY_OBJECT_NAME = new Object();
        private static final Object KEY_TEMPLATE_IN = new Object();
        private static final Object KEY_FORMAT_SINGLE = new Object();
        private static final Object KEY_UNCOMMITTED_READ = new Object();
        private static final Object KEY_HEX = new Object();
        private static final Object KEY_NULL_INDICATOR = new Object();
        private static final Object KEY_ROWS = new Object();
        private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_OBJECT_OWNER, Messages.Db2PrintActionItem_OBJ_OWNER), new PropertyDescriptor(KEY_OBJECT_NAME, Messages.Db2PrintActionItem_OBJ_NAME), new PropertyDescriptor(KEY_TEMPLATE_IN, Messages.Db2PrintActionItem_TEMPLATE_IN), new PropertyDescriptor(KEY_FORMAT_SINGLE, Messages.Db2PrintActionItem_FORMAT_SINGLE), new PropertyDescriptor(KEY_UNCOMMITTED_READ, Messages.Db2PrintActionItem_UNCOMMITTED_READ), new PropertyDescriptor(KEY_HEX, Messages.Db2PrintActionItem_HEX), new PropertyDescriptor(KEY_NULL_INDICATOR, Messages.Db2PrintActionItem_NULL_INDICATOR), new PropertyDescriptor(KEY_ROWS, Messages.Db2PrintActionItem_ROWS)};
        private Db2PrintModel model;

        public Db2PrintActionItemPropertySource(Db2PrintModel model) {
            this.model = model;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return DESCRIPTORS;
        }

        public Object getEditableValue() {
            return null;
        }

        public Object getPropertyValue(Object id) {
            if (KEY_OBJECT_OWNER.equals(id)) {
                return this.model.getObjectOwner();
            }
            if (KEY_OBJECT_NAME.equals(id)) {
                return this.model.getObjectName();
            }
            if (KEY_TEMPLATE_IN.equals(id)) {
                return this.model.getTemplateInSet();
            }
            if (KEY_FORMAT_SINGLE.equals(id)) {
                return this.model.isFormatSingle() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_UNCOMMITTED_READ.equals(id)) {
                return this.model.isUncommittedRead() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_HEX.equals(id)) {
                return this.model.isHex() ? com.ibm.pdtools.common.component.core.Messages.__TRUE : com.ibm.pdtools.common.component.core.Messages.__FALSE;
            }
            if (KEY_NULL_INDICATOR.equals(id)) {
                return this.model.getNullIndicator();
            }
            if (KEY_ROWS.equals(id)) {
                return this.model.getRows();
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

