/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.UIValidator;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.wizards.db2.Db2ImportModel;
import com.ibm.etools.fm.ui.wizards.db2.IFmDb2WizardPage;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Db2ImportWizardPageFirst
extends WizardPage
implements IFmDb2WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.Db2ImportWizardPageFirst_TITLE;
    private final Db2ImportModel model;
    private Db2ImportWizardPageFirstConnector connector = new Db2ImportWizardPageFirstConnector();
    private Combo wSubsystem;
    private Combo wResource;
    private Combo wVolume;
    private Combo wTemplateIn;
    private Button wTemplateInEdit;
    private Combo wObjectOwner;
    private Button wObjectOwnerLookup;
    private Combo wObjectName;
    private Button wObjectNameLookup;
    private Combo wTemplateOut;
    private Button wTemplateOutEdit;
    private Combo wAutoCommit;
    private Combo wStartPosition;
    private Combo wDuplicateMax;
    private Combo wRows;
    private Button wDeleteRows;
    private Button wUpdate;

    protected Db2ImportWizardPageFirst(Db2ImportModel model) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.Db2ImportWizardPageFirst_DEFAULT_MSG);
        this.model = model;
    }

    public void createControl(Composite parent) {
        parent = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group systemGroup = GUI.group((Composite)parent, (String)Messages.__SYSTEM, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)systemGroup, (String)Messages.LABEL__DB2_SUBSYSTEM, (Object)GUI.grid.d.left1());
        this.wSubsystem = GUI.combo.editable((Composite)systemGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wSubsystem.addVerifyListener(UIValidator.FORCE_UPPERCASE);
        new ComboValueSaver(this.wSubsystem, this.getClass().getCanonicalName() + "Subsystem");
        final Button wSubsystemLookup = LookupButton.createLookupButtonLeft1((Composite)systemGroup);
        wSubsystemLookup.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2ImportWizardPageFirst.this.model.getHostProvider().getSystem());
                if (lookup.open() == 0) {
                    wSubsystemLookup.setFocus();
                    Db2ImportWizardPageFirst.this.model.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    Db2ImportWizardPageFirst.this.model.fireModelChangeEvent();
                    Db2ImportWizardPageFirst.this.wSubsystem.setText(Db2ImportWizardPageFirst.this.model.getSubsystemSet());
                }
            }
        });
        Group sourceGroup = GUI.group((Composite)parent, (String)Messages.Db2ImportWizardPageFirst_SOURCE_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)sourceGroup, (String)Messages.Label__DATA_SET, (Object)GUI.grid.d.left1());
        this.wResource = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)2));
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)sourceGroup), this.wResource, (IHostProvider)this.model).types(DataSet.class, Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof DataSetOrMember) {
                    Db2ImportWizardPageFirst.this.model.setResource((DataSetOrMember)zrl);
                    Db2ImportWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "Resource").create();
        GUI.label.left((Composite)sourceGroup, (String)Messages.Label__VOLUME, (Object)GUI.grid.d.left1());
        this.wVolume = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wVolume, this.getClass().getCanonicalName() + "Volume");
        GUI.grid.padding((Composite)sourceGroup, (int)1);
        GUI.label.left((Composite)sourceGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateIn = GUI.combo.editable((Composite)sourceGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateInEdit = GUI.button.push((Composite)sourceGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateInEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities2.openTemplateEditSession(new Db2TemplateOptions((Db2SubsystemProvider)Db2ImportWizardPageFirst.this.model.getSubsystem(), (DataSetOrMember)Db2ImportWizardPageFirst.this.model.getTemplateIn()));
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)sourceGroup), this.wTemplateIn, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2ImportWizardPageFirst.this.model.setTemplateIn(zrl.getFormattedName());
                    Db2ImportWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateIn").create();
        Group destGroup = GUI.group((Composite)parent, (String)Messages.Db2ImportWizardPageFirst_DEST_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Listener objectLookup = new Listener(){

            public void handleEvent(Event event) {
                Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2ImportWizardPageFirst.this.model.getSubsystem());
                lookup.setInitialOwnerPattern(Db2ImportWizardPageFirst.this.wObjectOwner.getText());
                lookup.setInitialNamePattern(Db2ImportWizardPageFirst.this.wObjectName.getText());
                if (lookup.open() != 0) {
                    return;
                }
                if (event.widget instanceof Button) {
                    ((Button)event.widget).setFocus();
                }
                Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                Db2ImportWizardPageFirst.this.model.setObject(selected);
                Db2ImportWizardPageFirst.this.model.fireModelChangeEvent();
            }
        };
        GUI.label.left((Composite)destGroup, (String)Messages.Db2ImportWizardPageFirst_OWNER, (Object)GUI.grid.d.left1());
        this.wObjectOwner = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)2));
        this.wObjectOwnerLookup = LookupButton.createLookupButtonLeft1((Composite)destGroup);
        this.wObjectOwnerLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)destGroup, (String)Messages.Db2ImportWizardPageFirst_NAME, (Object)GUI.grid.d.left1());
        this.wObjectName = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)2));
        Db2TableContentProposals.addTo(this.wObjectOwner, this.wObjectName, this.model, this.getClass().getCanonicalName() + "Object");
        this.wObjectNameLookup = LookupButton.createLookupButtonLeft1((Composite)destGroup);
        this.wObjectNameLookup.addListener(13, objectLookup);
        GUI.label.left((Composite)destGroup, (String)Messages.Label__TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOut = GUI.combo.editable((Composite)destGroup, (Object)GUI.grid.d.fillH((int)1));
        this.wTemplateOutEdit = GUI.button.push((Composite)destGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.wTemplateOutEdit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TemplateEditorUtilities2.openTemplateEditSession(new Db2TemplateOptions((Db2SubsystemProvider)Db2ImportWizardPageFirst.this.model.getObject(), (DataSetOrMember)Db2ImportWizardPageFirst.this.model.getTemplateOut()));
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupButtonLeft1((Composite)destGroup), this.wTemplateOut, (IHostProvider)this.model).types(Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                if (zrl instanceof Member) {
                    Db2ImportWizardPageFirst.this.model.setTemplateOut(zrl.getFormattedName());
                    Db2ImportWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "TemplateOut").create();
        Group optionsGroup = GUI.group((Composite)parent, (String)Messages.Db2ImportWizardPageFirst_OPTS_GROUP, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2ImportWizardPageFirst_AUTO_COMMIT, (Object)GUI.grid.d.left1());
        this.wAutoCommit = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wAutoCommit, this.getClass().getCanonicalName() + "AutoCommit");
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2ImportWizardPageFirst_START_POS, (Object)GUI.grid.d.left1());
        this.wStartPosition = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wStartPosition, this.getClass().getCanonicalName() + "StartPosition");
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2ImportWizardPageFirst_DUP_MAX, (Object)GUI.grid.d.left1());
        this.wDuplicateMax = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wDuplicateMax, this.getClass().getCanonicalName() + "DuplicateMax");
        GUI.label.left((Composite)optionsGroup, (String)Messages.Db2ImportWizardPageFirst_IMPORT_COUNT, (Object)GUI.grid.d.left1());
        this.wRows = GUI.combo.editable((Composite)optionsGroup, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.wRows, this.getClass().getCanonicalName() + "Rows");
        this.wDeleteRows = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2ImportWizardPageFirst_DEL_ROWS, (Object)GUI.grid.d.fillH((int)2));
        this.wUpdate = GUI.button.checkbox((Composite)optionsGroup, (String)Messages.Db2ImportWizardPageFirst_UPDATE_DUPLICATES, (Object)GUI.grid.d.fillH((int)2));
        this.connector.listenTo(this.model);
        this.connector.listenTo((Control)this.wSubsystem);
        this.connector.listenTo((Control)this.wResource);
        this.connector.listenTo((Control)this.wVolume);
        this.connector.listenTo((Control)this.wTemplateIn);
        this.connector.listenTo((Control)this.wObjectOwner);
        this.connector.listenTo((Control)this.wObjectName);
        this.connector.listenTo((Control)this.wTemplateOut);
        this.connector.listenTo((Control)this.wUpdate);
        this.connector.listenTo((Control)this.wAutoCommit);
        this.connector.listenTo((Control)this.wStartPosition);
        this.connector.listenTo((Control)this.wDuplicateMax);
        this.connector.listenTo((Control)this.wDeleteRows);
        this.connector.listenTo((Control)this.wRows);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.connector.doManualViewUpdate();
            ModelViewConnector.guessFocus((Control)this.getControl());
        }
        super.setVisible(visible);
    }

    public String getValidationErrorMessage() {
        if (this.model.getSubsystem() == null) {
            return Messages.Db2ImportWizardPageFirst_INVALID_SUBSYSTEM;
        }
        if (!Member.isParseable((String)this.model.getResource(), (boolean)false, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2ImportWizardPageFirst_INVALID_SOURCE_DATA_SET;
        }
        if (this.model.getVolume().length() > 0 && !Volume.isValid((String)this.model.getVolume(), (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2ImportWizardPageFirst_INVALID_SOURCE_VOLSER;
        }
        if (!Member.isParseable((String)this.model.getTemplateInSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2ImportWizardPageFirst_INVALID_SOURCE_TEMPLATE;
        }
        if (!Db2Table.isValidName((IPDHost)this.model.getSystem(), (String)this.model.getObjectName())) {
            return Messages.Db2ImportWizardPageFirst_INVALID_DEST_OBJECT_NAME;
        }
        if (this.model.getTemplateOutSet().length() > 0 && !Member.isParseable((String)this.model.getTemplateOutSet(), (boolean)true, (String)this.model.getSystem().getCodePage())) {
            return Messages.Db2ImportWizardPageFirst_INVALID_DEST_TEMPLATE;
        }
        if (this.model.getAutoCommit().length() > 0 && !UIValidator.isInRange(this.model.getAutoCommit(), 0, Integer.MAX_VALUE)) {
            return Messages.Db2ImportWizardPageFirst_INVALID_AUTO_COMMIT;
        }
        if (this.model.getStartPosition().length() > 0 && !UIValidator.isInRange(this.model.getStartPosition(), 0, Integer.MAX_VALUE)) {
            return Messages.Db2ImportWizardPageFirst_INVALID_START_POS;
        }
        if (this.model.getDuplicateMax().length() > 0 && !"ALL".equals(this.model.getDuplicateMax()) && !UIValidator.isInRange(this.model.getDuplicateMax(), 0, Integer.MAX_VALUE)) {
            return Messages.Db2ImportWizardPageFirst_INVALID_DUP_MAX;
        }
        if (this.model.getRows().length() > 0 && !"ALL".equals(this.model.getRows()) && !UIValidator.isInRange(this.model.getRows(), 1, 99999999)) {
            return Messages.Db2ImportWizardPageFirst_INVALID_ROWS;
        }
        return null;
    }

    public void dispose() {
        this.connector.dispose();
        super.dispose();
    }

    @Override
    public boolean validateDb2Object() {
        Result result;
        Db2Table aTable = this.model.getObject();
        if (!ZrlLoaderDialogUtils.tableExists(aTable, result = new Result(), true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, aTable.getOwner(), aTable.getName()));
            return false;
        }
        return true;
    }

    private class Db2ImportWizardPageFirstConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private Db2ImportWizardPageFirstConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wSubsystem)) {
                Db2ImportWizardPageFirst.this.model.setSubsystem(Db2ImportWizardPageFirst.this.wSubsystem.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wResource)) {
                Db2ImportWizardPageFirst.this.model.setResource(Db2ImportWizardPageFirst.this.wResource.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wVolume)) {
                Db2ImportWizardPageFirst.this.model.setVolume(Db2ImportWizardPageFirst.this.wVolume.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wTemplateIn)) {
                Db2ImportWizardPageFirst.this.model.setTemplateIn(Db2ImportWizardPageFirst.this.wTemplateIn.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wObjectOwner)) {
                Db2ImportWizardPageFirst.this.model.setObjectOwner(Db2ImportWizardPageFirst.this.wObjectOwner.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wObjectName)) {
                Db2ImportWizardPageFirst.this.model.setObjectName(Db2ImportWizardPageFirst.this.wObjectName.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wTemplateOut)) {
                Db2ImportWizardPageFirst.this.model.setTemplateOut(Db2ImportWizardPageFirst.this.wTemplateOut.getText());
            }
            Db2ImportWizardPageFirst.this.model.setUpdate(Db2ImportWizardPageFirst.this.wUpdate.getSelection());
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wAutoCommit)) {
                Db2ImportWizardPageFirst.this.model.setAutoCommit(Db2ImportWizardPageFirst.this.wAutoCommit.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wStartPosition)) {
                Db2ImportWizardPageFirst.this.model.setStartPosition(Db2ImportWizardPageFirst.this.wStartPosition.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wDuplicateMax)) {
                Db2ImportWizardPageFirst.this.model.setDuplicateMax(Db2ImportWizardPageFirst.this.wDuplicateMax.getText());
            }
            if (Db2ImportWizardPageFirstConnector.focussed((Control)Db2ImportWizardPageFirst.this.wRows)) {
                Db2ImportWizardPageFirst.this.model.setRows(Db2ImportWizardPageFirst.this.wRows.getText());
            }
            Db2ImportWizardPageFirst.this.model.setDeleteRows(Db2ImportWizardPageFirst.this.wDeleteRows.getSelection());
            Db2ImportWizardPageFirst.this.model.fireModelChangeEvent();
        }

        public void updateViewFromModelImpl() {
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wSubsystem, Db2ImportWizardPageFirst.this.model.getSubsystemSet());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wResource, Db2ImportWizardPageFirst.this.model.getResource());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wVolume, Db2ImportWizardPageFirst.this.model.getVolume());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wTemplateIn, Db2ImportWizardPageFirst.this.model.getTemplateInSet());
            Db2ImportWizardPageFirst.this.wTemplateInEdit.setEnabled(Db2ImportWizardPageFirst.this.model.getTemplateIn() != null);
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wObjectOwner, Db2ImportWizardPageFirst.this.model.getObjectOwner());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wObjectName, Db2ImportWizardPageFirst.this.model.getObjectName());
            Db2ImportWizardPageFirst.this.wObjectOwnerLookup.setEnabled(Db2ImportWizardPageFirst.this.model.getSubsystem() != null);
            Db2ImportWizardPageFirst.this.wObjectNameLookup.setEnabled(Db2ImportWizardPageFirst.this.model.getSubsystem() != null);
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wTemplateOut, Db2ImportWizardPageFirst.this.model.getTemplateOutSet());
            Db2ImportWizardPageFirst.this.wTemplateOutEdit.setEnabled(Db2ImportWizardPageFirst.this.model.getObject() != null && Db2ImportWizardPageFirst.this.model.getTemplateOut() != null);
            Db2ImportWizardPageFirst.this.wUpdate.setSelection(Db2ImportWizardPageFirst.this.model.isUpdate());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wAutoCommit, Db2ImportWizardPageFirst.this.model.getAutoCommit());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wStartPosition, Db2ImportWizardPageFirst.this.model.getStartPosition());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wDuplicateMax, Db2ImportWizardPageFirst.this.model.getDuplicateMax());
            this.updateComboFromModelIfNeeded(Db2ImportWizardPageFirst.this.wRows, Db2ImportWizardPageFirst.this.model.getRows());
            Db2ImportWizardPageFirst.this.wDeleteRows.setSelection(Db2ImportWizardPageFirst.this.model.isDeleteRows());
            String validationErrorMessage = Db2ImportWizardPageFirst.this.getValidationErrorMessage();
            Db2ImportWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
            Db2ImportWizardPageFirst.this.setErrorMessage(validationErrorMessage);
        }
    }
}

