/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.ui.dialog.FMDialogWithText;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.etools.fm.ui.wizards.db2.Db2ImportModel;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;

public class Db2ImportRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Db2ImportModel model;

    public Db2ImportRunnable(Db2ImportModel model) {
        this.model = model;
    }

    @Override
    protected String getName() {
        return "Importing data into DB2";
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result<StringBuffer> result;
        monitor.beginTask(this.getName(), 3000);
        monitor.worked(1000);
        try {
            result = this.model.execute(monitor);
        }
        catch (InterruptedException e) {
            result = null;
        }
        monitor.done();
        return result;
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }

    @Override
    public void showResult() {
        FMDialogWithText.showResultDump(this.getResult(), false, 0);
    }
}

