/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.wizards.db2;

import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.DBI;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.wizards.db2.Db2ObjectModelUtil;
import com.ibm.etools.fm.ui.wizards.db2.Db2UtilFuncWizardModel;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Objects;

public class Db2ImportModel
extends Db2UtilFuncWizardModel<DBI> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2ImportModel.class);
    private String dsom = "";
    private String volume = "";
    private String templateIn = "";
    private String objectOwner = "";
    private String objectName = "";
    private String templateOut = "";
    private boolean update = false;
    private String autoCommit = "";
    private String startPosition = "";
    private String duplicateMax = "";
    private boolean deleteRows = false;
    private String rows = "";

    public Db2ImportModel(IPDHost host) {
        super(host);
    }

    public Result<StringBuffer> execute(IHowIsGoing monitor) throws InterruptedException {
        DBI dbi = this.toUtilityFunction();
        return UtilityFunctionRunner.execute((IPDHost)this.getSubsystem().getSystem(), (IPDConnectEndpoint)this.getSubsystem(), (UtilityFunction)dbi, (IHowIsGoing)monitor);
    }

    @Override
    public DBI toUtilityFunction() {
        this.guessDefaultDb2ObjectOwner();
        DBI dbi = new DBI();
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.DSNIN, (Object)this.dsom, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.VOLSER, (Object)this.volume, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.TCIN, (Object)this.templateIn, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.OBJOOWNR, (Object)Db2ObjectModelUtil.getObjectName(this.objectOwner), this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.OBJONAME, (Object)Db2ObjectModelUtil.getObjectName(this.objectName), this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.TMOUT, (Object)this.templateOut, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.UPDATE, (Object)this.update, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.AUTOCOMMIT, (Object)this.autoCommit, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.STARTPOS, (Object)this.startPosition, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.DUPMAX, (Object)this.duplicateMax, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.DELROWS, (Object)this.deleteRows, this.getSystem());
        dbi.setValue((NewUtilityFunction.IUtilFuncParam)DBI.ROWS, (Object)this.rows, this.getSystem());
        return dbi;
    }

    @Override
    public void fromUtilityFunction(DBI dbi) {
        this.setResource((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.DSNIN, this.getSystem()));
        this.setVolume((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.VOLSER, this.getSystem()));
        this.setTemplateIn((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.TCIN, this.getSystem()));
        this.setObjectOwner((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.OBJOOWNR, this.getSystem()));
        this.setObjectName((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.OBJONAME, this.getSystem()));
        this.setTemplateOut((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.TMOUT, this.getSystem()));
        this.setUpdate((Boolean)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.UPDATE, this.getSystem()));
        this.setAutoCommit((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.AUTOCOMMIT, this.getSystem()));
        this.setStartPosition((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.STARTPOS, this.getSystem()));
        this.setDuplicateMax((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.DUPMAX, this.getSystem()));
        this.setDeleteRows((Boolean)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.DELROWS, this.getSystem()));
        this.setRows((String)dbi.getValueOrDefault((NewUtilityFunction.IUtilFuncParam)DBI.ROWS, this.getSystem()));
    }

    private void guessDefaultDb2ObjectOwner() {
        if (this.objectOwner.isEmpty()) {
            try {
                AuthDetails auth = this.getSystem().getLogin(false);
                this.objectOwner = auth == null ? "" : auth.getUsername();
            }
            catch (InterruptedException e) {
                logger.trace((Object)"user cancelled providing backup owner for db2 object");
            }
        }
    }

    public Db2ImportModel clone() {
        Db2ImportModel clone = new Db2ImportModel(this.getSystem());
        clone.setSubsystem(this.getSubsystemSet());
        clone.dsom = this.dsom;
        clone.volume = this.volume;
        clone.templateIn = this.templateIn;
        clone.objectOwner = Db2ObjectModelUtil.getObjectName(this.objectOwner);
        clone.objectName = Db2ObjectModelUtil.getObjectName(this.objectName);
        clone.templateOut = this.templateOut;
        clone.update = this.update;
        clone.autoCommit = this.autoCommit;
        clone.startPosition = this.startPosition;
        clone.duplicateMax = this.duplicateMax;
        clone.deleteRows = this.deleteRows;
        clone.rows = this.rows;
        return clone;
    }

    public void setResource(DataSetOrMember dsom) {
        this.dsom = Objects.requireNonNull(dsom, "Must provide a non-null dsom").getFormattedName();
    }

    public void setResource(String dsom) {
        this.dsom = Objects.requireNonNull(dsom, "Must provide a non-null dsom");
    }

    public String getResource() {
        return this.dsom;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volser) {
        this.volume = volser;
    }

    public String getTemplateInSet() {
        return this.templateIn;
    }

    public Member getTemplateIn() {
        if (Member.isParseable((String)this.templateIn, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateIn).asMember();
        }
        return null;
    }

    public void setTemplateIn(String templateIn) {
        this.templateIn = templateIn;
    }

    public void setObject(Db2Table object) {
        Objects.requireNonNull(object, "Must provide a non-null object");
        if (!object.getSubsystem().equals((Object)this.getSubsystem())) {
            throw new IllegalArgumentException(object.getSubsystem().toString());
        }
        this.objectOwner = Db2ObjectModelUtil.getObjectName(object.getOwner());
        this.objectName = Db2ObjectModelUtil.getObjectName(object.getName());
    }

    public Db2Table getObject() {
        Db2Subsystem subSys = this.getSubsystem();
        if (subSys != null && Db2Table.isValidName((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectName)) && Db2Table.isValidOwner((IPDHost)subSys.getSystem(), (String)Db2ObjectModelUtil.getObjectName(this.objectOwner))) {
            return new Db2Table(subSys, Db2ObjectModelUtil.getObjectName(this.objectName), Db2ObjectModelUtil.getObjectName(this.objectOwner));
        }
        return null;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public void setObjectOwner(String objectOwner) {
        this.objectOwner = Db2ObjectModelUtil.getObjectName(objectOwner);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = Db2ObjectModelUtil.getObjectName(objectName);
    }

    public String getTemplateOutSet() {
        return this.templateOut;
    }

    public Member getTemplateOut() {
        if (Member.isParseable((String)this.templateOut, (boolean)true, (String)this.getSystem().getCodePage())) {
            return Member.parse((IPDHost)this.getSystem(), (String)this.templateOut).asMember();
        }
        return null;
    }

    public void setTemplateOut(String templateOut) {
        this.templateOut = templateOut;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public String getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(String autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public String getDuplicateMax() {
        return this.duplicateMax;
    }

    public void setDuplicateMax(String duplicateMax) {
        this.duplicateMax = duplicateMax;
    }

    public boolean isDeleteRows() {
        return this.deleteRows;
    }

    public void setDeleteRows(boolean deleteRows) {
        this.deleteRows = deleteRows;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }
}

